/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzebr;
import com.google.android.gms.internal.zzebx;
import com.google.android.gms.internal.zzebz;
import com.google.android.gms.internal.zzecm;
import com.google.android.gms.internal.zzecn;
import com.google.android.gms.internal.zzeco;
import com.google.android.gms.internal.zzecq;
import com.google.android.gms.internal.zzecs;
import com.google.android.gms.internal.zzecu;
import com.google.android.gms.internal.zzedi;
import com.google.android.gms.internal.zzega;
import com.google.android.gms.internal.zzegc;
import com.google.android.gms.internal.zzegf;
import com.google.android.gms.internal.zzegj;
import com.google.android.gms.internal.zzegm;
import com.google.android.gms.internal.zzehg;
import com.google.android.gms.internal.zzehm;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzejz;
import com.google.android.gms.internal.zzekb;
import com.google.android.gms.internal.zzekk;
import com.google.android.gms.internal.zzekp;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.QueryListenOptions;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.zzh;
import com.google.firebase.firestore.zzi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class Query {
    final zzeco zzmoe;
    final FirebaseFirestore zzmnd;

    Query(zzeco zzeco2, FirebaseFirestore firebaseFirestore) {
        this.zzmoe = (zzeco)zzbp.zzu((Object)zzeco2);
        this.zzmnd = (FirebaseFirestore)zzbp.zzu((Object)firebaseFirestore);
    }

    @NonNull
    public FirebaseFirestore getFirestore() {
        return this.zzmnd;
    }

    private static void zza(zzegj zzegj2, zzegj zzegj3) {
        if (!zzegj2.equals(zzegj3)) {
            String string = ((zzega)zzegj3).zzbzf();
            throw new IllegalArgumentException(String.format("Invalid query. You have an inequality where filter (whereLessThan(), whereGreaterThan(), etc.) on field '%s' and so you must also have '%s' as your first orderBy() field, but your first orderBy() is currently on field '%s' instead.", string, string, ((zzega)zzegj2).zzbzf()));
        }
    }

    @NonNull
    public Query whereEqualTo(@NonNull String string, Object object) {
        return this.zza(FieldPath.zzqc(string), zzecu.zzmsc, object);
    }

    @NonNull
    public Query whereEqualTo(@NonNull FieldPath fieldPath, Object object) {
        return this.zza(fieldPath, zzecu.zzmsc, object);
    }

    @NonNull
    public Query whereLessThan(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zzqc(string), zzecu.zzmsa, object);
    }

    @NonNull
    public Query whereLessThan(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzecu.zzmsa, object);
    }

    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zzqc(string), zzecu.zzmsb, object);
    }

    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzecu.zzmsb, object);
    }

    @NonNull
    public Query whereGreaterThan(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zzqc(string), zzecu.zzmsd, object);
    }

    @NonNull
    public Query whereGreaterThan(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzecu.zzmsd, object);
    }

    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zzqc(string), zzecu.zzmse, object);
    }

    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzecu.zzmse, object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Query zza(@NonNull FieldPath fieldPath, zzecu zzecu2, Object object) {
        zzehg zzehg2;
        Object object2;
        block8: {
            block9: {
                zzbp.zzb((Object)fieldPath, (Object)"Provided field path must not be null.");
                zzbp.zzb((Object)((Object)zzecu2), (Object)"Provided op must not be null.");
                if (!fieldPath.zzbyt().equals(zzegj.zzmxg)) break block9;
                if (object instanceof String) {
                    object2 = (String)object;
                    if (((String)object2).contains("/")) {
                        throw new IllegalArgumentException(new StringBuilder(127 + String.valueOf(object2).length()).append("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but '").append((String)object2).append("' contains a '/' character.").toString());
                    }
                    if (((String)object2).isEmpty()) {
                        throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but it was an empty string.");
                    }
                    zzegm zzegm2 = (zzegm)this.zzmoe.zzbzm().zzql((String)object2);
                    zzejo.zzc(zzegm2.length() % 2 == 0, "Path should be a document key", new Object[0]);
                    zzehg2 = zzehm.zza(this.getFirestore().zzbyw(), zzegf.zzb(zzegm2));
                    break block8;
                } else if (object instanceof DocumentReference) {
                    object2 = (DocumentReference)object;
                    zzehg2 = zzehm.zza(this.getFirestore().zzbyw(), ((DocumentReference)object2).zzbyq());
                    break block8;
                } else {
                    String string;
                    String string2 = String.valueOf(zzekp.zzca(object));
                    if (string2.length() != 0) {
                        string = "Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: ".concat(string2);
                        throw new IllegalArgumentException(string);
                    }
                    string = new String("Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: ");
                    throw new IllegalArgumentException(string);
                }
            }
            zzehg2 = this.zzmnd.zzbyx().zzbv(object);
        }
        Object object3 = object2 = zzecs.zza(fieldPath.zzbyt(), zzecu2, zzehg2);
        Query query = this;
        if (!(object3 instanceof zzecs)) return new Query(this.zzmoe.zza((zzebz)object2), this.zzmnd);
        if (!((zzecs)object3).zzcab()) return new Query(this.zzmoe.zza((zzebz)object2), this.zzmnd);
        zzegj zzegj2 = query.zzmoe.zzbzt();
        zzegj zzegj3 = object3.zzbzh();
        if (zzegj2 != null && !zzegj2.equals(zzegj3)) {
            throw new IllegalArgumentException(String.format("All where filters other than whereEqualTo() must be on the same field. But you have filters on '%s' and '%s'", ((zzega)zzegj2).zzbzf(), ((zzega)zzegj3).zzbzf()));
        }
        zzegj zzegj4 = query.zzmoe.zzbzs();
        if (zzegj4 == null) return new Query(this.zzmoe.zza((zzebz)object2), this.zzmnd);
        Query.zza(zzegj4, zzegj3);
        return new Query(this.zzmoe.zza((zzebz)object2), this.zzmnd);
    }

    @NonNull
    public Query orderBy(@NonNull String string) {
        return this.orderBy(FieldPath.zzqc(string), Direction.ASCENDING);
    }

    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath) {
        zzbp.zzb((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(fieldPath.zzbyt(), Direction.ASCENDING);
    }

    @NonNull
    public Query orderBy(@NonNull String string, @NonNull Direction direction) {
        return this.orderBy(FieldPath.zzqc(string), direction);
    }

    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath, @NonNull Direction direction) {
        zzbp.zzb((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(fieldPath.zzbyt(), direction);
    }

    private final Query zza(@NonNull zzegj zzegj2, @NonNull Direction direction) {
        zzbp.zzb((Object)((Object)direction), (Object)"Provided direction must not be null.");
        if (this.zzmoe.zzbzq() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.startAt() or Query.startAfter() before calling Query.orderBy().");
        }
        if (this.zzmoe.zzbzr() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.endAt() or Query.endAfter() before calling Query.orderBy().");
        }
        zzegj zzegj3 = zzegj2;
        Query query = this;
        zzegj zzegj4 = query.zzmoe.zzbzt();
        if (query.zzmoe.zzbzs() == null && zzegj4 != null) {
            Query.zza(zzegj3, zzegj4);
        }
        zzecn zzecn2 = direction == Direction.ASCENDING ? zzecn.zzmre : zzecn.zzmrf;
        return new Query(this.zzmoe.zza(zzecm.zza(zzecn2, zzegj2)), this.zzmnd);
    }

    @NonNull
    public Query limit(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(85).append("Invalid Query. Query limit (").append(l).append(") is invalid. Limit must be positive.").toString());
        }
        return new Query(this.zzmoe.zzca(l), this.zzmnd);
    }

    @NonNull
    public Query startAt(@NonNull DocumentSnapshot documentSnapshot) {
        zzebr zzebr2 = this.zza("startAt", documentSnapshot, true);
        return new Query(this.zzmoe.zza(zzebr2), this.zzmnd);
    }

    @NonNull
    public Query startAt(Object ... objectArray) {
        zzebr zzebr2 = this.zza("startAt", objectArray, true);
        return new Query(this.zzmoe.zza(zzebr2), this.zzmnd);
    }

    @NonNull
    public Query startAfter(@NonNull DocumentSnapshot documentSnapshot) {
        zzebr zzebr2 = this.zza("startAfter", documentSnapshot, false);
        return new Query(this.zzmoe.zza(zzebr2), this.zzmnd);
    }

    @NonNull
    public Query startAfter(Object ... objectArray) {
        zzebr zzebr2 = this.zza("startAfter", objectArray, false);
        return new Query(this.zzmoe.zza(zzebr2), this.zzmnd);
    }

    @NonNull
    public Query endBefore(@NonNull DocumentSnapshot documentSnapshot) {
        zzebr zzebr2 = this.zza("endBefore", documentSnapshot, true);
        return new Query(this.zzmoe.zzb(zzebr2), this.zzmnd);
    }

    @NonNull
    public Query endBefore(Object ... objectArray) {
        zzebr zzebr2 = this.zza("endBefore", objectArray, true);
        return new Query(this.zzmoe.zzb(zzebr2), this.zzmnd);
    }

    @NonNull
    public Query endAt(@NonNull DocumentSnapshot documentSnapshot) {
        zzebr zzebr2 = this.zza("endAt", documentSnapshot, false);
        return new Query(this.zzmoe.zzb(zzebr2), this.zzmnd);
    }

    @NonNull
    public Query endAt(Object ... objectArray) {
        zzebr zzebr2 = this.zza("endAt", objectArray, false);
        return new Query(this.zzmoe.zzb(zzebr2), this.zzmnd);
    }

    private final zzebr zza(String string, DocumentSnapshot documentSnapshot, boolean bl) {
        zzbp.zzb((Object)documentSnapshot, (Object)"Provided snapshot must not be null.");
        if (!documentSnapshot.exists()) {
            throw new IllegalArgumentException(new StringBuilder(70 + String.valueOf(string).length()).append("Can't use a DocumentSnapshot for a document that doesn't exist for ").append(string).append("().").toString());
        }
        zzegc zzegc2 = documentSnapshot.zzbyr();
        ArrayList<zzehg> arrayList = new ArrayList<zzehg>();
        for (zzecm zzecm2 : this.zzmoe.zzbzv()) {
            if (zzecm2.zzbzh().equals(zzegj.zzmxg)) {
                arrayList.add(zzehm.zza(this.zzmnd.zzbyw(), zzegc2.zzbyq()));
                continue;
            }
            zzehg zzehg2 = zzegc2.zzb(zzecm2.zzbzh());
            if (zzehg2 != null) {
                arrayList.add(zzehg2);
                continue;
            }
            String string2 = String.valueOf(zzecm2.zzbzh());
            throw new IllegalArgumentException(new StringBuilder(131 + String.valueOf(string2).length()).append("Invalid query. You are trying to start or end a query using a document for which the field '").append(string2).append("' (used as the orderBy) does not exist.").toString());
        }
        return new zzebr(arrayList, bl);
    }

    private final zzebr zza(String string, Object[] objectArray, boolean bl) {
        List<zzecm> list = this.zzmoe.zzbzu();
        if (objectArray.length > list.size()) {
            throw new IllegalArgumentException(new StringBuilder(121 + String.valueOf(string).length()).append("Too many arguments provided to ").append(string).append("(). The number of arguments must be less than or equal to the number of orderBy() clauses.").toString());
        }
        ArrayList<zzehg> arrayList = new ArrayList<zzehg>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2 = objectArray[i];
            if (list.get(i).zzbzh().equals(zzegj.zzmxg)) {
                if (!(object2 instanceof String)) {
                    object = String.valueOf(object2);
                    throw new IllegalArgumentException(new StringBuilder(65 + String.valueOf(string).length() + String.valueOf(object).length()).append("Invalid query. Expected a string for document ID in ").append(string).append("(), but got ").append((String)object).append(".").toString());
                }
                object = (String)object2;
                if (((String)object).contains("/")) {
                    throw new IllegalArgumentException(new StringBuilder(53 + String.valueOf(object).length() + String.valueOf(string).length()).append("Invalid query. Document ID '").append((String)object).append("' contains a slash in ").append(string).append("().").toString());
                }
                zzegf zzegf2 = zzegf.zzb((zzegm)this.zzmoe.zzbzm().zzql((String)object));
                arrayList.add(zzehm.zza(this.zzmnd.zzbyw(), zzegf2));
                continue;
            }
            object = this.zzmnd.zzbyx().zzbv(object2);
            arrayList.add((zzehg)object);
        }
        return new zzebr(arrayList, bl);
    }

    @NonNull
    public Task<QuerySnapshot> get() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzebx zzebx2 = new zzebx();
        new zzebx().zzmoi = true;
        zzebx2.zzmoh = true;
        zzebx2.zzmqf = true;
        ListenerRegistration listenerRegistration = this.zza(zzekb.zzdfn, zzebx2, null, new zzh(taskCompletionSource, taskCompletionSource2));
        taskCompletionSource2.setResult((Object)listenerRegistration);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(new QueryListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(executor, new QueryListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(activity, new QueryListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull QueryListenOptions queryListenOptions, @NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(zzekb.zzndq, queryListenOptions, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull QueryListenOptions queryListenOptions, @NonNull EventListener<QuerySnapshot> eventListener) {
        zzbp.zzb((Object)executor, (Object)"Provided executor must not be null.");
        zzbp.zzb((Object)queryListenOptions, (Object)"Provided listen options must not be null.");
        zzbp.zzb(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(executor, Query.zza(queryListenOptions), null, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull QueryListenOptions queryListenOptions, @NonNull EventListener<QuerySnapshot> eventListener) {
        zzbp.zzb((Object)activity, (Object)"Provided activity must not be null.");
        zzbp.zzb((Object)queryListenOptions, (Object)"Provided listen options must not be null.");
        zzbp.zzb(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzekb.zzndq, Query.zza(queryListenOptions), activity, eventListener);
    }

    private final ListenerRegistration zza(Executor executor, zzebx zzebx2, Activity activity, EventListener<QuerySnapshot> eventListener) {
        zzejz<zzedi> zzejz2 = new zzejz<zzedi>(executor, new zzi(this, eventListener));
        zzecq zzecq2 = this.zzmnd.zzbyv().zza(this.zzmoe, zzebx2, zzejz2);
        return new zzekk(this.zzmnd.zzbyv(), zzecq2, activity, zzejz2);
    }

    private static zzebx zza(QueryListenOptions queryListenOptions) {
        zzebx zzebx2 = new zzebx();
        new zzebx().zzmoi = queryListenOptions.zzmoi;
        zzebx2.zzmoh = queryListenOptions.zzmoh;
        zzebx2.zzmqf = false;
        return zzebx2;
    }

    @Keep
    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

