/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzeda;
import com.google.android.gms.internal.zzegc;
import com.google.android.gms.internal.zzegk;
import com.google.android.gms.internal.zzegl;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzekb;
import com.google.android.gms.internal.zzekp;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.zzj;
import com.google.firebase.firestore.zzk;
import com.google.firebase.firestore.zzm;
import com.google.firebase.firestore.zzn;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class Transaction {
    private final zzeda zzmou;
    private final FirebaseFirestore zzmnd;

    Transaction(zzeda zzeda2, FirebaseFirestore firebaseFirestore) {
        this.zzmou = (zzeda)zzbp.zzu((Object)zzeda2);
        this.zzmnd = (FirebaseFirestore)zzbp.zzu((Object)firebaseFirestore);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Map<String, Object> map) {
        return this.set(documentReference, map, SetOptions.zzmoo);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Map<String, Object> map, @NonNull SetOptions setOptions) {
        this.zzmnd.zza(documentReference);
        zzbp.zzb(map, (Object)"Provided data must not be null.");
        zzbp.zzb((Object)setOptions, (Object)"Provided options must not be null.");
        zzm zzm2 = this.zzmnd.zzbyx().zza(map, setOptions);
        this.zzmou.zza(documentReference.zzbyq(), zzm2);
        return this;
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Object object) {
        this.zzmnd.zzbyx();
        return this.set(documentReference, zzk.zzbw(object), SetOptions.zzmoo);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Object object, @NonNull SetOptions setOptions) {
        this.zzmnd.zzbyx();
        return this.set(documentReference, zzk.zzbw(object), setOptions);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentReference, @NonNull Map<String, Object> map) {
        zzn zzn2 = this.zzmnd.zzbyx().zzai(map);
        return this.zza(documentReference, zzn2);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentReference, @NonNull String string, @Nullable Object object, Object ... objectArray) {
        zzn zzn2 = this.zzmnd.zzbyx().zzau(zzekp.zza(1, string, object, objectArray));
        return this.zza(documentReference, zzn2);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentReference, @NonNull FieldPath fieldPath, @Nullable Object object, Object ... objectArray) {
        zzn zzn2 = this.zzmnd.zzbyx().zzau(zzekp.zza(1, fieldPath, object, objectArray));
        return this.zza(documentReference, zzn2);
    }

    private final Transaction zza(@NonNull DocumentReference documentReference, @NonNull zzn zzn2) {
        this.zzmnd.zza(documentReference);
        this.zzmou.zza(documentReference.zzbyq(), zzn2);
        return this;
    }

    @NonNull
    public Transaction delete(@NonNull DocumentReference documentReference) {
        this.zzmnd.zza(documentReference);
        this.zzmou.zzb(documentReference.zzbyq());
        return this;
    }

    @NonNull
    public DocumentSnapshot get(@NonNull DocumentReference documentReference) throws FirebaseFirestoreException {
        this.zzmnd.zza(documentReference);
        try {
            DocumentReference documentReference2 = documentReference;
            Transaction transaction = this;
            return (DocumentSnapshot)Tasks.await((Task)transaction.zzmou.zzax(Collections.singletonList(documentReference2.zzbyq())).continueWith(zzekb.zzdfn, (Continuation)new zzj(transaction)));
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            if (executionException.getCause() instanceof FirebaseFirestoreException) {
                throw (FirebaseFirestoreException)((Object)executionException2.getCause());
            }
            throw new RuntimeException(executionException2.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    final /* synthetic */ DocumentSnapshot zzf(Task task) throws Exception {
        if (!task.isSuccessful()) {
            throw task.getException();
        }
        List list = (List)task.getResult();
        if (list.size() != 1) {
            throw zzejo.zzk("Mismatch in docs returned from document lookup.", new Object[0]);
        }
        zzegk zzegk2 = (zzegk)list.get(0);
        if (zzegk2 instanceof zzegl) {
            return DocumentSnapshot.zza(this.zzmnd, zzegk2.zzbyq(), false);
        }
        return DocumentSnapshot.zza(this.zzmnd, (zzegc)zzegk2, false);
    }

    public static interface Function<TResult> {
        @Nullable
        public TResult apply(@NonNull Transaction var1) throws FirebaseFirestoreException;
    }
}

