/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import io.grpc.zzbu;
import io.grpc.zzbv;
import io.grpc.zzbx;
import io.grpc.zzd;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public abstract class NameResolverProvider
extends zzbv {
    public static final zzd<Integer> PARAMS_DEFAULT_PORT = zzbv.PARAMS_DEFAULT_PORT;
    private static final List<NameResolverProvider> providers = NameResolverProvider.load(new zzb(NameResolverProvider.getCorrectClassLoader()));
    private static final zzbv factory = new zza(providers);

    public NameResolverProvider() {
    }

    static List<NameResolverProvider> load(ClassLoader classLoader) {
        Iterable<NameResolverProvider> iterable = NameResolverProvider.isAndroid() ? NameResolverProvider.getCandidatesViaHardCoded(classLoader) : NameResolverProvider.getCandidatesViaServiceLoader(classLoader);
        ArrayList<NameResolverProvider> arrayList = new ArrayList<NameResolverProvider>();
        for (NameResolverProvider nameResolverProvider : iterable) {
            if (!nameResolverProvider.isAvailable()) continue;
            arrayList.add(nameResolverProvider);
        }
        Collections.sort(arrayList, Collections.reverseOrder(new zzbx()));
        return Collections.unmodifiableList(arrayList);
    }

    public static Iterable<NameResolverProvider> getCandidatesViaServiceLoader(ClassLoader classLoader) {
        return ServiceLoader.load(NameResolverProvider.class, classLoader);
    }

    public static Iterable<NameResolverProvider> getCandidatesViaHardCoded(ClassLoader classLoader) {
        ArrayList<NameResolverProvider> arrayList = new ArrayList<NameResolverProvider>();
        try {
            arrayList.add(NameResolverProvider.create(Class.forName("io.grpc.internal.DnsNameResolverProvider", true, classLoader)));
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return arrayList;
    }

    static NameResolverProvider create(Class<?> clazz) {
        try {
            return clazz.asSubclass(NameResolverProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            String string = clazz.getName();
            String string2 = String.valueOf(throwable);
            throw new ServiceConfigurationError(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Provider ").append(string).append(" could not be instantiated: ").append(string2).toString(), throwable);
        }
    }

    public static List<NameResolverProvider> providers() {
        return providers;
    }

    public static zzbv asFactory() {
        return factory;
    }

    static zzbv asFactory(List<NameResolverProvider> list) {
        return new zza(list);
    }

    private static ClassLoader getCorrectClassLoader() {
        if (NameResolverProvider.isAndroid()) {
            return NameResolverProvider.class.getClassLoader();
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected abstract boolean isAvailable();

    protected abstract int priority();

    static final class zza
    extends zzbv {
        private final List<NameResolverProvider> providers;

        public zza(List<NameResolverProvider> list) {
            this.providers = list;
        }

        @Override
        public final zzbu newNameResolver(URI uRI, io.grpc.zza zza2) {
            this.zzcym();
            Iterator<NameResolverProvider> iterator = this.providers.iterator();
            while (iterator.hasNext()) {
                zzbu zzbu2 = iterator.next().newNameResolver(uRI, zza2);
                if (zzbu2 == null) continue;
                return zzbu2;
            }
            return null;
        }

        @Override
        public final String getDefaultScheme() {
            this.zzcym();
            return this.providers.get(0).getDefaultScheme();
        }

        private final void zzcym() {
            Preconditions.checkState((!this.providers.isEmpty() ? 1 : 0) != 0, (Object)"No NameResolverProviders found via ServiceLoader, including for DNS. This is probably due to a broken build. If using ProGuard, check your configuration");
        }
    }

    static final class zzb
    extends ClassLoader {
        private final String zzpao = "META-INF/services/io.grpc.NameResolverProvider";
        private final String zzpap = "HACKED-META-INF/services/io.grpc.NameResolverProvider";

        public zzb(ClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        public final Class<?> loadClass(String string) throws ClassNotFoundException {
            return this.getParent().loadClass(string);
        }

        @Override
        protected final URL findResource(String string) {
            if ("META-INF/services/io.grpc.NameResolverProvider".equals(string)) {
                return this.getParent().getResource("HACKED-META-INF/services/io.grpc.NameResolverProvider");
            }
            return super.findResource(string);
        }

        @Override
        protected final Enumeration<URL> findResources(String string) throws IOException {
            if ("META-INF/services/io.grpc.NameResolverProvider".equals(string)) {
                return this.getParent().getResources("HACKED-META-INF/services/io.grpc.NameResolverProvider");
            }
            return super.findResources(string);
        }
    }
}

