/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.AbstractStream;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.Framer;
import io.grpc.internal.IoUtils;
import io.grpc.internal.MessageFramer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import io.grpc.zzbe;
import io.grpc.zzcq;
import io.grpc.zzu;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractClientStream
extends AbstractStream
implements ClientStream,
MessageFramer.Sink {
    private static final Logger log = Logger.getLogger(AbstractClientStream.class.getName());
    private final Framer framer;
    private boolean useGet;
    private zzbe headers;
    private boolean outboundClosed;
    private volatile boolean cancelled;

    protected AbstractClientStream(WritableBufferAllocator writableBufferAllocator, StatsTraceContext statsTraceContext, zzbe zzbe2, boolean bl) {
        Preconditions.checkNotNull((Object)zzbe2, (Object)"headers");
        this.useGet = bl;
        if (!bl) {
            this.framer = new MessageFramer(this, writableBufferAllocator, statsTraceContext);
            this.headers = zzbe2;
            return;
        }
        this.framer = new GetFramer(zzbe2, statsTraceContext);
    }

    @Override
    public void setMaxOutboundMessageSize(int n) {
        this.framer.setMaxOutboundMessageSize(n);
    }

    @Override
    public void setMaxInboundMessageSize(int n) {
        this.transportState().setMaxInboundMessageSize(n);
    }

    @Override
    protected abstract TransportState transportState();

    @Override
    public final void start(ClientStreamListener clientStreamListener) {
        this.transportState().setListener(clientStreamListener);
        if (!this.useGet) {
            this.abstractClientStreamSink().writeHeaders(this.headers, null);
            this.headers = null;
        }
    }

    protected abstract Sink abstractClientStreamSink();

    @Override
    protected final Framer framer() {
        return this.framer;
    }

    @Override
    public final void request(int n) {
        this.abstractClientStreamSink().request(n);
    }

    @Override
    public final void deliverFrame(WritableBuffer writableBuffer, boolean bl, boolean bl2) {
        Preconditions.checkArgument((writableBuffer != null || bl ? 1 : 0) != 0, (Object)"null frame before EOS");
        this.abstractClientStreamSink().writeFrame(writableBuffer, bl, bl2);
    }

    @Override
    public final void halfClose() {
        if (!this.outboundClosed) {
            this.outboundClosed = true;
            this.endOfMessages();
        }
    }

    @Override
    public final void cancel(zzcq zzcq2) {
        Preconditions.checkArgument((!zzcq2.zzcyt() ? 1 : 0) != 0, (Object)"Should not cancel with OK status");
        this.cancelled = true;
        this.abstractClientStreamSink().cancel(zzcq2);
    }

    @Override
    public final boolean isReady() {
        return super.isReady() && !this.cancelled;
    }

    class GetFramer
    implements Framer {
        private zzbe headers;
        private boolean closed;
        private final StatsTraceContext statsTraceCtx;
        private byte[] payload;

        public GetFramer(zzbe zzbe2, StatsTraceContext statsTraceContext) {
            this.headers = (zzbe)Preconditions.checkNotNull((Object)zzbe2, (Object)"headers");
            this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceContext, (Object)"statsTraceCtx");
        }

        @Override
        public void writePayload(InputStream inputStream) {
            Preconditions.checkState((this.payload == null ? 1 : 0) != 0, (Object)"writePayload should not be called multiple times");
            try {
                this.payload = IoUtils.toByteArray(inputStream);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.statsTraceCtx.outboundMessage();
            this.statsTraceCtx.outboundUncompressedSize(this.payload.length);
            this.statsTraceCtx.outboundWireSize(this.payload.length);
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            this.closed = true;
            Preconditions.checkState((this.payload != null ? 1 : 0) != 0, (Object)"Lack of request message. GET request is only supported for unary requests");
            AbstractClientStream.this.abstractClientStreamSink().writeHeaders(this.headers, this.payload);
            this.payload = null;
            this.headers = null;
        }

        @Override
        public void dispose() {
            this.closed = true;
            this.payload = null;
            this.headers = null;
        }

        @Override
        public Framer setMessageCompression(boolean bl) {
            return this;
        }

        @Override
        public Framer setCompressor(zzu zzu2) {
            return this;
        }

        @Override
        public void setMaxOutboundMessageSize(int n) {
        }
    }

    public static abstract class TransportState
    extends AbstractStream.TransportState {
        private final StatsTraceContext statsTraceCtx;
        private boolean listenerClosed;
        private ClientStreamListener listener;
        private Runnable deliveryStalledTask;
        private boolean statusReported;

        protected TransportState(int n, StatsTraceContext statsTraceContext) {
            super(n, statsTraceContext);
            this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceContext, (Object)"statsTraceCtx");
        }

        public final void setListener(ClientStreamListener clientStreamListener) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Already called setListener");
            this.listener = (ClientStreamListener)Preconditions.checkNotNull((Object)clientStreamListener, (Object)"listener");
        }

        @Override
        public final void deliveryStalled() {
            if (this.deliveryStalledTask != null) {
                this.deliveryStalledTask.run();
                this.deliveryStalledTask = null;
            }
        }

        @Override
        public final void endOfStream() {
            this.deliveryStalled();
        }

        @Override
        protected final ClientStreamListener listener() {
            return this.listener;
        }

        protected void inboundHeadersReceived(zzbe zzbe2) {
            Preconditions.checkState((!this.statusReported ? 1 : 0) != 0, (Object)"Received headers on closed stream");
            this.statsTraceCtx.clientInboundHeaders();
            this.listener().headersRead(zzbe2);
        }

        protected void inboundDataReceived(ReadableBuffer readableBuffer) {
            boolean bl;
            block4: {
                Preconditions.checkNotNull((Object)readableBuffer, (Object)"frame");
                bl = true;
                try {
                    if (!this.statusReported) break block4;
                    log.logp(Level.INFO, "io.grpc.internal.AbstractClientStream$TransportState", "inboundDataReceived", "Received data on closed stream");
                    readableBuffer.close();
                    return;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        readableBuffer.close();
                    }
                    throw throwable;
                }
            }
            bl = false;
            this.deframe(readableBuffer, false);
        }

        protected void inboundTrailersReceived(zzbe zzbe2, zzcq zzcq2) {
            Preconditions.checkNotNull((Object)zzcq2, (Object)"status");
            Preconditions.checkNotNull((Object)zzbe2, (Object)"trailers");
            if (this.statusReported) {
                log.logp(Level.INFO, "io.grpc.internal.AbstractClientStream$TransportState", "inboundTrailersReceived", "Received trailers on closed stream:\n {1}\n {2}", new Object[]{zzcq2, zzbe2});
                return;
            }
            this.transportReportStatus(zzcq2, false, zzbe2);
        }

        public final void transportReportStatus(final zzcq zzcq2, boolean bl, final zzbe zzbe2) {
            Preconditions.checkNotNull((Object)zzcq2, (Object)"status");
            Preconditions.checkNotNull((Object)zzbe2, (Object)"trailers");
            if (this.statusReported && !bl) {
                return;
            }
            this.statusReported = true;
            this.onStreamDeallocated();
            if (bl || this.isDeframerStalled()) {
                this.deliveryStalledTask = null;
                this.closeListener(zzcq2, zzbe2);
                return;
            }
            this.deliveryStalledTask = new Runnable(){

                @Override
                public void run() {
                    TransportState.this.closeListener(zzcq2, zzbe2);
                }
            };
        }

        private void closeListener(zzcq zzcq2, zzbe zzbe2) {
            if (!this.listenerClosed) {
                this.listenerClosed = true;
                this.closeDeframer();
                this.statsTraceCtx.streamClosed(zzcq2);
                this.listener().closed(zzcq2, zzbe2);
            }
        }
    }

    public static interface Sink {
        public void writeHeaders(zzbe var1, byte[] var2);

        public void writeFrame(WritableBuffer var1, boolean var2, boolean var3);

        public void request(int var1);

        public void cancel(zzcq var1);
    }
}

