/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdgi;
import com.google.android.gms.internal.zzerq;
import com.google.android.gms.internal.zzers;
import com.google.android.gms.internal.zzeta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.internal.CensusStatsModule;
import io.grpc.internal.CensusTracingModule;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalHandlerRegistry;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerImpl;
import io.grpc.internal.SharedResourcePool;
import io.grpc.zzah;
import io.grpc.zzap;
import io.grpc.zzar;
import io.grpc.zzch;
import io.grpc.zzci;
import io.grpc.zzcl;
import io.grpc.zzcm;
import io.grpc.zzco;
import io.grpc.zzcp;
import io.grpc.zze;
import io.grpc.zzv;
import io.grpc.zzy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends zzci<T> {
    private static final zzap EMPTY_FALLBACK_REGISTRY = new zzap(){

        @Override
        public List<zzcm> getServices() {
            return Collections.emptyList();
        }

        @Override
        public zzcl<?, ?> lookupMethod(String string, String string2) {
            return null;
        }
    };
    private final InternalHandlerRegistry.Builder registryBuilder = new InternalHandlerRegistry.Builder();
    private final ArrayList<zzcp> transportFilters = new ArrayList();
    private final List<zzar> notifyOnBuildList = new ArrayList<zzar>();
    private final List<zzco> streamTracerFactories = new ArrayList<zzco>();
    private zzap fallbackRegistry;
    private Executor executor;
    private zzah decompressorRegistry;
    private zzv compressorRegistry;
    private zzers statsFactory;

    public AbstractServerImplBuilder() {
    }

    @Override
    public final T directExecutor() {
        return (T)((AbstractServerImplBuilder)((zzci)this).executor(zzdgi.zzbjt()));
    }

    @Override
    public final T executor(Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T addService(zzcm zzcm2) {
        this.registryBuilder.addService(zzcm2);
        return this.thisT();
    }

    @Override
    public final T addService(zze zze2) {
        if (zze2 instanceof zzar) {
            this.notifyOnBuildList.add((zzar)((Object)zze2));
        }
        return (T)((AbstractServerImplBuilder)((zzci)this).addService(zze2.zzcxa()));
    }

    @Override
    public final T addTransportFilter(zzcp zzcp2) {
        this.transportFilters.add((zzcp)Preconditions.checkNotNull((Object)zzcp2, (Object)"filter"));
        return this.thisT();
    }

    @Override
    public final T addStreamTracerFactory(zzco zzco2) {
        this.streamTracerFactories.add((zzco)Preconditions.checkNotNull((Object)zzco2, (Object)"factory"));
        return this.thisT();
    }

    @Override
    public final T fallbackHandlerRegistry(zzap zzap2) {
        this.fallbackRegistry = zzap2;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(zzah zzah2) {
        this.decompressorRegistry = zzah2;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(zzv zzv2) {
        this.compressorRegistry = zzv2;
        return this.thisT();
    }

    protected T statsContextFactory(zzers zzers2) {
        this.statsFactory = zzers2;
        return this.thisT();
    }

    @Override
    public zzch build() {
        Object object;
        ArrayList<zzco> arrayList = new ArrayList<zzco>();
        zzers zzers2 = this.statsFactory != null ? this.statsFactory : zzerq.zzcrl();
        if (zzers2 != null) {
            object = new CensusStatsModule(zzers2, GrpcUtil.STOPWATCH_SUPPLIER, true);
            arrayList.add(((CensusStatsModule)object).getServerTracerFactory());
        }
        object = new CensusTracingModule(zzeta.zzcrv(), zzeta.zzcrw());
        arrayList.add(((CensusTracingModule)object).getServerTracerFactory());
        arrayList.addAll(this.streamTracerFactories);
        InternalServer internalServer = this.buildTransportServer(Collections.unmodifiableList(arrayList));
        ServerImpl serverImpl = new ServerImpl(this.getExecutorPool(), SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE), this.registryBuilder.build(), (zzap)MoreObjects.firstNonNull((Object)this.fallbackRegistry, (Object)EMPTY_FALLBACK_REGISTRY), internalServer, zzy.zzoze, (zzah)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)zzah.zzcxv()), (zzv)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)zzv.zzcxj()), this.transportFilters);
        Iterator<zzar> iterator = this.notifyOnBuildList.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        return serverImpl;
    }

    private ObjectPool<? extends Executor> getExecutorPool() {
        final Executor executor = this.executor;
        if (executor == null) {
            return SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        }
        return new ObjectPool<Executor>(this){

            @Override
            public Executor getObject() {
                return executor;
            }

            @Override
            public Executor returnObject(Object object) {
                return null;
            }
        };
    }

    protected abstract InternalServer buildTransportServer(List<zzco> var1);

    private T thisT() {
        return (T)this;
    }
}

