/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.AbstractStream;
import io.grpc.internal.MessageFramer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import io.grpc.zza;
import io.grpc.zzas;
import io.grpc.zzbe;
import io.grpc.zzcq;

public abstract class AbstractServerStream
extends AbstractStream
implements MessageFramer.Sink,
ServerStream {
    private final MessageFramer framer;
    private final StatsTraceContext statsTraceCtx;
    private boolean outboundClosed;
    private boolean headersSent;

    protected AbstractServerStream(WritableBufferAllocator writableBufferAllocator, StatsTraceContext statsTraceContext) {
        this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceContext, (Object)"statsTraceCtx");
        this.framer = new MessageFramer(this, writableBufferAllocator, statsTraceContext);
    }

    @Override
    protected abstract TransportState transportState();

    protected abstract Sink abstractServerStreamSink();

    @Override
    protected final MessageFramer framer() {
        return this.framer;
    }

    @Override
    public final void request(int n) {
        this.abstractServerStreamSink().request(n);
    }

    @Override
    public final void writeHeaders(zzbe zzbe2) {
        Preconditions.checkNotNull((Object)zzbe2, (Object)"headers");
        this.headersSent = true;
        this.abstractServerStreamSink().writeHeaders(zzbe2);
    }

    @Override
    public final void deliverFrame(WritableBuffer writableBuffer, boolean bl, boolean bl2) {
        this.abstractServerStreamSink().writeFrame(writableBuffer, bl ? false : bl2);
    }

    @Override
    public final void close(zzcq zzcq2, zzbe zzbe2) {
        Preconditions.checkNotNull((Object)zzcq2, (Object)"status");
        Preconditions.checkNotNull((Object)zzbe2, (Object)"trailers");
        if (!this.outboundClosed) {
            this.outboundClosed = true;
            this.statsTraceCtx.streamClosed(zzcq2);
            this.endOfMessages();
            this.addStatusToTrailers(zzbe2, zzcq2);
            this.abstractServerStreamSink().writeTrailers(zzbe2, this.headersSent);
        }
    }

    private void addStatusToTrailers(zzbe zzbe2, zzcq zzcq2) {
        zzbe2.zzc(zzas.zzpaj);
        zzbe2.zzc(zzas.zzpai);
        zzbe2.zza(zzas.zzpaj, zzcq2);
        if (zzcq2.getDescription() != null) {
            zzbe2.zza(zzas.zzpai, zzcq2.getDescription());
        }
    }

    @Override
    public final void cancel(zzcq zzcq2) {
        this.abstractServerStreamSink().cancel(zzcq2);
    }

    @Override
    public final boolean isReady() {
        return super.isReady();
    }

    @Override
    public zza getAttributes() {
        return zza.zzoyf;
    }

    @Override
    public String getAuthority() {
        return null;
    }

    @Override
    public final void setListener(ServerStreamListener serverStreamListener) {
        this.transportState().setListener(serverStreamListener);
    }

    @Override
    public StatsTraceContext statsTraceContext() {
        return this.statsTraceCtx;
    }

    public static abstract class TransportState
    extends AbstractStream.TransportState {
        private boolean listenerClosed;
        private ServerStreamListener listener;
        private final StatsTraceContext statsTraceCtx;

        protected TransportState(int n, StatsTraceContext statsTraceContext) {
            super(n, statsTraceContext);
            this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceContext, (Object)"statsTraceCtx");
        }

        public final void setListener(ServerStreamListener serverStreamListener) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"setListener should be called only once");
            this.listener = (ServerStreamListener)Preconditions.checkNotNull((Object)serverStreamListener, (Object)"listener");
        }

        @Override
        public final void onStreamAllocated() {
            super.onStreamAllocated();
        }

        @Override
        public void deliveryStalled() {
        }

        @Override
        public void endOfStream() {
            this.closeDeframer();
            this.listener().halfClosed();
        }

        @Override
        protected ServerStreamListener listener() {
            return this.listener;
        }

        public void inboundDataReceived(ReadableBuffer readableBuffer, boolean bl) {
            this.deframe(readableBuffer, bl);
        }

        public final void transportReportStatus(zzcq zzcq2) {
            Preconditions.checkArgument((!zzcq2.zzcyt() ? 1 : 0) != 0, (Object)"status must not be OK");
            this.closeListener(zzcq2);
        }

        public void complete() {
            this.closeListener(zzcq.zzpbu);
        }

        private void closeListener(zzcq zzcq2) {
            if (!this.listenerClosed) {
                if (!zzcq2.zzcyt()) {
                    this.statsTraceCtx.streamClosed(zzcq2);
                }
                this.listenerClosed = true;
                this.onStreamDeallocated();
                this.closeDeframer();
                this.listener().closed(zzcq2);
            }
        }
    }

    public static interface Sink {
        public void writeHeaders(zzbe var1);

        public void writeFrame(WritableBuffer var1, boolean var2);

        public void writeTrailers(zzbe var1, boolean var2);

        public void request(int var1);

        public void cancel(zzcq var1);
    }
}

