/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.Framer;
import io.grpc.internal.MessageDeframer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.Stream;
import io.grpc.internal.StreamListener;
import io.grpc.zzag;
import io.grpc.zzt;
import io.grpc.zzu;
import java.io.InputStream;

public abstract class AbstractStream
implements Stream {
    public AbstractStream() {
    }

    protected abstract Framer framer();

    protected abstract TransportState transportState();

    @Override
    public final void setMessageCompression(boolean bl) {
        this.framer().setMessageCompression(bl);
    }

    @Override
    public final void writeMessage(InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream, (Object)"message");
        if (!this.framer().isClosed()) {
            this.framer().writePayload(inputStream);
        }
    }

    @Override
    public final void flush() {
        if (!this.framer().isClosed()) {
            this.framer().flush();
        }
    }

    protected final void endOfMessages() {
        this.framer().close();
    }

    @Override
    public final void setCompressor(zzu zzu2) {
        this.framer().setCompressor((zzu)Preconditions.checkNotNull((Object)zzu2, (Object)"compressor"));
    }

    @Override
    public final void setDecompressor(zzag zzag2) {
        this.transportState().setDecompressor((zzag)Preconditions.checkNotNull((Object)zzag2, (Object)"decompressor"));
    }

    @Override
    public boolean isReady() {
        if (this.framer().isClosed()) {
            return false;
        }
        return this.transportState().isReady();
    }

    protected final void onSendingBytes(int n) {
        this.transportState().onSendingBytes(n);
    }

    public static abstract class TransportState
    implements MessageDeframer.Listener {
        public static final int DEFAULT_ONREADY_THRESHOLD = 32768;
        private final MessageDeframer deframer;
        private final Object onReadyLock = new Object();
        private final StatsTraceContext statsTraceCtx;
        private int numSentBytesQueued;
        private boolean allocated;
        private boolean deallocated;

        protected TransportState(int n, StatsTraceContext statsTraceContext) {
            this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceContext, (Object)"statsTraceCtx");
            this.deframer = new MessageDeframer(this, zzt.zzoyt, n, statsTraceContext, this.getClass().getName());
        }

        final void setMaxInboundMessageSize(int n) {
            this.deframer.setMaxInboundMessageSize(n);
        }

        protected abstract StreamListener listener();

        @Override
        public void messageRead(InputStream inputStream) {
            this.listener().messageRead(inputStream);
        }

        protected abstract void deframeFailed(Throwable var1);

        protected final void closeDeframer() {
            this.deframer.close();
        }

        protected final boolean isDeframerStalled() {
            return this.deframer.isStalled();
        }

        protected final void deframe(ReadableBuffer readableBuffer, boolean bl) {
            if (this.deframer.isClosed()) {
                readableBuffer.close();
                return;
            }
            try {
                this.deframer.deframe(readableBuffer, bl);
                return;
            }
            catch (Throwable throwable) {
                this.deframeFailed(throwable);
                return;
            }
        }

        public final void requestMessagesFromDeframer(int n) {
            if (this.deframer.isClosed()) {
                return;
            }
            try {
                this.deframer.request(n);
                return;
            }
            catch (Throwable throwable) {
                this.deframeFailed(throwable);
                return;
            }
        }

        public final StatsTraceContext getStatsTraceContext() {
            return this.statsTraceCtx;
        }

        private void setDecompressor(zzag zzag2) {
            if (this.deframer.isClosed()) {
                return;
            }
            this.deframer.setDecompressor(zzag2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isReady() {
            Object object = this.onReadyLock;
            synchronized (object) {
                return this.allocated && this.numSentBytesQueued < 32768 && !this.deallocated;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onStreamAllocated() {
            Preconditions.checkState((this.listener() != null ? 1 : 0) != 0);
            Object object = this.onReadyLock;
            synchronized (object) {
                Preconditions.checkState((!this.allocated ? 1 : 0) != 0, (Object)"Already allocated");
                this.allocated = true;
            }
            this.notifyIfReady();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void onStreamDeallocated() {
            Object object = this.onReadyLock;
            synchronized (object) {
                this.deallocated = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onSendingBytes(int n) {
            Object object = this.onReadyLock;
            synchronized (object) {
                this.numSentBytesQueued += n;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSentBytes(int n) {
            boolean bl;
            Object object = this.onReadyLock;
            synchronized (object) {
                Preconditions.checkState((boolean)this.allocated, (Object)"onStreamAllocated was not called, but it seems the stream is active");
                boolean bl2 = this.numSentBytesQueued < 32768;
                this.numSentBytesQueued -= n;
                boolean bl3 = this.numSentBytesQueued < 32768;
                bl = !bl2 && bl3;
            }
            if (bl) {
                this.notifyIfReady();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIfReady() {
            boolean bl;
            Object object = this.onReadyLock;
            synchronized (object) {
                bl = this.isReady();
            }
            if (bl) {
                this.listener().onReady();
            }
        }
    }
}

