/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.ForwardingConnectionClientTransport;
import io.grpc.internal.MetadataApplierImpl;
import io.grpc.zza;
import io.grpc.zzbe;
import io.grpc.zzbp;
import io.grpc.zzc;
import io.grpc.zzcg;
import io.grpc.zzf;
import io.grpc.zzh;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

final class CallCredentialsApplyingTransportFactory
implements ClientTransportFactory {
    private final ClientTransportFactory delegate;
    private final Executor appExecutor;

    CallCredentialsApplyingTransportFactory(ClientTransportFactory clientTransportFactory, Executor executor) {
        this.delegate = (ClientTransportFactory)Preconditions.checkNotNull((Object)clientTransportFactory, (Object)"delegate");
        this.appExecutor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"appExecutor");
    }

    @Override
    public final ConnectionClientTransport newClientTransport(SocketAddress socketAddress, String string, String string2) {
        return new CallCredentialsApplyingTransport(this.delegate.newClientTransport(socketAddress, string, string2), string);
    }

    @Override
    public final void close() {
        this.delegate.close();
    }

    class CallCredentialsApplyingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final String authority;

        CallCredentialsApplyingTransport(ConnectionClientTransport connectionClientTransport, String string) {
            this.delegate = (ConnectionClientTransport)Preconditions.checkNotNull((Object)connectionClientTransport, (Object)"delegate");
            this.authority = (String)Preconditions.checkNotNull((Object)string, (Object)"authority");
        }

        @Override
        protected ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public ClientStream newStream(zzbp<?, ?> zzbp2, zzbe zzbe2, zzh zzh2) {
            zzf zzf2 = zzh2.zzcxd();
            if (zzf2 != null) {
                MetadataApplierImpl metadataApplierImpl = new MetadataApplierImpl(this.delegate, zzbp2, zzbe2, zzh2);
                zzc zzc2 = zza.zzcwy().zza(zzf.zzoyi, this.authority).zza(zzf.zzoyh, zzcg.zzpbp).zzb(this.delegate.getAttributes());
                if (zzh2.getAuthority() != null) {
                    zzc2.zza(zzf.zzoyi, zzh2.getAuthority());
                }
                zzf2.zza(zzbp2, zzc2.zzcwz(), (Executor)MoreObjects.firstNonNull((Object)zzh2.zzcfp(), (Object)CallCredentialsApplyingTransportFactory.this.appExecutor), metadataApplierImpl);
                return metadataApplierImpl.returnStream();
            }
            return this.delegate.newStream(zzbp2, zzbe2, zzh2);
        }
    }
}

