/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzerd;
import com.google.android.gms.internal.zzerk;
import com.google.android.gms.internal.zzerm;
import com.google.android.gms.internal.zzerp;
import com.google.android.gms.internal.zzerr;
import com.google.android.gms.internal.zzers;
import com.google.android.gms.internal.zzerv;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.zzal;
import io.grpc.zzam;
import io.grpc.zzao;
import io.grpc.zzbe;
import io.grpc.zzbl;
import io.grpc.zzbm;
import io.grpc.zzbp;
import io.grpc.zzcn;
import io.grpc.zzco;
import io.grpc.zzcq;
import io.grpc.zzh;
import io.grpc.zzi;
import io.grpc.zzj;
import io.grpc.zzk;
import io.grpc.zzl;
import io.grpc.zzp;
import io.grpc.zzq;
import io.grpc.zzy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

final class CensusStatsModule {
    private static final Logger logger = Logger.getLogger(CensusStatsModule.class.getName());
    private static final double NANOS_PER_MILLI = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ClientTracer BLANK_CLIENT_TRACER = new ClientTracer();
    private final zzers statsCtxFactory;
    private final Supplier<Stopwatch> stopwatchSupplier;
    final zzbm<zzerr> statsHeader;
    private final StatsClientInterceptor clientInterceptor = new StatsClientInterceptor();
    private final ServerTracerFactory serverTracerFactory = new ServerTracerFactory();
    private final boolean propagateTags;

    CensusStatsModule(final zzers zzers2, Supplier<Stopwatch> supplier, boolean bl) {
        this.statsCtxFactory = (zzers)Preconditions.checkNotNull((Object)zzers2, (Object)"statsCtxFactory");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(supplier, (Object)"stopwatchSupplier");
        this.propagateTags = bl;
        this.statsHeader = zzbm.zza("grpc-tags-bin", new zzbl<zzerr>(this){

            @Override
            public byte[] toBytes(zzerr zzerr2) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                return byteArrayOutputStream.toByteArray();
            }

            @Override
            public zzerr parseBytes(byte[] byArray) {
                try {
                    return zzers2.zzk(new ByteArrayInputStream(byArray));
                }
                catch (Exception exception) {
                    logger.logp(Level.FINE, "io.grpc.internal.CensusStatsModule$1", "parseBytes", "Failed to parse stats header", exception);
                    return zzers2.zzcrm();
                }
            }
        });
    }

    final ClientCallTracer newClientCallTracer(zzerr zzerr2, String string) {
        return new ClientCallTracer(zzerr2, string);
    }

    final zzco getServerTracerFactory() {
        return this.serverTracerFactory;
    }

    final zzl getClientInterceptor() {
        return this.clientInterceptor;
    }

    class StatsClientInterceptor
    implements zzl {
        private StatsClientInterceptor() {
        }

        @Override
        public <ReqT, RespT> zzj<ReqT, RespT> interceptCall(zzbp<ReqT, RespT> zzbp2, zzh zzh2, zzi zzi2) {
            zzers zzers2 = CensusStatsModule.this.statsCtxFactory;
            zzerr zzerr2 = zzerd.zzodq.zzb(zzy.zzcxm());
            zzerr zzerr3 = zzerr2 != null ? zzerr2 : zzers2.zzcrm();
            final ClientCallTracer clientCallTracer = CensusStatsModule.this.newClientCallTracer(zzerr3, zzbp2.zzcyi());
            zzj<ReqT, RespT> zzj2 = zzi2.newCall(zzbp2, zzh2.zza(clientCallTracer));
            return new zzam<ReqT, RespT>(this, zzj2){

                @Override
                public void start(zzk<RespT> zzk2, zzbe zzbe2) {
                    ((zzal)this).delegate().start(new zzao<RespT>(zzk2){

                        @Override
                        public void onClose(zzcq zzcq2, zzbe zzbe2) {
                            clientCallTracer.callEnded(zzcq2);
                            super.onClose(zzcq2, zzbe2);
                        }
                    }, zzbe2);
                }
            };
        }
    }

    final class ServerTracerFactory
    extends zzco {
        private ServerTracerFactory() {
        }

        @Override
        public final zzcn newServerStreamTracer(String string, zzbe zzbe2) {
            zzerr zzerr2 = zzbe2.zzb(CensusStatsModule.this.statsHeader);
            if (zzerr2 == null) {
                zzerr2 = CensusStatsModule.this.statsCtxFactory.zzcrm();
            }
            return new ServerTracer(string, zzerr2);
        }
    }

    final class ServerTracer
    extends zzcn {
        private final String fullMethodName;
        private final zzerr parentCtx;
        private final AtomicBoolean streamClosed = new AtomicBoolean(false);
        private final Stopwatch stopwatch;
        private final AtomicLong outboundWireSize = new AtomicLong();
        private final AtomicLong inboundWireSize = new AtomicLong();
        private final AtomicLong outboundUncompressedSize = new AtomicLong();
        private final AtomicLong inboundUncompressedSize = new AtomicLong();

        ServerTracer(String string, zzerr zzerr2) {
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)string, (Object)"fullMethodName");
            this.parentCtx = (zzerr)Preconditions.checkNotNull((Object)zzerr2, (Object)"parentCtx");
            this.stopwatch = ((Stopwatch)CensusStatsModule.this.stopwatchSupplier.get()).start();
        }

        @Override
        public final void outboundWireSize(long l) {
            this.outboundWireSize.addAndGet(l);
        }

        @Override
        public final void inboundWireSize(long l) {
            this.inboundWireSize.addAndGet(l);
        }

        @Override
        public final void outboundUncompressedSize(long l) {
            this.outboundUncompressedSize.addAndGet(l);
        }

        @Override
        public final void inboundUncompressedSize(long l) {
            this.inboundUncompressedSize.addAndGet(l);
        }

        @Override
        public final void streamClosed(zzcq zzcq2) {
            if (!this.streamClosed.compareAndSet(false, true)) {
                return;
            }
            this.stopwatch.stop();
            long l = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            zzerm zzerm2 = zzerk.zzcri().zza(zzerp.zzoex, (double)l / NANOS_PER_MILLI).zza(zzerp.zzoev, this.outboundWireSize.get()).zza(zzerp.zzoeu, this.inboundWireSize.get()).zza(zzerp.zzoez, this.outboundUncompressedSize.get()).zza(zzerp.zzoey, this.inboundUncompressedSize.get());
            if (!zzcq2.zzcyt()) {
                zzerm2.zza(zzerp.zzoet, 1.0);
            }
            MoreObjects.firstNonNull((Object)this.parentCtx, (Object)CensusStatsModule.this.statsCtxFactory.zzcrm());
            zzerv.zztf(this.fullMethodName);
            zzerv.zztf(zzcq2.zzcys().toString());
            zzerm2.zzcrj();
        }

        @Override
        public final <ReqT, RespT> zzy filterContext(zzy zzy2) {
            if (this.parentCtx != CensusStatsModule.this.statsCtxFactory.zzcrm()) {
                return zzy2.zza(zzerd.zzodq, this.parentCtx);
            }
            return zzy2;
        }
    }

    final class ClientCallTracer
    extends zzq {
        private final String fullMethodName;
        private final Stopwatch stopwatch;
        private final AtomicReference<ClientTracer> streamTracer = new AtomicReference();
        private final AtomicBoolean callEnded = new AtomicBoolean(false);
        private final zzerr parentCtx;

        ClientCallTracer(zzerr zzerr2, String string) {
            this.parentCtx = (zzerr)Preconditions.checkNotNull((Object)zzerr2, (Object)"parentCtx");
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)string, (Object)"fullMethodName");
            this.stopwatch = ((Stopwatch)CensusStatsModule.this.stopwatchSupplier.get()).start();
        }

        @Override
        public final zzp newClientStreamTracer(zzbe zzbe2) {
            ClientTracer clientTracer = new ClientTracer();
            Preconditions.checkState((boolean)this.streamTracer.compareAndSet(null, clientTracer), (Object)"Are you creating multiple streams per call? This class doesn't yet support this case.");
            if (CensusStatsModule.this.propagateTags) {
                zzbe2.zzc(CensusStatsModule.this.statsHeader);
                if (this.parentCtx != CensusStatsModule.this.statsCtxFactory.zzcrm()) {
                    zzbe2.zza(CensusStatsModule.this.statsHeader, this.parentCtx);
                }
            }
            return clientTracer;
        }

        final void callEnded(zzcq zzcq2) {
            if (!this.callEnded.compareAndSet(false, true)) {
                return;
            }
            this.stopwatch.stop();
            long l = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            ClientTracer clientTracer = this.streamTracer.get();
            if (clientTracer == null) {
                clientTracer = BLANK_CLIENT_TRACER;
            }
            zzerm zzerm2 = zzerk.zzcri().zza(zzerp.zzoel, (double)l / NANOS_PER_MILLI).zza(zzerp.zzoej, clientTracer.outboundWireSize.get()).zza(zzerp.zzoek, clientTracer.inboundWireSize.get()).zza(zzerp.zzoen, clientTracer.outboundUncompressedSize.get()).zza(zzerp.zzoeo, clientTracer.inboundUncompressedSize.get());
            if (!zzcq2.zzcyt()) {
                zzerm2.zza(zzerp.zzoei, 1.0);
            }
            zzerv.zztf(this.fullMethodName);
            zzerv.zztf(zzcq2.zzcys().toString());
            zzerm2.zzcrj();
        }
    }

    static final class ClientTracer
    extends zzp {
        final AtomicLong outboundWireSize = new AtomicLong();
        final AtomicLong inboundWireSize = new AtomicLong();
        final AtomicLong outboundUncompressedSize = new AtomicLong();
        final AtomicLong inboundUncompressedSize = new AtomicLong();

        private ClientTracer() {
        }

        @Override
        public final void outboundWireSize(long l) {
            this.outboundWireSize.addAndGet(l);
        }

        @Override
        public final void inboundWireSize(long l) {
            this.inboundWireSize.addAndGet(l);
        }

        @Override
        public final void outboundUncompressedSize(long l) {
            this.outboundUncompressedSize.addAndGet(l);
        }

        @Override
        public final void inboundUncompressedSize(long l) {
            this.inboundUncompressedSize.addAndGet(l);
        }
    }
}

