/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzesd;
import com.google.android.gms.internal.zzesh;
import com.google.android.gms.internal.zzesi;
import com.google.android.gms.internal.zzesl;
import com.google.android.gms.internal.zzesn;
import com.google.android.gms.internal.zzesr;
import com.google.android.gms.internal.zzesx;
import com.google.common.base.Preconditions;
import io.grpc.zzal;
import io.grpc.zzam;
import io.grpc.zzao;
import io.grpc.zzbe;
import io.grpc.zzbl;
import io.grpc.zzbm;
import io.grpc.zzbp;
import io.grpc.zzcn;
import io.grpc.zzco;
import io.grpc.zzcq;
import io.grpc.zzh;
import io.grpc.zzi;
import io.grpc.zzj;
import io.grpc.zzk;
import io.grpc.zzl;
import io.grpc.zzp;
import io.grpc.zzq;
import io.grpc.zzy;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

final class CensusTracingModule {
    private static final Logger logger = Logger.getLogger(CensusTracingModule.class.getName());
    private static final zzp noopClientTracer = new zzp(){};
    private final zzesx censusTracer;
    private final zzesd censusTracingPropagationHandler;
    final zzbm<zzesn> tracingHeader;
    private final TracingClientInterceptor clientInterceptor = new TracingClientInterceptor();
    private final ServerTracerFactory serverTracerFactory = new ServerTracerFactory();

    CensusTracingModule(zzesx zzesx2, final zzesd zzesd2) {
        this.censusTracer = (zzesx)Preconditions.checkNotNull((Object)zzesx2, (Object)"censusTracer");
        this.censusTracingPropagationHandler = (zzesd)Preconditions.checkNotNull((Object)zzesd2, (Object)"censusTracingPropagationHandler");
        this.tracingHeader = zzbm.zza("grpc-trace-bin", new zzbl<zzesn>(this){

            @Override
            public byte[] toBytes(zzesn zzesn2) {
                return zzesd2.zza(zzesn2);
            }

            @Override
            public zzesn parseBytes(byte[] byArray) {
                try {
                    return zzesd2.zzax(byArray);
                }
                catch (Exception exception) {
                    logger.logp(Level.FINE, "io.grpc.internal.CensusTracingModule$2", "parseBytes", "Failed to parse tracing header", exception);
                    return zzesn.zzohq;
                }
            }
        });
    }

    final ClientCallTracer newClientCallTracer(zzesl zzesl2, String string) {
        return new ClientCallTracer(zzesl2, string);
    }

    final zzco getServerTracerFactory() {
        return this.serverTracerFactory;
    }

    final zzl getClientInterceptor() {
        return this.clientInterceptor;
    }

    private static String makeSpanName(String string, String string2) {
        String string3 = string2.replace('/', '.');
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(".").append(string3).toString();
    }

    static zzesr convertStatus(zzcq zzcq2) {
        zzesr zzesr2;
        switch (zzcq2.zzcys()) {
            case zzpcn: {
                zzesr2 = zzesr.zzohw;
                break;
            }
            case zzpco: {
                zzesr2 = zzesr.zzohx;
                break;
            }
            case zzpcp: {
                zzesr2 = zzesr.zzohy;
                break;
            }
            case zzpcq: {
                zzesr2 = zzesr.zzohz;
                break;
            }
            case zzpcr: {
                zzesr2 = zzesr.zzoia;
                break;
            }
            case zzpcs: {
                zzesr2 = zzesr.zzoib;
                break;
            }
            case zzpct: {
                zzesr2 = zzesr.zzoic;
                break;
            }
            case zzpcu: {
                zzesr2 = zzesr.zzoid;
                break;
            }
            case zzpcv: {
                zzesr2 = zzesr.zzoif;
                break;
            }
            case zzpcw: {
                zzesr2 = zzesr.zzoig;
                break;
            }
            case zzpcx: {
                zzesr2 = zzesr.zzoih;
                break;
            }
            case zzpcy: {
                zzesr2 = zzesr.zzoii;
                break;
            }
            case zzpcz: {
                zzesr2 = zzesr.zzoij;
                break;
            }
            case zzpda: {
                zzesr2 = zzesr.zzoik;
                break;
            }
            case zzpdb: {
                zzesr2 = zzesr.zzoil;
                break;
            }
            case zzpdc: {
                zzesr2 = zzesr.zzoim;
                break;
            }
            case zzpdd: {
                zzesr2 = zzesr.zzoie;
                break;
            }
            default: {
                String string = String.valueOf((Object)zzcq2.zzcys());
                throw new AssertionError((Object)new StringBuilder(22 + String.valueOf(string).length()).append("Unhandled status code ").append(string).toString());
            }
        }
        if (zzcq2.getDescription() != null) {
            zzesr2 = zzesr2.zzth(zzcq2.getDescription());
        }
        return zzesr2;
    }

    private static zzesi createEndSpanOptions(zzcq zzcq2) {
        return zzesi.zzcrp().zza(CensusTracingModule.convertStatus(zzcq2)).zzcrq();
    }

    class TracingClientInterceptor
    implements zzl {
        private TracingClientInterceptor() {
        }

        @Override
        public <ReqT, RespT> zzj<ReqT, RespT> interceptCall(zzbp<ReqT, RespT> zzbp2, zzh zzh2, zzi zzi2) {
            zzesl zzesl2 = zzesh.zzoha.get();
            final ClientCallTracer clientCallTracer = CensusTracingModule.this.newClientCallTracer(zzesl2, zzbp2.zzcyi());
            zzj<ReqT, RespT> zzj2 = zzi2.newCall(zzbp2, zzh2.zza(clientCallTracer));
            return new zzam<ReqT, RespT>(this, zzj2){

                @Override
                public void start(zzk<RespT> zzk2, zzbe zzbe2) {
                    ((zzal)this).delegate().start(new zzao<RespT>(zzk2){

                        @Override
                        public void onClose(zzcq zzcq2, zzbe zzbe2) {
                            clientCallTracer.callEnded(zzcq2);
                            super.onClose(zzcq2, zzbe2);
                        }
                    }, zzbe2);
                }
            };
        }
    }

    final class ServerTracerFactory
    extends zzco {
        private ServerTracerFactory() {
        }

        @Override
        public final zzcn newServerStreamTracer(String string, zzbe zzbe2) {
            zzesn zzesn2 = zzbe2.zzb(CensusTracingModule.this.tracingHeader);
            if (zzesn2 == zzesn.zzohq) {
                zzesn2 = null;
            }
            return new ServerTracer(CensusTracingModule.this, string, zzesn2);
        }
    }

    final class ServerTracer
    extends zzcn {
        private final String fullMethodName;
        private final zzesl span;
        private final AtomicBoolean streamClosed = new AtomicBoolean(false);

        ServerTracer(CensusTracingModule censusTracingModule, String string, zzesn zzesn2) {
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)string, (Object)"fullMethodName");
            this.span = censusTracingModule.censusTracer.zza(zzesn2, CensusTracingModule.makeSpanName("Recv", string)).zzcx(true).zzcrs();
        }

        @Override
        public final void streamClosed(zzcq zzcq2) {
            if (!this.streamClosed.compareAndSet(false, true)) {
                return;
            }
            this.span.zza(CensusTracingModule.createEndSpanOptions(zzcq2));
        }

        @Override
        public final <ReqT, RespT> zzy filterContext(zzy zzy2) {
            return zzy2.zza(zzesh.zzoha, this.span);
        }
    }

    final class ClientCallTracer
    extends zzq {
        private final String fullMethodName;
        private final AtomicBoolean callEnded = new AtomicBoolean(false);
        private final zzesl span;

        ClientCallTracer(zzesl zzesl2, String string) {
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)string, (Object)"fullMethodName");
            this.span = CensusTracingModule.this.censusTracer.zza(zzesl2, CensusTracingModule.makeSpanName("Sent", string)).zzcx(true).zzcrs();
        }

        @Override
        public final zzp newClientStreamTracer(zzbe zzbe2) {
            zzbe2.zzc(CensusTracingModule.this.tracingHeader);
            zzbe2.zza(CensusTracingModule.this.tracingHeader, this.span.zzcrr());
            return noopClientTracer;
        }

        final void callEnded(zzcq zzcq2) {
            if (!this.callEnded.compareAndSet(false, true)) {
                return;
            }
            this.span.zza(CensusTracingModule.createEndSpanOptions(zzcq2));
        }
    }
}

