/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ChannelExecutor {
    private static final Logger log = Logger.getLogger(ChannelExecutor.class.getName());
    private final Object lock = new Object();
    private final LinkedList<Runnable> queue = new LinkedList();
    private boolean draining;

    ChannelExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void drain() {
        boolean bl = false;
        while (true) {
            Runnable runnable;
            Object object = this.lock;
            synchronized (object) {
                if (!bl) {
                    if (this.draining) {
                        return;
                    }
                    this.draining = true;
                    bl = true;
                }
                if ((runnable = this.queue.poll()) == null) {
                    this.draining = false;
                    return;
                }
            }
            try {
                runnable.run();
                continue;
            }
            catch (Throwable throwable) {
                log.logp(Level.WARNING, "io.grpc.internal.ChannelExecutor", "drain", "Runnable threw exception in ChannelExecutor", throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ChannelExecutor executeLater(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add((Runnable)Preconditions.checkNotNull((Object)runnable, (Object)"runnable is null"));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int numPendingTasks() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.size();
        }
    }
}

