/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdgi;
import com.google.common.base.Preconditions;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ContextRunnable;
import io.grpc.internal.FailingClientStream;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.internal.NoopClientStream;
import io.grpc.internal.PickSubchannelArgsImpl;
import io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import io.grpc.internal.SerializingExecutor;
import io.grpc.zza;
import io.grpc.zzab;
import io.grpc.zzac;
import io.grpc.zzag;
import io.grpc.zzah;
import io.grpc.zzaq;
import io.grpc.zzay;
import io.grpc.zzbe;
import io.grpc.zzbp;
import io.grpc.zzbt;
import io.grpc.zzcq;
import io.grpc.zzcs;
import io.grpc.zzh;
import io.grpc.zzj;
import io.grpc.zzk;
import io.grpc.zzt;
import io.grpc.zzu;
import io.grpc.zzv;
import io.grpc.zzy;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ClientCallImpl<ReqT, RespT>
extends zzj<ReqT, RespT>
implements zzy.zzb {
    private static final Logger log = Logger.getLogger(ClientCallImpl.class.getName());
    private final zzbp<ReqT, RespT> method;
    private final Executor callExecutor;
    private final zzy context;
    private volatile ScheduledFuture<?> deadlineCancellationFuture;
    private final boolean unaryRequest;
    private final zzh callOptions;
    private ClientStream stream;
    private volatile boolean cancelListenersShouldBeRemoved;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private final ClientTransportProvider clientTransportProvider;
    private ScheduledExecutorService deadlineCancellationExecutor;
    private zzah decompressorRegistry = zzah.zzcxv();
    private zzv compressorRegistry = zzv.zzcxj();

    ClientCallImpl(zzbp<ReqT, RespT> zzbp2, Executor executor, zzh zzh2, ClientTransportProvider clientTransportProvider, ScheduledExecutorService scheduledExecutorService) {
        this.method = zzbp2;
        this.callExecutor = executor == zzdgi.zzbjt() ? new SerializeReentrantCallsDirectExecutor() : new SerializingExecutor(executor);
        this.context = zzy.zzcxm();
        this.unaryRequest = zzbp2.zzcyh() == zzbt.zzpbg || zzbp2.zzcyh() == zzbt.zzpbi;
        this.callOptions = zzh2;
        this.clientTransportProvider = clientTransportProvider;
        this.deadlineCancellationExecutor = scheduledExecutorService;
    }

    @Override
    public final void cancelled(zzy zzy2) {
        this.stream.cancel(zzab.zzd(zzy2));
    }

    final ClientCallImpl<ReqT, RespT> setDecompressorRegistry(zzah zzah2) {
        this.decompressorRegistry = zzah2;
        return this;
    }

    final ClientCallImpl<ReqT, RespT> setCompressorRegistry(zzv zzv2) {
        this.compressorRegistry = zzv2;
        return this;
    }

    static void prepareHeaders(zzbe zzbe2, zzah zzah2, zzu zzu2) {
        zzbe2.zzc(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (zzu2 != zzt.zzoyt) {
            zzbe2.zza(GrpcUtil.MESSAGE_ENCODING_KEY, zzu2.zzcxi());
        }
        zzbe2.zzc(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        byte[] byArray = zzaq.zza(zzah2);
        if (byArray.length != 0) {
            zzbe2.zza(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, byArray);
        }
    }

    @Override
    public final void start(final zzk<RespT> zzk2, zzbe zzbe2) {
        zzu zzu2;
        Preconditions.checkState((this.stream == null ? 1 : 0) != 0, (Object)"Already started");
        Preconditions.checkNotNull(zzk2, (Object)"observer");
        Preconditions.checkNotNull((Object)zzbe2, (Object)"headers");
        if (this.context.isCancelled()) {
            this.stream = NoopClientStream.INSTANCE;
            class ClosedByContext
            extends ContextRunnable {
                ClosedByContext() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public void runInContext() {
                    ClientCallImpl.this.closeObserver(zzk2, zzab.zzd(ClientCallImpl.this.context), new zzbe());
                }
            }
            this.callExecutor.execute(new ClosedByContext());
            return;
        }
        final String string = this.callOptions.zzcxc();
        if (string != null) {
            zzu2 = this.compressorRegistry.zztq(string);
            if (zzu2 == null) {
                this.stream = NoopClientStream.INSTANCE;
                class ClosedByNotFoundCompressor
                extends ContextRunnable {
                    ClosedByNotFoundCompressor() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        ClientCallImpl.this.closeObserver(zzk2, zzcq.zzpci.zztw(String.format("Unable to find compressor by name %s", string)), new zzbe());
                    }
                }
                this.callExecutor.execute(new ClosedByNotFoundCompressor());
                return;
            }
        } else {
            zzu2 = zzt.zzoyt;
        }
        ClientCallImpl.prepareHeaders(zzbe2, this.decompressorRegistry, zzu2);
        zzac zzac2 = this.effectiveDeadline();
        if (!(zzac2 != null && zzac2.zzaad())) {
            ClientCallImpl.updateTimeoutHeaders(zzac2, this.callOptions.zzcxb(), this.context.zzcxb(), zzbe2);
            ClientTransport clientTransport = this.clientTransportProvider.get(new PickSubchannelArgsImpl(this.method, zzbe2, this.callOptions));
            zzy zzy2 = this.context.zzcxp();
            try {
                this.stream = clientTransport.newStream(this.method, zzbe2, this.callOptions);
            }
            finally {
                this.context.zza(zzy2);
            }
        } else {
            this.stream = new FailingClientStream(zzcq.zzpby);
        }
        if (this.callOptions.getAuthority() != null) {
            this.stream.setAuthority(this.callOptions.getAuthority());
        }
        if (this.callOptions.zzcxg() != null) {
            this.stream.setMaxInboundMessageSize(this.callOptions.zzcxg());
        }
        if (this.callOptions.zzcxh() != null) {
            this.stream.setMaxOutboundMessageSize(this.callOptions.zzcxh());
        }
        this.stream.setCompressor(zzu2);
        this.stream.start(new ClientStreamListenerImpl(zzk2));
        this.context.zza(this, zzdgi.zzbjt());
        if (zzac2 != null && this.context.zzcxb() != zzac2 && this.deadlineCancellationExecutor != null) {
            this.deadlineCancellationFuture = this.startDeadlineTimer(zzac2);
        }
        if (this.cancelListenersShouldBeRemoved) {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    private static void updateTimeoutHeaders(zzac zzac2, zzac zzac3, zzac zzac4, zzbe zzbe2) {
        zzbe2.zzc(GrpcUtil.TIMEOUT_KEY);
        if (zzac2 == null) {
            return;
        }
        long l = Math.max(0L, zzac2.zzb(TimeUnit.NANOSECONDS));
        zzbe2.zza(GrpcUtil.TIMEOUT_KEY, l);
        ClientCallImpl.logIfContextNarrowedTimeout(l, zzac2, zzac4, zzac3);
    }

    private static void logIfContextNarrowedTimeout(long l, zzac zzac2, zzac zzac3, zzac zzac4) {
        if (!log.isLoggable(Level.FINE) || zzac3 != zzac2) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Call timeout set to '%d' ns, due to context deadline.", l));
        if (zzac4 == null) {
            stringBuilder.append(" Explicit call timeout was not set.");
        } else {
            long l2 = zzac4.zzb(TimeUnit.NANOSECONDS);
            stringBuilder.append(String.format(" Explicit call timeout was '%d' ns.", l2));
        }
        log.logp(Level.FINE, "io.grpc.internal.ClientCallImpl", "logIfContextNarrowedTimeout", stringBuilder.toString());
    }

    private final void removeContextListenerAndCancelDeadlineFuture() {
        this.context.zza(this);
        ScheduledFuture<?> scheduledFuture = this.deadlineCancellationFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    private final ScheduledFuture<?> startDeadlineTimer(zzac zzac2) {
        long l = zzac2.zzb(TimeUnit.NANOSECONDS);
        return this.deadlineCancellationExecutor.schedule(new LogExceptionRunnable(new DeadlineTimer(l)), l, TimeUnit.NANOSECONDS);
    }

    private final zzac effectiveDeadline() {
        return ClientCallImpl.min(this.callOptions.zzcxb(), this.context.zzcxb());
    }

    private static zzac min(zzac zzac2, zzac zzac3) {
        if (zzac2 == null) {
            return zzac3;
        }
        if (zzac3 == null) {
            return zzac2;
        }
        return zzac2.zzb(zzac3);
    }

    @Override
    public final void request(int n) {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"Number requested must be non-negative");
        this.stream.request(n);
    }

    @Override
    public final void cancel(String string, Throwable throwable) {
        if (string == null && throwable == null) {
            throwable = new CancellationException("Cancelled without a message or cause");
            log.logp(Level.WARNING, "io.grpc.internal.ClientCallImpl", "cancel", "Cancelling without a message or cause is suboptimal", throwable);
        }
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        try {
            if (this.stream != null) {
                zzcq zzcq2 = zzcq.zzpbv;
                if (string != null) {
                    zzcq2 = zzcq2.zztw(string);
                }
                if (throwable != null) {
                    zzcq2 = zzcq2.zzl(throwable);
                }
                this.stream.cancel(zzcq2);
            }
            return;
        }
        finally {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    @Override
    public final void halfClose() {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        Preconditions.checkState((!this.cancelCalled ? 1 : 0) != 0, (Object)"call was cancelled");
        Preconditions.checkState((!this.halfCloseCalled ? 1 : 0) != 0, (Object)"call already half-closed");
        this.halfCloseCalled = true;
        this.stream.halfClose();
    }

    @Override
    public final void sendMessage(ReqT ReqT) {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        Preconditions.checkState((!this.cancelCalled ? 1 : 0) != 0, (Object)"call was cancelled");
        Preconditions.checkState((!this.halfCloseCalled ? 1 : 0) != 0, (Object)"call was half-closed");
        try {
            InputStream inputStream = this.method.zzch(ReqT);
            this.stream.writeMessage(inputStream);
        }
        catch (Throwable throwable) {
            this.stream.cancel(zzcq.zzpbv.zzl(throwable).zztw("Failed to stream message"));
            return;
        }
        if (!this.unaryRequest) {
            this.stream.flush();
        }
    }

    @Override
    public final void setMessageCompression(boolean bl) {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        this.stream.setMessageCompression(bl);
    }

    @Override
    public final boolean isReady() {
        return this.stream.isReady();
    }

    @Override
    public final zza getAttributes() {
        if (this.stream != null) {
            return this.stream.getAttributes();
        }
        return zza.zzoyf;
    }

    private final void closeObserver(zzk<RespT> zzk2, zzcq zzcq2, zzbe zzbe2) {
        zzk2.onClose(zzcq2, zzbe2);
    }

    class ClientStreamListenerImpl
    implements ClientStreamListener {
        private final zzk<RespT> observer;
        private boolean closed;

        public ClientStreamListenerImpl(zzk<RespT> zzk2) {
            this.observer = (zzk)Preconditions.checkNotNull(zzk2, (Object)"observer");
        }

        @Override
        public void headersRead(final zzbe zzbe2) {
            zzag zzag2 = zzt.zzoyt;
            if (zzbe2.zza(GrpcUtil.MESSAGE_ENCODING_KEY)) {
                String string = zzbe2.zzb(GrpcUtil.MESSAGE_ENCODING_KEY);
                zzag2 = ClientCallImpl.this.decompressorRegistry.zzts(string);
                if (zzag2 == null) {
                    ClientCallImpl.this.stream.cancel(zzcq.zzpci.zztw(String.format("Can't find decompressor for %s", string)));
                    return;
                }
            }
            ClientCallImpl.this.stream.setDecompressor(zzag2);
            class HeadersRead
            extends ContextRunnable {
                HeadersRead() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public final void runInContext() {
                    try {
                        if (ClientStreamListenerImpl.this.closed) {
                            return;
                        }
                        ClientStreamListenerImpl.this.observer.onHeaders(zzbe2);
                        return;
                    }
                    catch (Throwable throwable) {
                        zzcq zzcq2 = zzcq.zzpbv.zzl(throwable).zztw("Failed to read headers");
                        ClientCallImpl.this.stream.cancel(zzcq2);
                        ClientStreamListenerImpl.this.close(zzcq2, new zzbe());
                        return;
                    }
                }
            }
            ClientCallImpl.this.callExecutor.execute(new HeadersRead());
        }

        @Override
        public void messageRead(final InputStream inputStream) {
            class MessageRead
            extends ContextRunnable {
                MessageRead() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public final void runInContext() {
                    try {
                        if (ClientStreamListenerImpl.this.closed) {
                            return;
                        }
                        try {
                            ClientStreamListenerImpl.this.observer.onMessage(ClientCallImpl.this.method.zzn(inputStream));
                            return;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Throwable throwable) {
                        zzcq zzcq2 = zzcq.zzpbv.zzl(throwable).zztw("Failed to read message.");
                        ClientCallImpl.this.stream.cancel(zzcq2);
                        ClientStreamListenerImpl.this.close(zzcq2, new zzbe());
                        return;
                    }
                }
            }
            ClientCallImpl.this.callExecutor.execute(new MessageRead());
        }

        private void close(zzcq zzcq2, zzbe zzbe2) {
            this.closed = true;
            ClientCallImpl.this.cancelListenersShouldBeRemoved = true;
            try {
                ClientCallImpl.this.closeObserver(this.observer, zzcq2, zzbe2);
                return;
            }
            finally {
                ClientCallImpl.this.removeContextListenerAndCancelDeadlineFuture();
            }
        }

        @Override
        public void closed(zzcq zzcq2, zzbe zzbe2) {
            zzac zzac2 = ClientCallImpl.this.effectiveDeadline();
            if (zzcq2.zzcys() == zzcs.zzpco && zzac2 != null && zzac2.zzaad()) {
                zzcq2 = zzcq.zzpby;
                zzbe2 = new zzbe();
            }
            final zzcq zzcq3 = zzcq2;
            final zzbe zzbe3 = zzbe2;
            class StreamClosed
            extends ContextRunnable {
                StreamClosed() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public final void runInContext() {
                    if (ClientStreamListenerImpl.this.closed) {
                        return;
                    }
                    ClientStreamListenerImpl.this.close(zzcq3, zzbe3);
                }
            }
            ClientCallImpl.this.callExecutor.execute(new StreamClosed());
        }

        @Override
        public void onReady() {
            class StreamOnReady
            extends ContextRunnable {
                StreamOnReady() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public final void runInContext() {
                    try {
                        ClientStreamListenerImpl.this.observer.onReady();
                        return;
                    }
                    catch (Throwable throwable) {
                        zzcq zzcq2 = zzcq.zzpbv.zzl(throwable).zztw("Failed to call onReady.");
                        ClientCallImpl.this.stream.cancel(zzcq2);
                        ClientStreamListenerImpl.this.close(zzcq2, new zzbe());
                        return;
                    }
                }
            }
            ClientCallImpl.this.callExecutor.execute(new StreamOnReady());
        }
    }

    class DeadlineTimer
    implements Runnable {
        private final long remainingNanos;

        DeadlineTimer(long l) {
            this.remainingNanos = l;
        }

        @Override
        public void run() {
            ClientCallImpl.this.stream.cancel(zzcq.zzpby.zztx(String.format("deadline exceeded after %dns", this.remainingNanos)));
        }
    }

    static interface ClientTransportProvider {
        public ClientTransport get(zzay var1);
    }
}

