/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.zzw;
import java.util.ArrayList;
import java.util.concurrent.Executor;

class ConnectivityStateManager {
    private ArrayList<StateCallbackEntry> callbacks;
    private zzw state;

    ConnectivityStateManager(zzw zzw2) {
        this.state = zzw2;
    }

    void notifyWhenStateChanged(Runnable runnable, Executor executor, zzw zzw2) {
        StateCallbackEntry stateCallbackEntry = new StateCallbackEntry(runnable, executor);
        if (this.state != zzw2) {
            stateCallbackEntry.runInExecutor();
            return;
        }
        if (this.callbacks == null) {
            this.callbacks = new ArrayList();
        }
        this.callbacks.add(stateCallbackEntry);
    }

    void gotoState(zzw zzw2) {
        if (this.state != zzw2) {
            if (this.state == zzw.zzoza) {
                String string = String.valueOf((Object)zzw2);
                throw new IllegalStateException(new StringBuilder(37 + String.valueOf(string).length()).append("Cannot transition out of SHUTDOWN to ").append(string).toString());
            }
            this.state = zzw2;
            if (this.callbacks == null) {
                return;
            }
            ArrayList<StateCallbackEntry> arrayList = this.callbacks;
            this.callbacks = null;
            ArrayList<StateCallbackEntry> arrayList2 = arrayList;
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                StateCallbackEntry stateCallbackEntry = arrayList2.get(i);
                stateCallbackEntry.runInExecutor();
            }
        }
    }

    zzw getState() {
        return this.state;
    }

    static class StateCallbackEntry {
        final Runnable callback;
        final Executor executor;

        StateCallbackEntry(Runnable runnable, Executor executor) {
            this.callback = runnable;
            this.executor = executor;
        }

        void runInExecutor() {
            this.executor.execute(this.callback);
        }
    }
}

