/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.internal.ChannelExecutor;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.DelayedStream;
import io.grpc.internal.FailingClientStream;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.PickSubchannelArgsImpl;
import io.grpc.zzax;
import io.grpc.zzay;
import io.grpc.zzba;
import io.grpc.zzbe;
import io.grpc.zzbp;
import io.grpc.zzcq;
import io.grpc.zzh;
import io.grpc.zzy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Executor;

final class DelayedClientTransport
implements ManagedClientTransport {
    private final LogId lodId = LogId.allocate(this.getClass().getName());
    private final Object lock = new Object();
    private final Executor defaultAppExecutor;
    private final ChannelExecutor channelExecutor;
    private Runnable reportTransportInUse;
    private Runnable reportTransportNotInUse;
    private Runnable reportTransportShutdown;
    private Runnable reportTransportTerminated;
    private Collection<PendingStream> pendingStreams = new LinkedHashSet<PendingStream>();
    private boolean shutdown;
    private zzba lastPicker;
    private long lastPickerVersion;

    DelayedClientTransport(Executor executor, ChannelExecutor channelExecutor) {
        this.defaultAppExecutor = executor;
        this.channelExecutor = channelExecutor;
    }

    @Override
    public final Runnable start(final ManagedClientTransport.Listener listener) {
        this.reportTransportInUse = new Runnable(this){

            @Override
            public void run() {
                listener.transportInUse(true);
            }
        };
        this.reportTransportNotInUse = new Runnable(this){

            @Override
            public void run() {
                listener.transportInUse(false);
            }
        };
        this.reportTransportShutdown = new Runnable(this){

            @Override
            public void run() {
                listener.transportShutdown(zzcq.zzpcj.zztw("Channel requested transport to shut down"));
            }
        };
        this.reportTransportTerminated = new Runnable(this){

            @Override
            public void run() {
                listener.transportTerminated();
            }
        };
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final ClientStream newStream(zzbp<?, ?> zzbp2, zzbe zzbe2, zzh zzh2) {
        try {
            zzba zzba2 = null;
            PickSubchannelArgsImpl pickSubchannelArgsImpl = new PickSubchannelArgsImpl(zzbp2, zzbe2, zzh2);
            long l = 0L;
            Object object = this.lock;
            // MONITORENTER : object
            if (!this.shutdown) {
                if (this.lastPicker == null) {
                    PendingStream pendingStream = this.createPendingStream(pickSubchannelArgsImpl);
                    // MONITOREXIT : object
                    return pendingStream;
                }
                zzba2 = this.lastPicker;
                l = this.lastPickerVersion;
            }
            // MONITOREXIT : object
            if (zzba2 != null) {
                while (true) {
                    Object object2;
                    ClientTransport clientTransport;
                    if ((clientTransport = GrpcUtil.getTransportFromPickResult(zzba2.pickSubchannel(pickSubchannelArgsImpl), zzh2.zzcxf())) != null) {
                        object2 = clientTransport.newStream(((zzay)pickSubchannelArgsImpl).getMethodDescriptor(), ((zzay)pickSubchannelArgsImpl).getHeaders(), ((zzay)pickSubchannelArgsImpl).getCallOptions());
                        return object2;
                    }
                    object2 = this.lock;
                    // MONITORENTER : object2
                    if (this.shutdown) {
                        // MONITOREXIT : object2
                        break;
                    }
                    if (l == this.lastPickerVersion) {
                        PendingStream pendingStream = this.createPendingStream(pickSubchannelArgsImpl);
                        // MONITOREXIT : object2
                        return pendingStream;
                    }
                    zzba2 = this.lastPicker;
                    l = this.lastPickerVersion;
                    // MONITOREXIT : object2
                }
            }
            object = new FailingClientStream(zzcq.zzpcj.zztw("Channel has shutdown (reported by delayed transport)"));
            return object;
        }
        finally {
            this.channelExecutor.drain();
        }
    }

    @Override
    public final ClientStream newStream(zzbp<?, ?> zzbp2, zzbe zzbe2) {
        return this.newStream(zzbp2, zzbe2, zzh.zzoyj);
    }

    private final PendingStream createPendingStream(zzay zzay2) {
        PendingStream pendingStream = new PendingStream(zzay2);
        this.pendingStreams.add(pendingStream);
        if (this.pendingStreams.size() == 1) {
            this.channelExecutor.executeLater(this.reportTransportInUse);
        }
        return pendingStream;
    }

    @Override
    public final void ping(ClientTransport.PingCallback pingCallback, Executor executor) {
        throw new UnsupportedOperationException("This method is not expected to be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.channelExecutor.executeLater(this.reportTransportShutdown);
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                this.pendingStreams = null;
                this.channelExecutor.executeLater(this.reportTransportTerminated);
            }
        }
        this.channelExecutor.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdownNow(zzcq zzcq2) {
        this.shutdown();
        Collection<PendingStream> collection = null;
        Iterator<PendingStream> iterator = this.lock;
        synchronized (iterator) {
            if (this.pendingStreams != null) {
                collection = this.pendingStreams;
                this.pendingStreams = null;
            }
        }
        if (collection != null) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                ((DelayedStream)iterator.next()).cancel(zzcq2);
            }
            this.channelExecutor.executeLater(this.reportTransportTerminated).drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasPendingStreams() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams != null && !this.pendingStreams.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getPendingStreamsCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams == null ? 0 : this.pendingStreams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reprocess(zzba zzba2) {
        ArrayList<PendingStream> arrayList;
        ArrayList<PendingStream> arrayList2 = new ArrayList<PendingStream>();
        Object object = this.lock;
        synchronized (object) {
            this.lastPicker = zzba2;
            ++this.lastPickerVersion;
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                return;
            }
            arrayList = new ArrayList<PendingStream>(this.pendingStreams);
        }
        ArrayList<PendingStream> arrayList3 = arrayList;
        int n = arrayList3.size();
        int n2 = 0;
        while (n2 < n) {
            zzh zzh2;
            PendingStream pendingStream = arrayList3.get(n2);
            ++n2;
            final PendingStream pendingStream2 = pendingStream;
            zzax zzax2 = zzba2.pickSubchannel(pendingStream2.args);
            final ClientTransport clientTransport = GrpcUtil.getTransportFromPickResult(zzax2, (zzh2 = pendingStream2.args.getCallOptions()).zzcxf());
            if (clientTransport == null) continue;
            Executor executor = this.defaultAppExecutor;
            if (zzh2.zzcfp() != null) {
                executor = zzh2.zzcfp();
            }
            executor.execute(new Runnable(this){

                @Override
                public void run() {
                    pendingStream2.createRealStream(clientTransport);
                }
            });
            arrayList2.add(pendingStream2);
        }
        object = this.lock;
        synchronized (object) {
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                return;
            }
            this.pendingStreams.removeAll(arrayList2);
            if (this.pendingStreams.isEmpty()) {
                this.channelExecutor.executeLater(this.reportTransportNotInUse);
                if (this.shutdown) {
                    this.pendingStreams = null;
                    this.channelExecutor.executeLater(this.reportTransportTerminated);
                } else {
                    this.pendingStreams = new LinkedHashSet<PendingStream>();
                }
            }
        }
        this.channelExecutor.drain();
    }

    @Override
    public final LogId getLogId() {
        return this.lodId;
    }

    class PendingStream
    extends DelayedStream {
        private final zzay args;
        private final zzy context = zzy.zzcxm();

        private PendingStream(zzay zzay2) {
            this.args = zzay2;
        }

        private void createRealStream(ClientTransport clientTransport) {
            ClientStream clientStream;
            zzy zzy2 = this.context.zzcxp();
            try {
                clientStream = clientTransport.newStream(this.args.getMethodDescriptor(), this.args.getHeaders(), this.args.getCallOptions());
            }
            finally {
                this.context.zza(zzy2);
            }
            this.setStream(clientStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(zzcq zzcq2) {
            super.cancel(zzcq2);
            Object object = DelayedClientTransport.this.lock;
            synchronized (object) {
                if (DelayedClientTransport.this.pendingStreams != null) {
                    boolean bl = DelayedClientTransport.this.pendingStreams.remove(this);
                    if (DelayedClientTransport.this.pendingStreams.isEmpty() && bl) {
                        DelayedClientTransport.this.channelExecutor.executeLater(DelayedClientTransport.this.reportTransportNotInUse);
                        if (DelayedClientTransport.this.shutdown) {
                            DelayedClientTransport.this.pendingStreams = null;
                            DelayedClientTransport.this.channelExecutor.executeLater(DelayedClientTransport.this.reportTransportTerminated);
                        }
                    }
                }
            }
            DelayedClientTransport.this.channelExecutor.drain();
        }
    }
}

