/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.NoopClientStream;
import io.grpc.zza;
import io.grpc.zzag;
import io.grpc.zzbe;
import io.grpc.zzcq;
import io.grpc.zzu;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class DelayedStream
implements ClientStream {
    private volatile boolean passThrough;
    private ClientStreamListener listener;
    private ClientStream realStream;
    private zzcq error;
    private List<Runnable> pendingCalls = new ArrayList<Runnable>();
    private DelayedStreamListener delayedListener;
    static final /* synthetic */ boolean $assertionsDisabled;

    DelayedStream() {
    }

    @Override
    public void setMaxInboundMessageSize(final int n) {
        if (this.passThrough) {
            this.realStream.setMaxInboundMessageSize(n);
            return;
        }
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.setMaxInboundMessageSize(n);
            }
        });
    }

    @Override
    public void setMaxOutboundMessageSize(final int n) {
        if (this.passThrough) {
            this.realStream.setMaxOutboundMessageSize(n);
            return;
        }
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.setMaxOutboundMessageSize(n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setStream(ClientStream clientStream) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (this.realStream != null) {
                return;
            }
            this.realStream = (ClientStream)Preconditions.checkNotNull((Object)clientStream, (Object)"stream");
        }
        this.drainPendingCalls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainPendingCalls() {
        DelayedStreamListener delayedStreamListener;
        List<Runnable> list = new ArrayList<Runnable>();
        while (true) {
            Object object = this;
            synchronized (object) {
                if (this.pendingCalls.isEmpty()) {
                    this.pendingCalls = null;
                    this.passThrough = true;
                    delayedStreamListener = this.delayedListener;
                    break;
                }
                ArrayList<Runnable> arrayList = list;
                list = this.pendingCalls;
                this.pendingCalls = arrayList;
            }
            object = list.iterator();
            while (object.hasNext()) {
                ((Runnable)object.next()).run();
            }
            list.clear();
        }
        if (delayedStreamListener != null) {
            delayedStreamListener.drainPendingCallbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOrExecute(Runnable runnable) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (!this.passThrough) {
                this.pendingCalls.add(runnable);
                return;
            }
        }
        runnable.run();
    }

    @Override
    public void setAuthority(final String string) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"May only be called before start");
        Preconditions.checkNotNull((Object)string, (Object)"authority");
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.setAuthority(string);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ClientStreamListener clientStreamListener) {
        boolean bl;
        zzcq zzcq2;
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        Object object = this;
        synchronized (object) {
            this.listener = (ClientStreamListener)Preconditions.checkNotNull((Object)clientStreamListener, (Object)"listener");
            zzcq2 = this.error;
            bl = this.passThrough;
            if (!bl) {
                this.delayedListener = new DelayedStreamListener(clientStreamListener);
                clientStreamListener = this.delayedListener;
            }
        }
        if (zzcq2 != null) {
            clientStreamListener.closed(zzcq2, new zzbe());
            return;
        }
        if (bl) {
            this.realStream.start(clientStreamListener);
            return;
        }
        object = clientStreamListener;
        this.delayOrExecute(new Runnable((ClientStreamListener)object){
            final /* synthetic */ ClientStreamListener val$finalListener;
            {
                this.val$finalListener = clientStreamListener;
            }

            @Override
            public void run() {
                DelayedStream.this.realStream.start(this.val$finalListener);
            }
        });
    }

    @Override
    public zza getAttributes() {
        Preconditions.checkState((boolean)this.passThrough, (Object)"Called getAttributes before attributes are ready");
        return this.realStream.getAttributes();
    }

    @Override
    public void writeMessage(final InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream, (Object)"message");
        if (this.passThrough) {
            this.realStream.writeMessage(inputStream);
            return;
        }
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.writeMessage(inputStream);
            }
        });
    }

    @Override
    public void flush() {
        if (this.passThrough) {
            this.realStream.flush();
            return;
        }
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.flush();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(final zzcq zzcq2) {
        Preconditions.checkNotNull((Object)zzcq2, (Object)"reason");
        boolean bl = true;
        ClientStreamListener clientStreamListener = null;
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (this.realStream == null) {
                this.realStream = NoopClientStream.INSTANCE;
                bl = false;
                clientStreamListener = this.listener;
                this.error = zzcq2;
            }
        }
        if (bl) {
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStream.this.realStream.cancel(zzcq2);
                }
            });
            return;
        }
        if (clientStreamListener != null) {
            clientStreamListener.closed(zzcq2, new zzbe());
        }
        this.drainPendingCalls();
    }

    @Override
    public void halfClose() {
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.halfClose();
            }
        });
    }

    @Override
    public void request(final int n) {
        if (this.passThrough) {
            this.realStream.request(n);
            return;
        }
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.request(n);
            }
        });
    }

    @Override
    public void setCompressor(final zzu zzu2) {
        Preconditions.checkNotNull((Object)zzu2, (Object)"compressor");
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.setCompressor(zzu2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDecompressor(zzag zzag2) {
        Preconditions.checkNotNull((Object)zzag2, (Object)"decompressor");
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
        }
        Preconditions.checkState((this.realStream != null ? 1 : 0) != 0, (Object)"How did we receive a reply before the request is sent?");
        this.realStream.setDecompressor(zzag2);
    }

    @Override
    public boolean isReady() {
        if (this.passThrough) {
            return this.realStream.isReady();
        }
        return false;
    }

    @Override
    public void setMessageCompression(final boolean bl) {
        if (this.passThrough) {
            this.realStream.setMessageCompression(bl);
            return;
        }
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.setMessageCompression(bl);
            }
        });
    }

    ClientStream getRealStream() {
        return this.realStream;
    }

    static class DelayedStreamListener
    implements ClientStreamListener {
        private final ClientStreamListener realListener;
        private volatile boolean passThrough;
        private List<Runnable> pendingCallbacks = new ArrayList<Runnable>();
        static final /* synthetic */ boolean $assertionsDisabled;

        public DelayedStreamListener(ClientStreamListener clientStreamListener) {
            this.realListener = clientStreamListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delayOrExecute(Runnable runnable) {
            DelayedStreamListener delayedStreamListener = this;
            synchronized (delayedStreamListener) {
                if (!this.passThrough) {
                    this.pendingCallbacks.add(runnable);
                    return;
                }
            }
            runnable.run();
        }

        @Override
        public void messageRead(final InputStream inputStream) {
            if (this.passThrough) {
                this.realListener.messageRead(inputStream);
                return;
            }
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStreamListener.this.realListener.messageRead(inputStream);
                }
            });
        }

        @Override
        public void onReady() {
            if (this.passThrough) {
                this.realListener.onReady();
                return;
            }
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStreamListener.this.realListener.onReady();
                }
            });
        }

        @Override
        public void headersRead(final zzbe zzbe2) {
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStreamListener.this.realListener.headersRead(zzbe2);
                }
            });
        }

        @Override
        public void closed(final zzcq zzcq2, final zzbe zzbe2) {
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStreamListener.this.realListener.closed(zzcq2, zzbe2);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drainPendingCallbacks() {
            List<Runnable> list = new ArrayList<Runnable>();
            while (true) {
                Object object = this;
                synchronized (object) {
                    if (this.pendingCallbacks.isEmpty()) {
                        this.pendingCallbacks = null;
                        this.passThrough = true;
                        return;
                    }
                    ArrayList<Runnable> arrayList = list;
                    list = this.pendingCallbacks;
                    this.pendingCallbacks = arrayList;
                }
                object = list.iterator();
                while (object.hasNext()) {
                    ((Runnable)object.next()).run();
                }
                list.clear();
            }
        }
    }
}

