/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.NameResolverProvider;
import io.grpc.internal.DnsNameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.zza;
import java.net.URI;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";

    public DnsNameResolverProvider() {
    }

    @Override
    public final DnsNameResolver newNameResolver(URI uRI, zza zza2) {
        if (SCHEME.equals(uRI.getScheme())) {
            String string = (String)Preconditions.checkNotNull((Object)uRI.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)string.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object)string, (Object)uRI);
            String string2 = string.substring(1);
            return new DnsNameResolver(uRI.getAuthority(), string2, zza2, GrpcUtil.TIMER_SERVICE, GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        }
        return null;
    }

    @Override
    public final String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected final boolean isAvailable() {
        return true;
    }

    @Override
    protected final int priority() {
        return 5;
    }
}

