/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.grpc.InternalMetadata;
import io.grpc.internal.AbstractClientStream;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ReadableBuffers;
import io.grpc.internal.StatsTraceContext;
import io.grpc.zzas;
import io.grpc.zzbe;
import io.grpc.zzbm;
import io.grpc.zzcq;
import java.nio.charset.Charset;

public abstract class Http2ClientStreamTransportState
extends AbstractClientStream.TransportState {
    private static final InternalMetadata.TrustedAsciiMarshaller<Integer> HTTP_STATUS_MARSHALLER = new InternalMetadata.TrustedAsciiMarshaller<Integer>(){

        @Override
        public byte[] toAsciiString(Integer n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer parseAsciiString(byte[] byArray) {
            if (byArray.length >= 3) {
                return (byArray[0] - 48) * 100 + (byArray[1] - 48) * 10 + (byArray[2] - 48);
            }
            String string = String.valueOf(new String(byArray, InternalMetadata.US_ASCII));
            throw new NumberFormatException(string.length() != 0 ? "Malformed status code ".concat(string) : new String("Malformed status code "));
        }
    };
    private static final zzbm<Integer> HTTP2_STATUS = InternalMetadata.zza(":status", HTTP_STATUS_MARSHALLER);
    private zzcq transportError;
    private zzbe transportErrorMetadata;
    private Charset errorCharset = Charsets.UTF_8;
    private boolean headersReceived;

    protected Http2ClientStreamTransportState(int n, StatsTraceContext statsTraceContext) {
        super(n, statsTraceContext);
    }

    protected abstract void http2ProcessingFailed(zzcq var1, zzbe var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void transportHeadersReceived(zzbe zzbe2) {
        Object object;
        block8: {
            block7: {
                block6: {
                    Preconditions.checkNotNull((Object)zzbe2, (Object)"headers");
                    if (this.transportError != null) {
                        String string = String.valueOf(zzbe2);
                        this.transportError = this.transportError.zztx(new StringBuilder(9 + String.valueOf(string).length()).append("headers: ").append(string).toString());
                        return;
                    }
                    try {
                        if (!this.headersReceived) break block6;
                        this.transportError = zzcq.zzpci.zztw("Received headers twice");
                        if (this.transportError == null) return;
                    }
                    catch (Throwable throwable) {
                        if (this.transportError == null) throw throwable;
                        String string = String.valueOf(zzbe2);
                        this.transportError = this.transportError.zztx(new StringBuilder(9 + String.valueOf(string).length()).append("headers: ").append(string).toString());
                        this.transportErrorMetadata = zzbe2;
                        this.errorCharset = Http2ClientStreamTransportState.extractCharset(zzbe2);
                        throw throwable;
                    }
                    String string = String.valueOf(zzbe2);
                    this.transportError = this.transportError.zztx(new StringBuilder(9 + String.valueOf(string).length()).append("headers: ").append(string).toString());
                    this.transportErrorMetadata = zzbe2;
                    this.errorCharset = Http2ClientStreamTransportState.extractCharset(zzbe2);
                    return;
                }
                object = zzbe2.zzb(HTTP2_STATUS);
                if (object == null || (Integer)object < 100 || (Integer)object >= 200) break block7;
                if (this.transportError == null) return;
                String string = String.valueOf(zzbe2);
                this.transportError = this.transportError.zztx(new StringBuilder(9 + String.valueOf(string).length()).append("headers: ").append(string).toString());
                this.transportErrorMetadata = zzbe2;
                this.errorCharset = Http2ClientStreamTransportState.extractCharset(zzbe2);
                return;
            }
            this.headersReceived = true;
            this.transportError = this.validateInitialMetadata(zzbe2);
            if (this.transportError == null) break block8;
            if (this.transportError == null) return;
            String string = String.valueOf(zzbe2);
            this.transportError = this.transportError.zztx(new StringBuilder(9 + String.valueOf(string).length()).append("headers: ").append(string).toString());
            this.transportErrorMetadata = zzbe2;
            this.errorCharset = Http2ClientStreamTransportState.extractCharset(zzbe2);
            return;
        }
        Http2ClientStreamTransportState.stripTransportDetails(zzbe2);
        this.inboundHeadersReceived(zzbe2);
        if (this.transportError == null) return;
        object = String.valueOf(zzbe2);
        this.transportError = this.transportError.zztx(new StringBuilder(9 + String.valueOf(object).length()).append("headers: ").append((String)object).toString());
        this.transportErrorMetadata = zzbe2;
        this.errorCharset = Http2ClientStreamTransportState.extractCharset(zzbe2);
    }

    protected void transportDataReceived(ReadableBuffer readableBuffer, boolean bl) {
        if (this.transportError != null) {
            String string = String.valueOf(ReadableBuffers.readAsString(readableBuffer, this.errorCharset));
            this.transportError = this.transportError.zztx(string.length() != 0 ? "DATA-----------------------------\n".concat(string) : new String("DATA-----------------------------\n"));
            readableBuffer.close();
            if (this.transportError.getDescription().length() > 1000 || bl) {
                this.http2ProcessingFailed(this.transportError, this.transportErrorMetadata);
                return;
            }
        } else {
            if (!this.headersReceived) {
                this.http2ProcessingFailed(zzcq.zzpci.zztw("headers not received before payload"), new zzbe());
                return;
            }
            this.inboundDataReceived(readableBuffer);
            if (bl) {
                this.transportError = zzcq.zzpci.zztw("Received unexpected EOS on DATA frame from server.");
                this.transportErrorMetadata = new zzbe();
                this.transportReportStatus(this.transportError, false, this.transportErrorMetadata);
            }
        }
    }

    protected void transportTrailersReceived(zzbe zzbe2) {
        Preconditions.checkNotNull((Object)zzbe2, (Object)"trailers");
        if (this.transportError == null && !this.headersReceived) {
            this.transportError = this.validateInitialMetadata(zzbe2);
            if (this.transportError != null) {
                this.transportErrorMetadata = zzbe2;
            }
        }
        if (this.transportError != null) {
            String string = String.valueOf(zzbe2);
            this.transportError = this.transportError.zztx(new StringBuilder(10 + String.valueOf(string).length()).append("trailers: ").append(string).toString());
            this.http2ProcessingFailed(this.transportError, this.transportErrorMetadata);
            return;
        }
        zzcq zzcq2 = this.statusFromTrailers(zzbe2);
        Http2ClientStreamTransportState.stripTransportDetails(zzbe2);
        this.inboundTrailersReceived(zzbe2, zzcq2);
    }

    private zzcq statusFromTrailers(zzbe zzbe2) {
        zzcq zzcq2 = zzbe2.zzb(zzas.zzpaj);
        if (zzcq2 != null) {
            return zzcq2.zztw(zzbe2.zzb(zzas.zzpai));
        }
        if (this.headersReceived) {
            return zzcq.zzpbw.zztw("missing GRPC status in response");
        }
        Integer n = zzbe2.zzb(HTTP2_STATUS);
        zzcq2 = n != null ? GrpcUtil.httpStatusToGrpcStatus(n) : zzcq.zzpci.zztw("missing HTTP status code");
        return zzcq2.zztx("missing GRPC status, inferred error from HTTP status code");
    }

    private zzcq validateInitialMetadata(zzbe zzbe2) {
        Integer n = zzbe2.zzb(HTTP2_STATUS);
        if (n == null) {
            return zzcq.zzpci.zztw("Missing HTTP status code");
        }
        String string = zzbe2.zzb(GrpcUtil.CONTENT_TYPE_KEY);
        if (!GrpcUtil.isGrpcContentType(string)) {
            String string2 = String.valueOf(string);
            return GrpcUtil.httpStatusToGrpcStatus(n).zztx(string2.length() != 0 ? "invalid content-type: ".concat(string2) : new String("invalid content-type: "));
        }
        return null;
    }

    private static Charset extractCharset(zzbe zzbe2) {
        String string = zzbe2.zzb(GrpcUtil.CONTENT_TYPE_KEY);
        if (string != null) {
            String[] stringArray = string.split("charset=");
            try {
                return Charset.forName(stringArray[stringArray.length - 1].trim());
            }
            catch (Exception exception) {}
        }
        return Charsets.UTF_8;
    }

    private static void stripTransportDetails(zzbe zzbe2) {
        zzbe2.zzc(HTTP2_STATUS);
        zzbe2.zzc(zzas.zzpaj);
        zzbe2.zzc(zzas.zzpai);
    }
}

