/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ChannelExecutor;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.InUseStateAggregator;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.WithLogId;
import io.grpc.zzak;
import io.grpc.zzcq;
import io.grpc.zzw;
import io.grpc.zzx;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class InternalSubchannel
implements WithLogId {
    private static final Logger log = Logger.getLogger(InternalSubchannel.class.getName());
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final String authority;
    private final String userAgent;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Callback callback;
    private final ClientTransportFactory transportFactory;
    private final ScheduledExecutorService scheduledExecutor;
    private final Object lock = new Object();
    private final ChannelExecutor channelExecutor;
    private zzak addressGroup;
    private int addressIndex;
    private BackoffPolicy reconnectPolicy;
    private final Stopwatch connectingTimer;
    private ScheduledFuture<?> reconnectTask;
    private final Collection<ConnectionClientTransport> transports = new ArrayList<ConnectionClientTransport>();
    private final InUseStateAggregator<ConnectionClientTransport> inUseStateAggregator = new InUseStateAggregator<ConnectionClientTransport>(){

        @Override
        void handleInUse() {
            InternalSubchannel.this.callback.onInUse(InternalSubchannel.this);
        }

        @Override
        void handleNotInUse() {
            InternalSubchannel.this.callback.onNotInUse(InternalSubchannel.this);
        }
    };
    private ConnectionClientTransport pendingTransport;
    private volatile ManagedClientTransport activeTransport;
    private zzx state = zzx.zza(zzw.zzoyz);

    InternalSubchannel(zzak zzak2, String string, String string2, BackoffPolicy.Provider provider, ClientTransportFactory clientTransportFactory, ScheduledExecutorService scheduledExecutorService, Supplier<Stopwatch> supplier, ChannelExecutor channelExecutor, Callback callback) {
        this.addressGroup = (zzak)Preconditions.checkNotNull((Object)zzak2, (Object)"addressGroup");
        this.authority = string;
        this.userAgent = string2;
        this.backoffPolicyProvider = provider;
        this.transportFactory = clientTransportFactory;
        this.scheduledExecutor = scheduledExecutorService;
        this.connectingTimer = (Stopwatch)supplier.get();
        this.channelExecutor = channelExecutor;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ClientTransport obtainActiveTransport() {
        ManagedClientTransport managedClientTransport = this.activeTransport;
        if (managedClientTransport != null) {
            return managedClientTransport;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                block10: {
                    managedClientTransport = this.activeTransport;
                    if (managedClientTransport == null) break block10;
                    ManagedClientTransport managedClientTransport2 = managedClientTransport;
                    return managedClientTransport2;
                }
                if (this.state.getState() == zzw.zzoyz) {
                    this.gotoNonErrorState(zzw.zzoyw);
                    this.startNewTransport();
                }
            }
        }
        finally {
            this.channelExecutor.drain();
        }
        return null;
    }

    private final void startNewTransport() {
        Preconditions.checkState((this.reconnectTask == null ? 1 : 0) != 0, (Object)"Should have no reconnectTask scheduled");
        if (this.addressIndex == 0) {
            this.connectingTimer.reset().start();
        }
        SocketAddress socketAddress = this.addressGroup.zzcxy().get(this.addressIndex);
        ConnectionClientTransport connectionClientTransport = this.transportFactory.newClientTransport(socketAddress, this.authority, this.userAgent);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, "io.grpc.internal.InternalSubchannel", "startNewTransport", "[{0}] Created {1} for {2}", new Object[]{this.logId, connectionClientTransport.getLogId(), socketAddress});
        }
        this.pendingTransport = connectionClientTransport;
        this.transports.add(connectionClientTransport);
        Runnable runnable = connectionClientTransport.start(new TransportListener(connectionClientTransport, socketAddress));
        if (runnable != null) {
            this.channelExecutor.executeLater(runnable);
        }
    }

    private final void scheduleBackoff(zzcq zzcq2) {
        this.gotoState(zzx.zzg(zzcq2));
        if (this.reconnectPolicy == null) {
            this.reconnectPolicy = this.backoffPolicyProvider.get();
        }
        long l = this.reconnectPolicy.nextBackoffNanos() - this.connectingTimer.elapsed(TimeUnit.NANOSECONDS);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, "io.grpc.internal.InternalSubchannel", "scheduleBackoff", "[{0}] Scheduling backoff for {1} ns", new Object[]{this.logId, l});
        }
        Preconditions.checkState((this.reconnectTask == null ? 1 : 0) != 0, (Object)"previous reconnectTask is not done");
        class EndOfCurrentBackoff
        implements Runnable {
            EndOfCurrentBackoff() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = InternalSubchannel.this.lock;
                    synchronized (object) {
                        block10: {
                            InternalSubchannel.this.reconnectTask = null;
                            if (InternalSubchannel.this.state.getState() != zzw.zzoza) break block10;
                            return;
                        }
                        InternalSubchannel.this.gotoNonErrorState(zzw.zzoyw);
                        InternalSubchannel.this.startNewTransport();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    log.logp(Level.WARNING, "io.grpc.internal.InternalSubchannel$1EndOfCurrentBackoff", "run", "Exception handling end of backoff", throwable);
                    return;
                }
                finally {
                    InternalSubchannel.this.channelExecutor.drain();
                }
            }
        }
        this.reconnectTask = this.scheduledExecutor.schedule(new LogExceptionRunnable(new EndOfCurrentBackoff()), l, TimeUnit.NANOSECONDS);
    }

    private final void gotoNonErrorState(zzw zzw2) {
        this.gotoState(zzx.zza(zzw2));
    }

    private final void gotoState(final zzx zzx2) {
        if (this.state.getState() != zzx2.getState()) {
            String string = String.valueOf(zzx2);
            Preconditions.checkState((this.state.getState() != zzw.zzoza ? 1 : 0) != 0, (Object)new StringBuilder(37 + String.valueOf(string).length()).append("Cannot transition out of SHUTDOWN to ").append(string).toString());
            this.state = zzx2;
            this.channelExecutor.executeLater(new Runnable(){

                @Override
                public void run() {
                    InternalSubchannel.this.callback.onStateChange(InternalSubchannel.this, zzx2);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAddresses(zzak zzak2) {
        ManagedClientTransport managedClientTransport = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                zzak zzak3 = this.addressGroup;
                this.addressGroup = zzak2;
                if (this.state.getState() == zzw.zzoyx || this.state.getState() == zzw.zzoyw) {
                    SocketAddress socketAddress = zzak3.zzcxy().get(this.addressIndex);
                    int n = zzak2.zzcxy().indexOf(socketAddress);
                    if (n != -1) {
                        this.addressIndex = n;
                    } else if (this.state.getState() == zzw.zzoyx) {
                        managedClientTransport = this.activeTransport;
                        this.activeTransport = null;
                        this.addressIndex = 0;
                        this.gotoNonErrorState(zzw.zzoyz);
                    } else {
                        managedClientTransport = this.pendingTransport;
                        this.pendingTransport = null;
                        this.addressIndex = 0;
                        this.startNewTransport();
                    }
                }
            }
        }
        finally {
            this.channelExecutor.drain();
        }
        if (managedClientTransport != null) {
            managedClientTransport.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        ConnectionClientTransport connectionClientTransport;
        ManagedClientTransport managedClientTransport;
        try {
            Object object = this.lock;
            synchronized (object) {
                block12: {
                    if (this.state.getState() != zzw.zzoza) break block12;
                    return;
                }
                this.gotoNonErrorState(zzw.zzoza);
                managedClientTransport = this.activeTransport;
                connectionClientTransport = this.pendingTransport;
                this.activeTransport = null;
                this.pendingTransport = null;
                this.addressIndex = 0;
                if (this.transports.isEmpty()) {
                    this.handleTermination();
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, "io.grpc.internal.InternalSubchannel", "shutdown", "[{0}] Terminated in shutdown()", this.logId);
                    }
                }
                this.cancelReconnectTask();
            }
        }
        finally {
            this.channelExecutor.drain();
        }
        if (managedClientTransport != null) {
            managedClientTransport.shutdown();
        }
        if (connectionClientTransport != null) {
            connectionClientTransport.shutdown();
        }
    }

    private final void handleTermination() {
        this.channelExecutor.executeLater(new Runnable(){

            @Override
            public void run() {
                InternalSubchannel.this.callback.onTerminated(InternalSubchannel.this);
            }
        });
    }

    private final void handleTransportInUseState(final ConnectionClientTransport connectionClientTransport, final boolean bl) {
        this.channelExecutor.executeLater(new Runnable(){

            @Override
            public void run() {
                InternalSubchannel.this.inUseStateAggregator.updateObjectInUse(connectionClientTransport, bl);
            }
        }).drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void shutdownNow(zzcq zzcq2) {
        ArrayList<ConnectionClientTransport> arrayList;
        this.shutdown();
        try {
            Object object = this.lock;
            synchronized (object) {
                arrayList = new ArrayList<ConnectionClientTransport>(this.transports);
            }
        }
        finally {
            this.channelExecutor.drain();
        }
        ArrayList<ConnectionClientTransport> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            ConnectionClientTransport connectionClientTransport = arrayList2.get(i);
            ((ManagedClientTransport)connectionClientTransport).shutdownNow(zzcq2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final zzak getAddressGroup() {
        try {
            Object object = this.lock;
            synchronized (object) {
                zzak zzak2 = this.addressGroup;
                return zzak2;
            }
        }
        finally {
            this.channelExecutor.drain();
        }
    }

    private final void cancelReconnectTask() {
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel(false);
            this.reconnectTask = null;
        }
    }

    @Override
    public final LogId getLogId() {
        return this.logId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final zzw getState() {
        try {
            Object object = this.lock;
            synchronized (object) {
                zzw zzw2 = this.state.getState();
                return zzw2;
            }
        }
        finally {
            this.channelExecutor.drain();
        }
    }

    static abstract class Callback {
        Callback() {
        }

        void onTerminated(InternalSubchannel internalSubchannel) {
        }

        void onStateChange(InternalSubchannel internalSubchannel, zzx zzx2) {
        }

        void onInUse(InternalSubchannel internalSubchannel) {
        }

        void onNotInUse(InternalSubchannel internalSubchannel) {
        }
    }

    class TransportListener
    implements ManagedClientTransport.Listener {
        final ConnectionClientTransport transport;
        final SocketAddress address;

        TransportListener(ConnectionClientTransport connectionClientTransport, SocketAddress socketAddress) {
            this.transport = connectionClientTransport;
            this.address = socketAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportReady() {
            zzw zzw2;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, "io.grpc.internal.InternalSubchannel$TransportListener", "transportReady", "[{0}] {1} for {2} is ready", new Object[]{InternalSubchannel.this.logId, this.transport.getLogId(), this.address});
            }
            try {
                Object object = InternalSubchannel.this.lock;
                synchronized (object) {
                    zzw2 = InternalSubchannel.this.state.getState();
                    InternalSubchannel.this.reconnectPolicy = null;
                    if (zzw2 == zzw.zzoza) {
                        Preconditions.checkState((InternalSubchannel.this.activeTransport == null ? 1 : 0) != 0, (Object)"Unexpected non-null activeTransport");
                    } else if (InternalSubchannel.this.pendingTransport == this.transport) {
                        InternalSubchannel.this.gotoNonErrorState(zzw.zzoyx);
                        InternalSubchannel.this.activeTransport = this.transport;
                        InternalSubchannel.this.pendingTransport = null;
                    }
                }
            }
            finally {
                InternalSubchannel.this.channelExecutor.drain();
            }
            if (zzw2 == zzw.zzoza) {
                this.transport.shutdown();
            }
        }

        @Override
        public void transportInUse(boolean bl) {
            InternalSubchannel.this.handleTransportInUseState(this.transport, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportShutdown(zzcq zzcq2) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, "io.grpc.internal.InternalSubchannel$TransportListener", "transportShutdown", "[{0}] {1} for {2} is being shutdown with status {3}", new Object[]{InternalSubchannel.this.logId, this.transport.getLogId(), this.address, zzcq2});
            }
            try {
                Object object = InternalSubchannel.this.lock;
                synchronized (object) {
                    block14: {
                        if (InternalSubchannel.this.state.getState() != zzw.zzoza) break block14;
                        return;
                    }
                    if (InternalSubchannel.this.activeTransport == this.transport) {
                        InternalSubchannel.this.gotoNonErrorState(zzw.zzoyz);
                        InternalSubchannel.this.activeTransport = null;
                        InternalSubchannel.this.addressIndex = 0;
                    } else if (InternalSubchannel.this.pendingTransport == this.transport) {
                        Preconditions.checkState((InternalSubchannel.this.state.getState() == zzw.zzoyw ? 1 : 0) != 0, (String)"Expected state is CONNECTING, actual state is %s", (Object)((Object)InternalSubchannel.this.state.getState()));
                        InternalSubchannel.this.addressIndex++;
                        if (InternalSubchannel.this.addressIndex >= InternalSubchannel.this.addressGroup.zzcxy().size()) {
                            InternalSubchannel.this.pendingTransport = null;
                            InternalSubchannel.this.addressIndex = 0;
                            InternalSubchannel.this.scheduleBackoff(zzcq2);
                        } else {
                            InternalSubchannel.this.startNewTransport();
                        }
                    }
                }
                return;
            }
            finally {
                InternalSubchannel.this.channelExecutor.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportTerminated() {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, "io.grpc.internal.InternalSubchannel$TransportListener", "transportTerminated", "[{0}] {1} for {2} is terminated", new Object[]{InternalSubchannel.this.logId, this.transport.getLogId(), this.address});
            }
            InternalSubchannel.this.handleTransportInUseState(this.transport, false);
            try {
                Object object = InternalSubchannel.this.lock;
                synchronized (object) {
                    InternalSubchannel.this.transports.remove(this.transport);
                    if (InternalSubchannel.this.state.getState() == zzw.zzoza && InternalSubchannel.this.transports.isEmpty()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.logp(Level.FINE, "io.grpc.internal.InternalSubchannel$TransportListener", "transportTerminated", "[{0}] Terminated in transportTerminated()", InternalSubchannel.this.logId);
                        }
                        InternalSubchannel.this.handleTermination();
                    }
                }
            }
            finally {
                InternalSubchannel.this.channelExecutor.drain();
            }
            Preconditions.checkState((InternalSubchannel.this.activeTransport != this.transport ? 1 : 0) != 0, (Object)"activeTransport still points to this transport. Seems transportShutdown() was not called.");
        }
    }
}

