/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdgi;
import com.google.common.base.Preconditions;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.zzcq;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class KeepAliveManager {
    private static final SystemTicker SYSTEM_TICKER = new SystemTicker();
    private static final long MIN_KEEPALIVE_TIME_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private static final long MIN_KEEPALIVE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(10L);
    private final ScheduledExecutorService scheduler;
    private final Ticker ticker;
    private final KeepAlivePinger keepAlivePinger;
    private final boolean keepAliveDuringTransportIdle;
    private State state = State.IDLE;
    private long nextKeepaliveTime;
    private ScheduledFuture<?> shutdownFuture;
    private ScheduledFuture<?> pingFuture;
    private final Runnable shutdown = new LogExceptionRunnable(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            KeepAliveManager keepAliveManager = KeepAliveManager.this;
            synchronized (keepAliveManager) {
                if (KeepAliveManager.this.state != State.DISCONNECTED) {
                    KeepAliveManager.this.state = State.DISCONNECTED;
                    bl = true;
                }
            }
            if (bl) {
                KeepAliveManager.this.keepAlivePinger.onPingTimeout();
            }
        }
    });
    private final Runnable sendPing = new LogExceptionRunnable(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            KeepAliveManager keepAliveManager = KeepAliveManager.this;
            synchronized (keepAliveManager) {
                if (KeepAliveManager.this.state == State.PING_SCHEDULED) {
                    bl = true;
                    KeepAliveManager.this.state = State.PING_SENT;
                    KeepAliveManager.this.shutdownFuture = KeepAliveManager.this.scheduler.schedule(KeepAliveManager.this.shutdown, KeepAliveManager.this.keepAliveTimeoutInNanos, TimeUnit.NANOSECONDS);
                } else if (KeepAliveManager.this.state == State.PING_DELAYED) {
                    KeepAliveManager.this.pingFuture = KeepAliveManager.this.scheduler.schedule(KeepAliveManager.this.sendPing, KeepAliveManager.this.nextKeepaliveTime - KeepAliveManager.this.ticker.read(), TimeUnit.NANOSECONDS);
                    KeepAliveManager.this.state = State.PING_SCHEDULED;
                }
            }
            if (bl) {
                KeepAliveManager.this.keepAlivePinger.ping();
            }
        }
    });
    private long keepAliveTimeInNanos;
    private long keepAliveTimeoutInNanos;

    public KeepAliveManager(KeepAlivePinger keepAlivePinger, ScheduledExecutorService scheduledExecutorService, long l, long l2, boolean bl) {
        this(keepAlivePinger, scheduledExecutorService, SYSTEM_TICKER, l, l2, bl);
    }

    KeepAliveManager(KeepAlivePinger keepAlivePinger, ScheduledExecutorService scheduledExecutorService, Ticker ticker, long l, long l2, boolean bl) {
        this.keepAlivePinger = (KeepAlivePinger)Preconditions.checkNotNull((Object)keepAlivePinger, (Object)"keepAlivePinger");
        this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduler");
        this.ticker = (Ticker)Preconditions.checkNotNull((Object)ticker, (Object)"ticker");
        this.keepAliveTimeInNanos = l;
        this.keepAliveTimeoutInNanos = l2;
        this.keepAliveDuringTransportIdle = bl;
        this.nextKeepaliveTime = ticker.read() + l;
    }

    public synchronized void onTransportStarted() {
        if (this.keepAliveDuringTransportIdle) {
            this.onTransportActive();
        }
    }

    public synchronized void onDataReceived() {
        this.nextKeepaliveTime = this.ticker.read() + this.keepAliveTimeInNanos;
        if (this.state == State.PING_SCHEDULED) {
            this.state = State.PING_DELAYED;
            return;
        }
        if (this.state == State.PING_SENT || this.state == State.IDLE_AND_PING_SENT) {
            if (this.shutdownFuture != null) {
                this.shutdownFuture.cancel(false);
            }
            if (this.state == State.IDLE_AND_PING_SENT) {
                this.state = State.IDLE;
                return;
            }
            this.state = State.PING_SCHEDULED;
            this.pingFuture = this.scheduler.schedule(this.sendPing, this.keepAliveTimeInNanos, TimeUnit.NANOSECONDS);
        }
    }

    public synchronized void onTransportActive() {
        if (this.state == State.IDLE) {
            this.state = State.PING_SCHEDULED;
            this.pingFuture = this.scheduler.schedule(this.sendPing, this.nextKeepaliveTime - this.ticker.read(), TimeUnit.NANOSECONDS);
            return;
        }
        if (this.state == State.IDLE_AND_PING_SENT) {
            this.state = State.PING_SENT;
        }
    }

    public synchronized void onTransportIdle() {
        if (this.keepAliveDuringTransportIdle) {
            return;
        }
        if (this.state == State.PING_SCHEDULED || this.state == State.PING_DELAYED) {
            this.state = State.IDLE;
        }
        if (this.state == State.PING_SENT) {
            this.state = State.IDLE_AND_PING_SENT;
        }
    }

    public synchronized void onTransportTermination() {
        if (this.state != State.DISCONNECTED) {
            this.state = State.DISCONNECTED;
            if (this.shutdownFuture != null) {
                this.shutdownFuture.cancel(false);
            }
            if (this.pingFuture != null) {
                this.pingFuture.cancel(false);
            }
        }
    }

    public static long clampKeepAliveTimeInNanos(long l) {
        return Math.max(l, MIN_KEEPALIVE_TIME_NANOS);
    }

    public static long clampKeepAliveTimeoutInNanos(long l) {
        return Math.max(l, MIN_KEEPALIVE_TIMEOUT_NANOS);
    }

    static class SystemTicker
    extends Ticker {
        private SystemTicker() {
        }

        @Override
        public long read() {
            return System.nanoTime();
        }
    }

    static abstract class Ticker {
        Ticker() {
        }

        public abstract long read();
    }

    public static final class ClientKeepAlivePinger
    implements KeepAlivePinger {
        private final ConnectionClientTransport transport;

        public ClientKeepAlivePinger(ConnectionClientTransport connectionClientTransport) {
            this.transport = connectionClientTransport;
        }

        @Override
        public final void ping() {
            this.transport.ping(new ClientTransport.PingCallback(){

                @Override
                public void onSuccess(long l) {
                }

                @Override
                public void onFailure(Throwable throwable) {
                    ClientKeepAlivePinger.this.transport.shutdownNow(zzcq.zzpcj.zztw("Keepalive failed. The connection is likely gone"));
                }
            }, zzdgi.zzbjt());
        }

        @Override
        public final void onPingTimeout() {
            this.transport.shutdownNow(zzcq.zzpcj.zztw("Keepalive failed. The connection is likely gone"));
        }
    }

    public static interface KeepAlivePinger {
        public void ping();

        public void onPingTimeout();
    }

    static enum State {
        IDLE,
        PING_SCHEDULED,
        PING_DELAYED,
        PING_SENT,
        IDLE_AND_PING_SENT,
        DISCONNECTED;


        private State() {
        }
    }
}

