/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdfv;
import com.google.common.base.Preconditions;
import io.grpc.internal.Framer;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import io.grpc.zzaj;
import io.grpc.zzat;
import io.grpc.zzcq;
import io.grpc.zzt;
import io.grpc.zzu;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MessageFramer
implements Framer {
    private static final int NO_MAX_OUTBOUND_MESSAGE_SIZE = -1;
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED = 0;
    private static final byte COMPRESSED = 1;
    private final Sink sink;
    private int maxOutboundMessageSize = -1;
    private WritableBuffer buffer;
    private zzu compressor = zzt.zzoyt;
    private boolean messageCompression = true;
    private final OutputStreamAdapter outputStreamAdapter = new OutputStreamAdapter();
    private final byte[] headerScratch = new byte[5];
    private final WritableBufferAllocator bufferAllocator;
    private final StatsTraceContext statsTraceCtx;
    private boolean closed;

    public MessageFramer(Sink sink, WritableBufferAllocator writableBufferAllocator, StatsTraceContext statsTraceContext) {
        this.sink = (Sink)Preconditions.checkNotNull((Object)sink, (Object)"sink");
        this.bufferAllocator = (WritableBufferAllocator)Preconditions.checkNotNull((Object)writableBufferAllocator, (Object)"bufferAllocator");
        this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceContext, (Object)"statsTraceCtx");
    }

    @Override
    public MessageFramer setCompressor(zzu zzu2) {
        this.compressor = (zzu)Preconditions.checkNotNull((Object)zzu2, (Object)"Can't pass an empty compressor");
        return this;
    }

    @Override
    public MessageFramer setMessageCompression(boolean bl) {
        this.messageCompression = bl;
        return this;
    }

    @Override
    public void setMaxOutboundMessageSize(int n) {
        Preconditions.checkState((this.maxOutboundMessageSize == -1 ? 1 : 0) != 0, (Object)"max size already set");
        this.maxOutboundMessageSize = n;
    }

    @Override
    public void writePayload(InputStream inputStream) {
        int n;
        int n2;
        this.verifyNotClosed();
        this.statsTraceCtx.outboundMessage();
        boolean bl = this.messageCompression && this.compressor != zzt.zzoyt;
        try {
            n2 = this.getKnownLength(inputStream);
            n = n2 != 0 && bl ? this.writeCompressed(inputStream, n2) : this.writeUncompressed(inputStream, n2);
        }
        catch (IOException iOException) {
            throw zzcq.zzpci.zztw("Failed to frame message").zzl(iOException).zzcyu();
        }
        catch (RuntimeException runtimeException) {
            throw zzcq.zzpci.zztw("Failed to frame message").zzl(runtimeException).zzcyu();
        }
        if (n2 != -1 && n != n2) {
            String string = String.format("Message length inaccurate %s != %s", n, n2);
            throw zzcq.zzpci.zztw(string).zzcyu();
        }
        this.statsTraceCtx.outboundUncompressedSize(n);
    }

    private int writeUncompressed(InputStream inputStream, int n) throws IOException {
        if (n != -1) {
            this.statsTraceCtx.outboundWireSize(n);
            return this.writeKnownLengthUncompressed(inputStream, n);
        }
        BufferChainOutputStream bufferChainOutputStream = new BufferChainOutputStream();
        int n2 = MessageFramer.writeToOutputStream(inputStream, bufferChainOutputStream);
        if (this.maxOutboundMessageSize >= 0 && n2 > this.maxOutboundMessageSize) {
            throw zzcq.zzpcd.zztw(String.format("message too large %d > %d", n2, this.maxOutboundMessageSize)).zzcyu();
        }
        this.writeBufferChain(bufferChainOutputStream, false);
        return n2;
    }

    private int writeCompressed(InputStream inputStream, int n) throws IOException {
        int n2;
        BufferChainOutputStream bufferChainOutputStream = new BufferChainOutputStream();
        try (OutputStream outputStream = this.compressor.zzc(bufferChainOutputStream);){
            n2 = MessageFramer.writeToOutputStream(inputStream, outputStream);
        }
        if (this.maxOutboundMessageSize >= 0 && n2 > this.maxOutboundMessageSize) {
            throw zzcq.zzpcd.zztw(String.format("message too large %d > %d", n2, this.maxOutboundMessageSize)).zzcyu();
        }
        this.writeBufferChain(bufferChainOutputStream, true);
        return n2;
    }

    private int getKnownLength(InputStream inputStream) throws IOException {
        if (inputStream instanceof zzat || inputStream instanceof ByteArrayInputStream) {
            return inputStream.available();
        }
        return -1;
    }

    private int writeKnownLengthUncompressed(InputStream inputStream, int n) throws IOException {
        if (this.maxOutboundMessageSize >= 0 && n > this.maxOutboundMessageSize) {
            throw zzcq.zzpcd.zztw(String.format("message too large %d > %d", n, this.maxOutboundMessageSize)).zzcyu();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.headerScratch);
        byteBuffer.put((byte)0);
        byteBuffer.putInt(n);
        if (this.buffer == null) {
            this.buffer = this.bufferAllocator.allocate(byteBuffer.position() + n);
        }
        this.writeRaw(this.headerScratch, 0, byteBuffer.position());
        return MessageFramer.writeToOutputStream(inputStream, this.outputStreamAdapter);
    }

    private void writeBufferChain(BufferChainOutputStream bufferChainOutputStream, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.headerScratch);
        byteBuffer.put(bl ? (byte)1 : 0);
        int n = bufferChainOutputStream.readableBytes();
        byteBuffer.putInt(n);
        WritableBuffer writableBuffer = this.bufferAllocator.allocate(5);
        writableBuffer.write(this.headerScratch, 0, byteBuffer.position());
        if (n == 0) {
            this.buffer = writableBuffer;
            return;
        }
        this.sink.deliverFrame(writableBuffer, false, false);
        List list = bufferChainOutputStream.bufferList;
        for (int i = 0; i < list.size() - 1; ++i) {
            this.sink.deliverFrame((WritableBuffer)list.get(i), false, false);
        }
        this.buffer = (WritableBuffer)list.get(list.size() - 1);
        this.statsTraceCtx.outboundWireSize(n);
    }

    private static int writeToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream instanceof zzaj) {
            return ((zzaj)((Object)inputStream)).zzd(outputStream);
        }
        long l = zzdfv.zza(inputStream, outputStream);
        Preconditions.checkArgument((l <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message size overflow: %s", (long)l);
        return (int)l;
    }

    private void writeRaw(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            if (this.buffer != null && this.buffer.writableBytes() == 0) {
                this.commitToSink(false, false);
            }
            if (this.buffer == null) {
                this.buffer = this.bufferAllocator.allocate(n2);
            }
            int n3 = Math.min(n2, this.buffer.writableBytes());
            this.buffer.write(byArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    public void flush() {
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.commitToSink(false, true);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.closed = true;
            if (this.buffer != null && this.buffer.readableBytes() == 0) {
                this.releaseBuffer();
            }
            this.commitToSink(true, true);
        }
    }

    @Override
    public void dispose() {
        this.closed = true;
        this.releaseBuffer();
    }

    private void releaseBuffer() {
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    private void commitToSink(boolean bl, boolean bl2) {
        WritableBuffer writableBuffer = this.buffer;
        this.buffer = null;
        this.sink.deliverFrame(writableBuffer, bl, bl2);
    }

    private void verifyNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Framer already closed");
        }
    }

    final class BufferChainOutputStream
    extends OutputStream {
        private final List<WritableBuffer> bufferList = new ArrayList<WritableBuffer>();
        private WritableBuffer current;

        private BufferChainOutputStream() {
        }

        @Override
        public final void write(int n) throws IOException {
            if (this.current != null && this.current.writableBytes() > 0) {
                this.current.write((byte)n);
                return;
            }
            byte[] byArray = new byte[]{(byte)n};
            this.write(byArray, 0, 1);
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) {
            if (this.current == null) {
                this.current = MessageFramer.this.bufferAllocator.allocate(n2);
                this.bufferList.add(this.current);
            }
            while (n2 > 0) {
                int n3 = Math.min(n2, this.current.writableBytes());
                if (n3 == 0) {
                    int n4 = Math.max(n2, this.current.readableBytes() << 1);
                    this.current = MessageFramer.this.bufferAllocator.allocate(n4);
                    this.bufferList.add(this.current);
                    continue;
                }
                this.current.write(byArray, n, n3);
                n += n3;
                n2 -= n3;
            }
        }

        private final int readableBytes() {
            int n = 0;
            for (WritableBuffer writableBuffer : this.bufferList) {
                n += writableBuffer.readableBytes();
            }
            return n;
        }
    }

    class OutputStreamAdapter
    extends OutputStream {
        private OutputStreamAdapter() {
        }

        @Override
        public void write(int n) {
            byte[] byArray = new byte[]{(byte)n};
            this.write(byArray, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            MessageFramer.this.writeRaw(byArray, n, n2);
        }
    }

    public static interface Sink {
        public void deliverFrame(WritableBuffer var1, boolean var2, boolean var3);
    }
}

