/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.DelayedStream;
import io.grpc.internal.FailingClientStream;
import io.grpc.zzbe;
import io.grpc.zzbp;
import io.grpc.zzcq;
import io.grpc.zzg;
import io.grpc.zzh;
import io.grpc.zzy;

final class MetadataApplierImpl
implements zzg {
    private final ClientTransport transport;
    private final zzbp<?, ?> method;
    private final zzbe origHeaders;
    private final zzh callOptions;
    private final zzy ctx;
    private final Object lock = new Object();
    private ClientStream returnedStream;
    boolean finalized;
    DelayedStream delayedStream;

    MetadataApplierImpl(ClientTransport clientTransport, zzbp<?, ?> zzbp2, zzbe zzbe2, zzh zzh2) {
        this.transport = clientTransport;
        this.method = zzbp2;
        this.origHeaders = zzbe2;
        this.callOptions = zzh2;
        this.ctx = zzy.zzcxm();
    }

    @Override
    public final void apply(zzbe zzbe2) {
        ClientStream clientStream;
        Preconditions.checkState((!this.finalized ? 1 : 0) != 0, (Object)"apply() or fail() already called");
        Preconditions.checkNotNull((Object)zzbe2, (Object)"headers");
        this.origHeaders.zzc(zzbe2);
        zzy zzy2 = this.ctx.zzcxp();
        try {
            clientStream = this.transport.newStream(this.method, this.origHeaders, this.callOptions);
        }
        finally {
            this.ctx.zza(zzy2);
        }
        this.finalizeWith(clientStream);
    }

    @Override
    public final void fail(zzcq zzcq2) {
        Preconditions.checkArgument((!zzcq2.zzcyt() ? 1 : 0) != 0, (Object)"Cannot fail with OK status");
        Preconditions.checkState((!this.finalized ? 1 : 0) != 0, (Object)"apply() or fail() already called");
        this.finalizeWith(new FailingClientStream(zzcq2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finalizeWith(ClientStream clientStream) {
        Preconditions.checkState((!this.finalized ? 1 : 0) != 0, (Object)"already finalized");
        this.finalized = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.returnedStream = clientStream;
                return;
            }
        }
        Preconditions.checkState((this.delayedStream != null ? 1 : 0) != 0, (Object)"delayedStream is null");
        this.delayedStream.setStream(clientStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ClientStream returnStream() {
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.delayedStream = new DelayedStream();
                this.returnedStream = this.delayedStream;
                return this.returnedStream;
            }
            return this.returnedStream;
        }
    }
}

