/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.ChannelExecutor;
import io.grpc.internal.ClientCallImpl;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.DelayedClientTransport;
import io.grpc.internal.InternalSubchannel;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SubchannelImpl;
import io.grpc.internal.WithLogId;
import io.grpc.zza;
import io.grpc.zzak;
import io.grpc.zzax;
import io.grpc.zzay;
import io.grpc.zzba;
import io.grpc.zzbb;
import io.grpc.zzbp;
import io.grpc.zzcq;
import io.grpc.zzh;
import io.grpc.zzj;
import io.grpc.zzx;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class OobChannel
extends zzbb
implements WithLogId {
    private static final Logger log = Logger.getLogger(OobChannel.class.getName());
    private InternalSubchannel subchannel;
    private SubchannelImpl subchannelImpl;
    private zzba subchannelPicker;
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final String authority;
    private final DelayedClientTransport delayedTransport;
    private final ObjectPool<? extends Executor> executorPool;
    private final Executor executor;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final CountDownLatch terminatedLatch = new CountDownLatch(1);
    private volatile boolean shutdown;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get(zzay zzay2) {
            return OobChannel.this.delayedTransport;
        }
    };

    OobChannel(String string, ObjectPool<? extends Executor> objectPool, ScheduledExecutorService scheduledExecutorService, ChannelExecutor channelExecutor) {
        this.authority = (String)Preconditions.checkNotNull((Object)string, (Object)"authority");
        this.executorPool = (ObjectPool)Preconditions.checkNotNull(objectPool, (Object)"executorPool");
        this.executor = (Executor)Preconditions.checkNotNull((Object)objectPool.getObject(), (Object)"executor");
        this.deadlineCancellationExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"deadlineCancellationExecutor");
        this.delayedTransport = new DelayedClientTransport(this.executor, channelExecutor);
        this.delayedTransport.start(new ManagedClientTransport.Listener(){

            @Override
            public void transportShutdown(zzcq zzcq2) {
            }

            @Override
            public void transportTerminated() {
                OobChannel.this.subchannelImpl.shutdown();
            }

            @Override
            public void transportReady() {
            }

            @Override
            public void transportInUse(boolean bl) {
            }
        });
    }

    final void setSubchannel(final InternalSubchannel internalSubchannel) {
        log.logp(Level.FINE, "io.grpc.internal.OobChannel", "setSubchannel", "[{0}] Created with [{1}]", new Object[]{this, internalSubchannel});
        this.subchannel = internalSubchannel;
        this.subchannelImpl = new SubchannelImpl(this){

            @Override
            public void shutdown() {
                internalSubchannel.shutdown();
            }

            @Override
            ClientTransport obtainActiveTransport() {
                return internalSubchannel.obtainActiveTransport();
            }

            @Override
            public void requestConnection() {
                internalSubchannel.obtainActiveTransport();
            }

            @Override
            public zzak getAddresses() {
                return internalSubchannel.getAddressGroup();
            }

            @Override
            public zza getAttributes() {
                return zza.zzoyf;
            }
        };
        this.subchannelPicker = new zzba(){
            final zzax result;
            {
                this.result = zzax.zza(OobChannel.this.subchannelImpl);
            }

            @Override
            public zzax pickSubchannel(zzay zzay2) {
                return this.result;
            }
        };
        this.delayedTransport.reprocess(this.subchannelPicker);
    }

    final void updateAddresses(zzak zzak2) {
        this.subchannel.updateAddresses(zzak2);
    }

    @Override
    public final <RequestT, ResponseT> zzj<RequestT, ResponseT> newCall(zzbp<RequestT, ResponseT> zzbp2, zzh zzh2) {
        return new ClientCallImpl<RequestT, ResponseT>(zzbp2, zzh2.zzcfp() == null ? this.executor : zzh2.zzcfp(), zzh2, this.transportProvider, this.deadlineCancellationExecutor);
    }

    @Override
    public final String authority() {
        return this.authority;
    }

    @Override
    public final LogId getLogId() {
        return this.logId;
    }

    @Override
    public final boolean isTerminated() {
        return this.terminatedLatch.getCount() == 0L;
    }

    @Override
    public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.terminatedLatch.await(l, timeUnit);
    }

    @Override
    public final zzbb shutdown() {
        this.shutdown = true;
        this.delayedTransport.shutdown();
        return this;
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public final zzbb shutdownNow() {
        this.shutdown = true;
        this.delayedTransport.shutdownNow(zzcq.zzpcj.zztw("OobChannel.shutdownNow() called"));
        return this;
    }

    final void handleSubchannelStateChange(final zzx zzx2) {
        switch (zzx2.getState()) {
            case zzoyx: 
            case zzoyz: {
                this.delayedTransport.reprocess(this.subchannelPicker);
                return;
            }
            case zzoyy: {
                this.delayedTransport.reprocess(new zzba(this){
                    final zzax errorResult;
                    {
                        this.errorResult = zzax.zzi(zzx2.zzcxk());
                    }

                    @Override
                    public zzax pickSubchannel(zzay zzay2) {
                        return this.errorResult;
                    }
                });
            }
        }
    }

    final void handleSubchannelTerminated() {
        this.executorPool.returnObject(this.executor);
        this.terminatedLatch.countDown();
    }
}

