/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.grpc.internal.AbstractReadableBuffer;
import io.grpc.internal.ForwardingReadableBuffer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.zzat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class ReadableBuffers {
    private static final ReadableBuffer EMPTY_BUFFER = new ByteArrayWrapper(new byte[0]);

    public static ReadableBuffer empty() {
        return EMPTY_BUFFER;
    }

    public static ReadableBuffer wrap(byte[] byArray) {
        return new ByteArrayWrapper(byArray, 0, byArray.length);
    }

    public static ReadableBuffer wrap(byte[] byArray, int n, int n2) {
        return new ByteArrayWrapper(byArray, n, n2);
    }

    public static ReadableBuffer wrap(ByteBuffer byteBuffer) {
        return new ByteReadableBufferWrapper(byteBuffer);
    }

    public static byte[] readArray(ReadableBuffer readableBuffer) {
        Preconditions.checkNotNull((Object)readableBuffer, (Object)"buffer");
        int n = readableBuffer.readableBytes();
        byte[] byArray = new byte[n];
        readableBuffer.readBytes(byArray, 0, n);
        return byArray;
    }

    public static String readAsString(ReadableBuffer readableBuffer, Charset charset) {
        Preconditions.checkNotNull((Object)charset, (Object)"charset");
        byte[] byArray = ReadableBuffers.readArray(readableBuffer);
        return new String(byArray, charset);
    }

    public static String readAsStringUtf8(ReadableBuffer readableBuffer) {
        return ReadableBuffers.readAsString(readableBuffer, Charsets.UTF_8);
    }

    public static InputStream openStream(ReadableBuffer readableBuffer, boolean bl) {
        return new BufferInputStream(bl ? readableBuffer : ReadableBuffers.ignoreClose(readableBuffer));
    }

    public static ReadableBuffer ignoreClose(ReadableBuffer readableBuffer) {
        return new ForwardingReadableBuffer(readableBuffer){

            @Override
            public void close() {
            }
        };
    }

    private ReadableBuffers() {
    }

    static final class BufferInputStream
    extends InputStream
    implements zzat {
        final ReadableBuffer buffer;

        public BufferInputStream(ReadableBuffer readableBuffer) {
            this.buffer = (ReadableBuffer)Preconditions.checkNotNull((Object)readableBuffer, (Object)"buffer");
        }

        @Override
        public final int available() throws IOException {
            return this.buffer.readableBytes();
        }

        @Override
        public final int read() {
            if (this.buffer.readableBytes() == 0) {
                return -1;
            }
            return this.buffer.readUnsignedByte();
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.buffer.readableBytes() == 0) {
                return -1;
            }
            n2 = Math.min(this.buffer.readableBytes(), n2);
            this.buffer.readBytes(byArray, n, n2);
            return n2;
        }
    }

    static class ByteReadableBufferWrapper
    extends AbstractReadableBuffer {
        final ByteBuffer bytes;

        ByteReadableBufferWrapper(ByteBuffer byteBuffer) {
            this.bytes = (ByteBuffer)Preconditions.checkNotNull((Object)byteBuffer, (Object)"bytes");
        }

        @Override
        public int readableBytes() {
            return this.bytes.remaining();
        }

        @Override
        public int readUnsignedByte() {
            this.checkReadable(1);
            return this.bytes.get() & 0xFF;
        }

        @Override
        public void skipBytes(int n) {
            this.checkReadable(n);
            this.bytes.position(this.bytes.position() + n);
        }

        @Override
        public void readBytes(byte[] byArray, int n, int n2) {
            this.checkReadable(n2);
            this.bytes.get(byArray, n, n2);
        }

        @Override
        public void readBytes(ByteBuffer byteBuffer) {
            Preconditions.checkNotNull((Object)byteBuffer, (Object)"dest");
            int n = byteBuffer.remaining();
            this.checkReadable(n);
            int n2 = this.bytes.limit();
            this.bytes.limit(this.bytes.position() + n);
            byteBuffer.put(this.bytes);
            this.bytes.limit(n2);
        }

        @Override
        public void readBytes(OutputStream outputStream, int n) throws IOException {
            this.checkReadable(n);
            if (((AbstractReadableBuffer)this).hasArray()) {
                outputStream.write(((AbstractReadableBuffer)this).array(), ((AbstractReadableBuffer)this).arrayOffset(), n);
                this.bytes.position(this.bytes.position() + n);
                return;
            }
            byte[] byArray = new byte[n];
            this.bytes.get(byArray);
            outputStream.write(byArray);
        }

        @Override
        public ByteReadableBufferWrapper readBytes(int n) {
            this.checkReadable(n);
            ByteBuffer byteBuffer = this.bytes.duplicate();
            byteBuffer.limit(this.bytes.position() + n);
            this.bytes.position(this.bytes.position() + n);
            return new ByteReadableBufferWrapper(byteBuffer);
        }

        @Override
        public boolean hasArray() {
            return this.bytes.hasArray();
        }

        @Override
        public byte[] array() {
            return this.bytes.array();
        }

        @Override
        public int arrayOffset() {
            return this.bytes.arrayOffset() + this.bytes.position();
        }
    }

    static class ByteArrayWrapper
    extends AbstractReadableBuffer {
        int offset;
        final int end;
        final byte[] bytes;

        ByteArrayWrapper(byte[] byArray) {
            this(byArray, 0, byArray.length);
        }

        ByteArrayWrapper(byte[] byArray, int n, int n2) {
            Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"offset must be >= 0");
            Preconditions.checkArgument((n2 >= 0 ? 1 : 0) != 0, (Object)"length must be >= 0");
            Preconditions.checkArgument((n + n2 <= byArray.length ? 1 : 0) != 0, (Object)"offset + length exceeds array boundary");
            this.bytes = (byte[])Preconditions.checkNotNull((Object)byArray, (Object)"bytes");
            this.offset = n;
            this.end = n + n2;
        }

        @Override
        public int readableBytes() {
            return this.end - this.offset;
        }

        @Override
        public void skipBytes(int n) {
            this.checkReadable(n);
            this.offset += n;
        }

        @Override
        public int readUnsignedByte() {
            this.checkReadable(1);
            return this.bytes[this.offset++] & 0xFF;
        }

        @Override
        public void readBytes(byte[] byArray, int n, int n2) {
            System.arraycopy(this.bytes, this.offset, byArray, n, n2);
            this.offset += n2;
        }

        @Override
        public void readBytes(ByteBuffer byteBuffer) {
            Preconditions.checkNotNull((Object)byteBuffer, (Object)"dest");
            int n = byteBuffer.remaining();
            this.checkReadable(n);
            byteBuffer.put(this.bytes, this.offset, n);
            this.offset += n;
        }

        @Override
        public void readBytes(OutputStream outputStream, int n) throws IOException {
            this.checkReadable(n);
            outputStream.write(this.bytes, this.offset, n);
            this.offset += n;
        }

        @Override
        public ByteArrayWrapper readBytes(int n) {
            this.checkReadable(n);
            int n2 = this.offset;
            this.offset += n;
            return new ByteArrayWrapper(this.bytes, n2, n);
        }

        @Override
        public boolean hasArray() {
            return true;
        }

        @Override
        public byte[] array() {
            return this.bytes;
        }

        @Override
        public int arrayOffset() {
            return this.offset;
        }
    }
}

