/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

class SerializeReentrantCallsDirectExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(SerializeReentrantCallsDirectExecutor.class.getName());
    private boolean executing;
    private ArrayDeque<Runnable> taskQueue;

    SerializeReentrantCallsDirectExecutor() {
    }

    @Override
    public void execute(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable, (Object)"'task' must not be null.");
        if (!this.executing) {
            this.executing = true;
            try {
                runnable.run();
                return;
            }
            catch (Throwable throwable) {
                String string = String.valueOf(runnable);
                log.logp(Level.SEVERE, "io.grpc.internal.SerializeReentrantCallsDirectExecutor", "execute", new StringBuilder(35 + String.valueOf(string).length()).append("Exception while executing runnable ").append(string).toString(), throwable);
                return;
            }
            finally {
                if (this.taskQueue != null) {
                    this.completeQueuedTasks();
                }
                this.executing = false;
            }
        }
        this.enqueue(runnable);
    }

    private void completeQueuedTasks() {
        Runnable runnable;
        while ((runnable = this.taskQueue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                String string = String.valueOf(runnable);
                log.logp(Level.SEVERE, "io.grpc.internal.SerializeReentrantCallsDirectExecutor", "completeQueuedTasks", new StringBuilder(35 + String.valueOf(string).length()).append("Exception while executing runnable ").append(string).toString(), throwable);
            }
        }
    }

    private void enqueue(Runnable runnable) {
        if (this.taskQueue == null) {
            this.taskQueue = new ArrayDeque(4);
        }
        this.taskQueue.add(runnable);
    }
}

