/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SerializingExecutor
implements Runnable,
Executor {
    private static final Logger log = Logger.getLogger(SerializingExecutor.class.getName());
    private final Executor executor;
    private final Queue<Runnable> runQueue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicBoolean running = new AtomicBoolean();

    public SerializingExecutor(Executor executor) {
        Preconditions.checkNotNull((Object)executor, (Object)"'executor' must not be null.");
        this.executor = executor;
    }

    @Override
    public final void execute(Runnable runnable) {
        this.runQueue.add((Runnable)Preconditions.checkNotNull((Object)runnable, (Object)"'r' must not be null."));
        this.schedule(runnable);
    }

    private final void schedule(Runnable runnable) {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.executor.execute(this);
                return;
            }
            catch (Throwable throwable) {
                if (runnable != null) {
                    this.runQueue.remove(runnable);
                }
                this.running.set(false);
                throw throwable;
            }
        }
    }

    @Override
    public final void run() {
        try {
            Runnable runnable;
            while ((runnable = this.runQueue.poll()) != null) {
                try {
                    runnable.run();
                }
                catch (RuntimeException runtimeException) {
                    String string = String.valueOf(runnable);
                    log.logp(Level.SEVERE, "io.grpc.internal.SerializingExecutor", "run", new StringBuilder(35 + String.valueOf(string).length()).append("Exception while executing runnable ").append(string).toString(), runtimeException);
                }
            }
        }
        finally {
            this.running.set(false);
        }
        if (!this.runQueue.isEmpty()) {
            this.schedule(null);
        }
    }
}

