/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdgi;
import com.google.common.base.Preconditions;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.MoreThrowables;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.zza;
import io.grpc.zzah;
import io.grpc.zzaq;
import io.grpc.zzbe;
import io.grpc.zzbp;
import io.grpc.zzcj;
import io.grpc.zzck;
import io.grpc.zzcq;
import io.grpc.zzt;
import io.grpc.zzu;
import io.grpc.zzv;
import io.grpc.zzy;
import java.io.IOException;
import java.io.InputStream;

final class ServerCallImpl<ReqT, RespT>
extends zzcj<ReqT, RespT> {
    static String TOO_MANY_RESPONSES = "Too many responses";
    static String MISSING_RESPONSE = "Completed without a response";
    private final ServerStream stream;
    private final zzbp<ReqT, RespT> method;
    private final zzy.zza context;
    private final byte[] messageAcceptEncoding;
    private final zzah decompressorRegistry;
    private final zzv compressorRegistry;
    private volatile boolean cancelled;
    private boolean sendHeadersCalled;
    private boolean closeCalled;
    private zzu compressor;
    private boolean messageSent;

    ServerCallImpl(ServerStream serverStream, zzbp<ReqT, RespT> zzbp2, zzbe zzbe2, zzy.zza zza2, zzah zzah2, zzv zzv2) {
        this.stream = serverStream;
        this.method = zzbp2;
        this.context = zza2;
        this.messageAcceptEncoding = zzbe2.zzb(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        this.decompressorRegistry = zzah2;
        this.compressorRegistry = zzv2;
    }

    @Override
    public final void request(int n) {
        this.stream.request(n);
    }

    @Override
    public final void sendHeaders(zzbe zzbe2) {
        Preconditions.checkState((!this.sendHeadersCalled ? 1 : 0) != 0, (Object)"sendHeaders has already been called");
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
        zzbe2.zzc(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (this.compressor != null && this.messageAcceptEncoding != null) {
            if (!GrpcUtil.ACCEPT_ENCODING_SPLITTER.splitToList((CharSequence)new String(this.messageAcceptEncoding, GrpcUtil.US_ASCII)).contains(this.compressor.zzcxi())) {
                this.compressor = zzt.zzoyt;
            }
        } else {
            this.compressor = zzt.zzoyt;
        }
        zzbe2.zza(GrpcUtil.MESSAGE_ENCODING_KEY, this.compressor.zzcxi());
        this.stream.setCompressor(this.compressor);
        zzbe2.zzc(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        byte[] byArray = zzaq.zza(this.decompressorRegistry);
        if (byArray.length != 0) {
            zzbe2.zza(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, byArray);
        }
        this.sendHeadersCalled = true;
        this.stream.writeHeaders(zzbe2);
    }

    @Override
    public final void sendMessage(RespT RespT) {
        Preconditions.checkState((boolean)this.sendHeadersCalled, (Object)"sendHeaders has not been called");
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
        if (this.method.zzcyh().zzcyl() && this.messageSent) {
            this.internalClose(zzcq.zzpci.zztw(TOO_MANY_RESPONSES));
            return;
        }
        this.messageSent = true;
        try {
            InputStream inputStream = this.method.zzci(RespT);
            this.stream.writeMessage(inputStream);
            this.stream.flush();
            return;
        }
        catch (RuntimeException runtimeException) {
            ((zzcj)this).close(zzcq.zzk(runtimeException), new zzbe());
            throw runtimeException;
        }
        catch (Throwable throwable) {
            ((zzcj)this).close(zzcq.zzk(throwable), new zzbe());
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public final void setMessageCompression(boolean bl) {
        this.stream.setMessageCompression(bl);
    }

    @Override
    public final void setCompression(String string) {
        Preconditions.checkState((!this.sendHeadersCalled ? 1 : 0) != 0, (Object)"sendHeaders has been called");
        this.compressor = this.compressorRegistry.zztq(string);
        Preconditions.checkArgument((this.compressor != null ? 1 : 0) != 0, (String)"Unable to find compressor by name %s", (Object)string);
    }

    @Override
    public final boolean isReady() {
        return this.stream.isReady();
    }

    @Override
    public final void close(zzcq zzcq2, zzbe zzbe2) {
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call already closed");
        this.closeCalled = true;
        if (zzcq2.zzcyt() && this.method.zzcyh().zzcyl() && !this.messageSent) {
            this.internalClose(zzcq.zzpci.zztw(MISSING_RESPONSE));
            return;
        }
        this.stream.close(zzcq2, zzbe2);
    }

    @Override
    public final boolean isCancelled() {
        return this.cancelled;
    }

    final ServerStreamListener newServerStreamListener(zzck<ReqT> zzck2) {
        return new ServerStreamListenerImpl<ReqT>(this, zzck2, this.context);
    }

    @Override
    public final zza getAttributes() {
        return this.stream.getAttributes();
    }

    @Override
    public final String getAuthority() {
        return this.stream.getAuthority();
    }

    @Override
    public final zzbp<ReqT, RespT> getMethodDescriptor() {
        return this.method;
    }

    private final void internalClose(zzcq zzcq2) {
        this.stream.close(zzcq2, new zzbe());
    }

    static final class ServerStreamListenerImpl<ReqT>
    implements ServerStreamListener {
        private final ServerCallImpl<ReqT, ?> call;
        private final zzck<ReqT> listener;
        private final zzy.zza context;

        public ServerStreamListenerImpl(ServerCallImpl<ReqT, ?> serverCallImpl, zzck<ReqT> zzck2, zzy.zza zza2) {
            this.call = (ServerCallImpl)Preconditions.checkNotNull(serverCallImpl, (Object)"call");
            this.listener = (zzck)Preconditions.checkNotNull(zzck2, (Object)"listener must not be null");
            this.context = (zzy.zza)Preconditions.checkNotNull((Object)zza2, (Object)"context");
            this.context.zza(new zzy.zzb(){

                @Override
                public void cancelled(zzy zzy2) {
                    ServerStreamListenerImpl.this.call.cancelled = true;
                }
            }, zzdgi.zzbjt());
        }

        /*
         * Loose catch block
         */
        @Override
        public final void messageRead(InputStream inputStream) {
            block20: {
                if (!((ServerCallImpl)this.call).cancelled) break block20;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            ((ServerCallImpl)this.call).method.zzo(inputStream);
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    try {
                        throw new RuntimeException(iOException);
                    }
                    catch (Throwable throwable2) {
                        MoreThrowables.throwIfUnchecked(throwable);
                        throw new RuntimeException(throwable);
                    }
                }
                MoreThrowables.throwIfUnchecked(throwable);
                throw new RuntimeException(throwable);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                throw throwable;
            }
        }

        @Override
        public final void halfClosed() {
            if (((ServerCallImpl)this.call).cancelled) {
                return;
            }
        }

        @Override
        public final void closed(zzcq zzcq2) {
            try {
                if (!zzcq2.zzcyt()) {
                    ((ServerCallImpl)this.call).cancelled = true;
                }
                return;
            }
            finally {
                this.context.zzj(null);
            }
        }

        @Override
        public final void onReady() {
            if (((ServerCallImpl)this.call).cancelled) {
                return;
            }
        }
    }
}

