/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.LogExceptionRunnable;
import java.util.IdentityHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class SharedResourceHolder {
    static final long DESTROY_DELAY_SECONDS = 1L;
    private static final SharedResourceHolder holder = new SharedResourceHolder(new ScheduledExecutorFactory(){

        @Override
        public ScheduledExecutorService createScheduledExecutor() {
            return Executors.newSingleThreadScheduledExecutor(GrpcUtil.getThreadFactory("grpc-shared-destroyer-%d", true));
        }
    });
    private final IdentityHashMap<Resource<?>, Instance> instances = new IdentityHashMap();
    private final ScheduledExecutorFactory destroyerFactory;
    private ScheduledExecutorService destroyer;

    SharedResourceHolder(ScheduledExecutorFactory scheduledExecutorFactory) {
        this.destroyerFactory = scheduledExecutorFactory;
    }

    public static <T> T get(Resource<T> resource) {
        return holder.getInternal(resource);
    }

    public static <T> T release(Resource<T> resource, T t) {
        return holder.releaseInternal(resource, t);
    }

    final synchronized <T> T getInternal(Resource<T> resource) {
        Instance instance = this.instances.get(resource);
        if (instance == null) {
            instance = new Instance(resource.create());
            this.instances.put(resource, instance);
        }
        if (instance.destroyTask != null) {
            instance.destroyTask.cancel(false);
            instance.destroyTask = null;
        }
        ++instance.refcount;
        return (T)instance.payload;
    }

    final synchronized <T> T releaseInternal(final Resource<T> resource, final T t) {
        final Instance instance = this.instances.get(resource);
        if (instance == null) {
            String string = String.valueOf(resource);
            throw new IllegalArgumentException(new StringBuilder(29 + String.valueOf(string).length()).append("No cached instance found for ").append(string).toString());
        }
        Preconditions.checkArgument((t == instance.payload ? 1 : 0) != 0, (Object)"Releasing the wrong instance");
        Preconditions.checkState((instance.refcount > 0 ? 1 : 0) != 0, (Object)"Refcount has already reached zero");
        --instance.refcount;
        if (instance.refcount == 0) {
            if (GrpcUtil.IS_RESTRICTED_APPENGINE) {
                resource.close(t);
                this.instances.remove(resource);
            } else {
                Preconditions.checkState((instance.destroyTask == null ? 1 : 0) != 0, (Object)"Destroy task already scheduled");
                if (this.destroyer == null) {
                    this.destroyer = this.destroyerFactory.createScheduledExecutor();
                }
                instance.destroyTask = this.destroyer.schedule(new LogExceptionRunnable(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        SharedResourceHolder sharedResourceHolder = SharedResourceHolder.this;
                        synchronized (sharedResourceHolder) {
                            if (instance.refcount == 0) {
                                resource.close(t);
                                SharedResourceHolder.this.instances.remove(resource);
                                if (SharedResourceHolder.this.instances.isEmpty()) {
                                    SharedResourceHolder.this.destroyer.shutdown();
                                    SharedResourceHolder.this.destroyer = null;
                                }
                            }
                            return;
                        }
                    }
                }), 1L, TimeUnit.SECONDS);
            }
        }
        return null;
    }

    static class Instance {
        final Object payload;
        int refcount;
        ScheduledFuture<?> destroyTask;

        Instance(Object object) {
            this.payload = object;
        }
    }

    static interface ScheduledExecutorFactory {
        public ScheduledExecutorService createScheduledExecutor();
    }

    public static interface Resource<T> {
        public T create();

        public void close(T var1);
    }
}

