/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.android.gms.internal.zzdgk;
import com.google.android.gms.internal.zzezr;
import com.google.android.gms.internal.zzfab;
import com.google.android.gms.internal.zzfac;
import com.google.android.gms.internal.zzfad;
import com.google.android.gms.internal.zzfaf;
import com.google.android.gms.internal.zzfaq;
import com.google.android.gms.internal.zzfba;
import com.google.android.gms.internal.zzfbb;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbd;
import com.google.android.gms.internal.zzfbg;
import com.google.android.gms.internal.zzfbq;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.internal.http.StatusLine;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.Http2Ping;
import io.grpc.internal.KeepAliveManager;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.StatsTraceContext;
import io.grpc.okhttp.zzag;
import io.grpc.okhttp.zzu;
import io.grpc.okhttp.zzz;
import io.grpc.zzbe;
import io.grpc.zzbp;
import io.grpc.zzbt;
import io.grpc.zzcq;
import io.grpc.zzcs;
import io.grpc.zzcv;
import io.grpc.zzh;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;

class zzy
implements ConnectionClientTransport {
    private static final Map<zzfab, zzcq> zzpfg;
    private static final Logger log;
    private static final zzu[] zzpfh;
    private final InetSocketAddress zzpfi;
    private final String zzpfj;
    private final String userAgent;
    private final Random random = new Random();
    private final Ticker zzpfk;
    private ManagedClientTransport.Listener zzpfl;
    private io.grpc.okhttp.zza zzpfe;
    private zzag zzpff;
    private final Object lock = new Object();
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private int nextStreamId;
    private final Map<Integer, zzu> streams = new HashMap<Integer, zzu>();
    private final Executor executor;
    private final SerializingExecutor zzpfm;
    private final int maxMessageSize;
    private int zzpfn;
    private zza zzpfo;
    private zzcq zzpfp;
    private boolean zzpfq;
    private Http2Ping zzpfr;
    private boolean zzlyj;
    private boolean zzpfs;
    private SSLSocketFactory sslSocketFactory;
    private Socket socket;
    private int zzpft = 0;
    private LinkedList<zzu> zzpfu = new LinkedList();
    private final zzezr zzpfv;
    private ScheduledExecutorService scheduler;
    private KeepAliveManager zzpfw;
    private boolean zzpep;
    private long zzpek;
    private long zzpel;
    private boolean zzper;
    private final InetSocketAddress zzpfx;
    private final String zzpfy;
    private final String zzpfz;
    private final Runnable zzpga;
    Runnable zzpgb;
    zzdgk<Void> zzpgc;

    zzy(InetSocketAddress inetSocketAddress, String string, String string2, Executor executor, SSLSocketFactory sSLSocketFactory, zzezr zzezr2, int n, InetSocketAddress inetSocketAddress2, String string3, String string4, Runnable runnable) {
        this.zzpfi = (InetSocketAddress)Preconditions.checkNotNull((Object)inetSocketAddress, (Object)"address");
        this.zzpfj = string;
        this.maxMessageSize = n;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.zzpfm = new SerializingExecutor(executor);
        this.nextStreamId = 3;
        this.sslSocketFactory = sSLSocketFactory;
        this.zzpfv = (zzezr)Preconditions.checkNotNull((Object)zzezr2, (Object)"connectionSpec");
        this.zzpfk = Ticker.systemTicker();
        this.userAgent = GrpcUtil.getGrpcUserAgent("okhttp", string2);
        this.zzpfx = inetSocketAddress2;
        this.zzpfy = null;
        this.zzpfz = null;
        this.zzpga = (Runnable)Preconditions.checkNotNull((Object)runnable, (Object)"tooManyPingsRunnable");
    }

    final void zza(boolean bl, long l, long l2, boolean bl2) {
        this.zzpep = true;
        this.zzpek = l;
        this.zzpel = l2;
        this.zzper = bl2;
    }

    private final boolean zzczg() {
        return this.zzpfi == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ping(ClientTransport.PingCallback pingCallback, Executor executor) {
        boolean bl;
        Http2Ping http2Ping;
        Preconditions.checkState((this.zzpfe != null ? 1 : 0) != 0);
        long l = 0L;
        Object object = this.lock;
        synchronized (object) {
            if (this.zzlyj) {
                Http2Ping.notifyFailed(pingCallback, executor, this.zzczo());
                return;
            }
            if (this.zzpfr != null) {
                http2Ping = this.zzpfr;
                bl = false;
            } else {
                l = this.random.nextLong();
                http2Ping = this.zzpfr = new Http2Ping(l, Stopwatch.createStarted((Ticker)this.zzpfk));
                bl = true;
            }
        }
        if (bl) {
            this.zzpfe.ping(false, (int)(l >>> 32), (int)l);
        }
        http2Ping.addCallback(pingCallback, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzh(zzu zzu2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzpfp != null) {
                zzu2.zzczb().transportReportStatus(this.zzpfp, true, new zzbe());
            } else if (this.streams.size() >= this.zzpft) {
                this.zzpfu.add(zzu2);
                this.zzczn();
            } else {
                this.zzi(zzu2);
            }
            return;
        }
    }

    private final void zzi(zzu zzu2) {
        Preconditions.checkState((zzu2.zzczc() == -1 ? 1 : 0) != 0, (Object)"StreamId already assigned");
        this.streams.put(this.nextStreamId, zzu2);
        this.zzczn();
        zzu2.zzczb().zzll(this.nextStreamId);
        if (zzu2.zzcyh() != zzbt.zzpbg && zzu2.zzcyh() != zzbt.zzpbi) {
            this.zzpfe.flush();
        }
        if (this.nextStreamId >= 0x7FFFFFFD) {
            this.nextStreamId = Integer.MAX_VALUE;
            this.zza(Integer.MAX_VALUE, zzfab.zzpml, zzcq.zzpcj.zztw("Stream ids exhausted"));
            return;
        }
        this.nextStreamId += 2;
    }

    private final boolean zzczh() {
        boolean bl = false;
        while (!this.zzpfu.isEmpty() && this.streams.size() < this.zzpft) {
            zzu zzu2 = this.zzpfu.poll();
            this.zzi(zzu2);
            bl = true;
        }
        return bl;
    }

    final void zzj(zzu zzu2) {
        this.zzpfu.remove(zzu2);
        this.zzczm();
    }

    @Override
    public Runnable start(ManagedClientTransport.Listener listener) {
        this.zzpfl = (ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        if (this.zzpep) {
            this.scheduler = SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE);
            this.zzpfw = new KeepAliveManager(new KeepAliveManager.ClientKeepAlivePinger(this), this.scheduler, this.zzpek, this.zzpel, this.zzper);
            this.zzpfw.onTransportStarted();
        }
        this.zzpfe = new io.grpc.okhttp.zza(this, this.zzpfm);
        this.zzpff = new zzag(this, this.zzpfe);
        this.zzpfm.execute(new zzz(this));
        return null;
    }

    private final Socket zza(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, String string2) throws IOException, zzcv {
        try {
            Socket socket = new Socket(inetSocketAddress2.getAddress(), inetSocketAddress2.getPort());
            socket.setTcpNoDelay(true);
            zzfbq zzfbq2 = zzfbg.zzb(socket);
            zzfbb zzfbb2 = zzfbg.zza(zzfbg.zza(socket));
            String string3 = string2;
            String string4 = string;
            InetSocketAddress inetSocketAddress3 = inetSocketAddress;
            zzy zzy2 = this;
            HttpUrl httpUrl = new HttpUrl.Builder().scheme("https").host(inetSocketAddress3.getHostName()).port(inetSocketAddress3.getPort()).build();
            String string5 = httpUrl.host();
            int n = httpUrl.port();
            Request.Builder builder = new Request.Builder().url(httpUrl).header("Host", new StringBuilder(12 + String.valueOf(string5).length()).append(string5).append(":").append(n).toString()).header("User-Agent", zzy2.userAgent);
            if (string4 != null && string3 != null) {
                builder.header("Proxy-Authorization", Credentials.basic((String)string4, (String)string3));
            }
            Request request = builder.build();
            HttpUrl httpUrl2 = request.httpUrl();
            String string6 = String.format("CONNECT %s:%d HTTP/1.1", httpUrl2.host(), httpUrl2.port());
            zzfbb2.zzud(string6).zzud("\r\n");
            int n2 = request.headers().size();
            for (int i = 0; i < n2; ++i) {
                zzfbb2.zzud(request.headers().name(i)).zzud(": ").zzud(request.headers().value(i)).zzud("\r\n");
            }
            zzfbb2.zzud("\r\n");
            zzfbb2.flush();
            StatusLine statusLine = StatusLine.parse((String)zzy.zza(zzfbq2));
            while (!zzy.zza(zzfbq2).equals("")) {
            }
            if (statusLine.code < 200 || statusLine.code >= 300) {
                zzfba zzfba2 = new zzfba();
                try {
                    socket.shutdownOutput();
                    zzfbq2.read(zzfba2, 1024L);
                }
                catch (IOException iOException) {
                    String string7 = String.valueOf(iOException.toString());
                    zzfba2.zzud(string7.length() != 0 ? "Unable to read body: ".concat(string7) : new String("Unable to read body: "));
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                String string8 = String.format("Response returned from proxy was not successful (expected 2xx, got %d %s). Response body:\n%s", statusLine.code, statusLine.message, zzfba2.zzdaz());
                throw zzcq.zzpcj.zztw(string8).zzcyv();
            }
            return socket;
        }
        catch (IOException iOException) {
            throw zzcq.zzpcj.zztw("Failed trying to connect with proxy").zzl(iOException).zzcyv();
        }
    }

    private static String zza(zzfbq zzfbq2) throws IOException {
        zzfba zzfba2 = new zzfba();
        do {
            if (zzfbq2.read(zzfba2, 1L) != -1L) continue;
            String string = String.valueOf(zzfba2.readByteString().zzdbc());
            throw new EOFException(string.length() != 0 ? "\\n not found: ".concat(string) : new String("\\n not found: "));
        } while (zzfba2.zzdj(zzfba2.size() - 1L) != 10);
        return zzfba2.zzdm(Long.MAX_VALUE);
    }

    public String toString() {
        String string = String.valueOf(this.getLogId());
        String string2 = String.valueOf(this.zzpfi);
        return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("(").append(string2).append(")").toString();
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    final String zzczi() {
        URI uRI = GrpcUtil.authorityToUri(this.zzpfj);
        if (uRI.getHost() != null) {
            return uRI.getHost();
        }
        return this.zzpfj;
    }

    final int zzczj() {
        URI uRI = GrpcUtil.authorityToUri(this.zzpfj);
        if (uRI.getPort() != -1) {
            return uRI.getPort();
        }
        return this.zzpfi.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzpfp != null) {
                return;
            }
            this.zzpfp = zzcq.zzpcj.zztw("Transport stopped");
            this.zzpfl.transportShutdown(this.zzpfp);
            this.zzczl();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow(zzcq zzcq2) {
        this.shutdown();
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            Iterator<Map.Entry<Integer, zzu>> iterator = this.streams.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                iterator.remove();
                ((zzu)object2.getValue()).zzczb().transportReportStatus(zzcq2, false, new zzbe());
            }
            object2 = this.zzpfu.iterator();
            while (object2.hasNext()) {
                ((zzu)object2.next()).zzczb().transportReportStatus(zzcq2, true, new zzbe());
            }
            this.zzpfu.clear();
            this.zzczm();
            this.zzczl();
            return;
        }
    }

    @Override
    public io.grpc.zza getAttributes() {
        return io.grpc.zza.zzoyf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final zzu[] zzczk() {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.values().toArray(zzpfh);
        }
    }

    final void zzm(Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable, (Object)"failureCause");
        zzcq zzcq2 = zzcq.zzpcj.zzl(throwable);
        this.zza(0, zzfab.zzpmr, zzcq2);
    }

    private final void zza(zzfab zzfab2, String string) {
        this.zza(0, zzfab2, zzy.zza(zzfab2).zztx(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, zzfab zzfab2, zzcq zzcq2) {
        Object object = this.lock;
        synchronized (object) {
            Map.Entry<Integer, zzu> entry;
            if (this.zzpfp == null) {
                this.zzpfp = zzcq2;
                this.zzpfl.transportShutdown(zzcq2);
            }
            if (zzfab2 != null && !this.zzpfq) {
                this.zzpfq = true;
                this.zzpfe.zza(0, zzfab2, new byte[0]);
            }
            Iterator<Map.Entry<Integer, zzu>> iterator = this.streams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (entry.getKey() <= n) continue;
                iterator.remove();
                ((zzu)entry.getValue()).zzczb().transportReportStatus(zzcq2, false, new zzbe());
            }
            entry = this.zzpfu.iterator();
            while (entry.hasNext()) {
                ((zzu)entry.next()).zzczb().transportReportStatus(zzcq2, true, new zzbe());
            }
            this.zzpfu.clear();
            this.zzczm();
            this.zzczl();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zza(int n, zzcq zzcq2, zzfab zzfab2, zzbe zzbe2) {
        Object object = this.lock;
        synchronized (object) {
            zzu zzu2 = this.streams.remove(n);
            if (zzu2 != null) {
                if (zzfab2 != null) {
                    this.zzpfe.zza(n, zzfab.zzpmw);
                }
                if (zzcq2 != null) {
                    boolean bl = zzcq2.zzcys() == zzcs.zzpco || zzcq2.zzcys() == zzcs.zzpcr;
                    zzu2.zzczb().transportReportStatus(zzcq2, bl, zzbe2 != null ? zzbe2 : new zzbe());
                }
                if (!this.zzczh()) {
                    this.zzczl();
                    this.zzczm();
                }
            }
            return;
        }
    }

    private final void zzczl() {
        if (this.zzpfp == null || !this.streams.isEmpty() || !this.zzpfu.isEmpty()) {
            return;
        }
        if (this.zzlyj) {
            return;
        }
        this.zzlyj = true;
        if (this.zzpfw != null) {
            this.zzpfw.onTransportTermination();
            this.scheduler = SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.scheduler);
        }
        if (this.zzpfr != null) {
            this.zzpfr.failed(this.zzczo());
            this.zzpfr = null;
        }
        if (!this.zzpfq) {
            this.zzpfq = true;
            this.zzpfe.zza(0, zzfab.zzpml, new byte[0]);
        }
        this.zzpfe.close();
    }

    private final void zzczm() {
        if (this.zzpfs && this.zzpfu.isEmpty() && this.streams.isEmpty()) {
            this.zzpfs = false;
            this.zzpfl.transportInUse(false);
            if (this.zzpfw != null) {
                this.zzpfw.onTransportIdle();
            }
        }
    }

    private final void zzczn() {
        if (!this.zzpfs) {
            this.zzpfs = true;
            this.zzpfl.transportInUse(true);
            if (this.zzpfw != null) {
                this.zzpfw.onTransportActive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Throwable zzczo() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzpfp != null) {
                return this.zzpfp.zzcyv();
            }
            return zzcq.zzpcj.zztw("Connection closed").zzcyv();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zzlm(int n) {
        Object object = this.lock;
        synchronized (object) {
            return n < this.nextStreamId && (n & 1) == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final zzu zzln(int n) {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.get(n);
        }
    }

    static zzcq zza(zzfab zzfab2) {
        zzcq zzcq2 = zzpfg.get((Object)zzfab2);
        if (zzcq2 != null) {
            return zzcq2;
        }
        int n = zzfab2.httpCode;
        return zzcq.zzpbw.zztw(new StringBuilder(37).append("Unknown http2 error code: ").append(n).toString());
    }

    public /* synthetic */ ClientStream newStream(zzbp zzbp2, zzbe zzbe2) {
        zzbe zzbe3 = zzbe2;
        zzbp zzbp3 = zzbp2;
        return (zzu)this.newStream(zzbp3, zzbe3, zzh.zzoyj);
    }

    public /* synthetic */ ClientStream newStream(zzbp zzbp2, zzbe zzbe2, zzh zzh2) {
        zzh zzh3 = zzh2;
        zzbe zzbe3 = zzbe2;
        zzbp zzbp3 = zzbp2;
        zzy zzy2 = this;
        Preconditions.checkNotNull((Object)zzbp3, (Object)"method");
        Preconditions.checkNotNull((Object)zzbe3, (Object)"headers");
        StatsTraceContext statsTraceContext = StatsTraceContext.newClientContext(zzh3, zzbe3);
        return new zzu(zzbp3, zzbe3, zzy2.zzpfe, zzy2, zzy2.zzpff, zzy2.lock, zzy2.maxMessageSize, zzy2.zzpfj, zzy2.userAgent, statsTraceContext);
    }

    static /* synthetic */ boolean zza(zzy zzy2) {
        return zzy2.zzczg();
    }

    static /* synthetic */ zza zza(zzy zzy2, zza zza2) {
        zzy2.zzpfo = zza2;
        return zzy2.zzpfo;
    }

    static /* synthetic */ zza zzb(zzy zzy2) {
        return zzy2.zzpfo;
    }

    static /* synthetic */ Executor zzc(zzy zzy2) {
        return zzy2.executor;
    }

    static /* synthetic */ Socket zzf(zzy zzy2) {
        return zzy2.socket;
    }

    static /* synthetic */ InetSocketAddress zzh(zzy zzy2) {
        return zzy2.zzpfx;
    }

    static /* synthetic */ InetSocketAddress zzi(zzy zzy2) {
        return zzy2.zzpfi;
    }

    static /* synthetic */ Socket zza(zzy zzy2, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, String string2) throws IOException, zzcv {
        return zzy2.zza(inetSocketAddress, inetSocketAddress2, string, string2);
    }

    static /* synthetic */ SSLSocketFactory zzj(zzy zzy2) {
        return zzy2.sslSocketFactory;
    }

    static /* synthetic */ zzezr zzk(zzy zzy2) {
        return zzy2.zzpfv;
    }

    static /* synthetic */ Socket zza(zzy zzy2, Socket socket) {
        zzy2.socket = socket;
        return zzy2.socket;
    }

    static /* synthetic */ int zzc(zzy zzy2, int n) {
        zzy2.zzpfn = 0;
        return 0;
    }

    static /* synthetic */ Http2Ping zza(zzy zzy2, Http2Ping http2Ping) {
        zzy2.zzpfr = null;
        return null;
    }

    static {
        EnumMap<zzfab, zzcq> enumMap = new EnumMap<zzfab, zzcq>(zzfab.class);
        enumMap.put(zzfab.zzpml, zzcq.zzpci.zztw("No error: A GRPC status of OK should have been sent"));
        enumMap.put(zzfab.zzpmm, zzcq.zzpci.zztw("Protocol error"));
        enumMap.put(zzfab.zzpmr, zzcq.zzpci.zztw("Internal error"));
        enumMap.put(zzfab.zzpms, zzcq.zzpci.zztw("Flow control error"));
        enumMap.put(zzfab.zzpmt, zzcq.zzpci.zztw("Stream closed"));
        enumMap.put(zzfab.zzpmu, zzcq.zzpci.zztw("Frame too large"));
        enumMap.put(zzfab.zzpmv, zzcq.zzpcj.zztw("Refused stream"));
        enumMap.put(zzfab.zzpmw, zzcq.zzpbv.zztw("Cancelled"));
        enumMap.put(zzfab.zzpmx, zzcq.zzpci.zztw("Compression error"));
        enumMap.put(zzfab.zzpmy, zzcq.zzpci.zztw("Connect error"));
        enumMap.put(zzfab.zzpmz, zzcq.zzpcd.zztw("Enhance your calm"));
        enumMap.put(zzfab.zzpna, zzcq.zzpcb.zztw("Inadequate security"));
        zzpfg = Collections.unmodifiableMap(enumMap);
        log = Logger.getLogger(zzy.class.getName());
        zzpfh = new zzu[0];
    }

    final class zza
    implements zzfad,
    Runnable {
        private zzfac zzpge;
        private boolean zzpgf = true;
        private /* synthetic */ zzy zzpgd;

        zza(zzy zzy2, zzfac zzfac2) {
            this.zzpgd = zzy2;
            this.zzpge = zzfac2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            String string = Thread.currentThread().getName();
            if (!GrpcUtil.IS_RESTRICTED_APPENGINE) {
                Thread.currentThread().setName("OkHttpClientTransport");
            }
            try {
                while (this.zzpge.zza(this)) {
                    if (this.zzpgd.zzpfw == null) continue;
                    this.zzpgd.zzpfw.onDataReceived();
                }
                this.zzpgd.zza(0, zzfab.zzpmr, zzcq.zzpcj.zztw("End of stream or IOException"));
            }
            catch (Throwable throwable) {
                try {
                    this.zzpgd.zza(0, zzfab.zzpmm, zzcq.zzpcj.zzl(throwable));
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    try {
                        this.zzpge.close();
                    }
                    catch (IOException iOException) {
                        log.logp(Level.INFO, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "run", "Exception closing frame reader", iOException);
                    }
                    this.zzpgd.zzpfl.transportTerminated();
                    if (GrpcUtil.IS_RESTRICTED_APPENGINE) return;
                    Thread.currentThread().setName(string);
                }
            }
            try {
                this.zzpge.close();
            }
            catch (IOException iOException) {
                log.logp(Level.INFO, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "run", "Exception closing frame reader", iOException);
            }
            this.zzpgd.zzpfl.transportTerminated();
            if (GrpcUtil.IS_RESTRICTED_APPENGINE) return;
            Thread.currentThread().setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void data(boolean bl, int n, zzfbc zzfbc2, int n2) throws IOException {
            zzu zzu2 = this.zzpgd.zzln(n);
            if (zzu2 == null) {
                if (!this.zzpgd.zzlm(n)) {
                    this.zzpgd.zza(zzfab.zzpmm, new StringBuilder(45).append("Received data for unknown stream: ").append(n).toString());
                    return;
                }
                this.zzpgd.zzpfe.zza(n, zzfab.zzpmn);
                zzfbc2.zzdp(n2);
            } else {
                zzfbc2.zzdi(n2);
                zzfba zzfba2 = new zzfba();
                zzfba2.write(zzfbc2.zzczs(), n2);
                Object object = this.zzpgd.lock;
                synchronized (object) {
                    zzu2.zzczb().zza(zzfba2, bl);
                }
            }
            this.zzpgd.zzpfn += n2;
            if (this.zzpgd.zzpfn >= Short.MAX_VALUE) {
                this.zzpgd.zzpfe.windowUpdate(0, this.zzpgd.zzpfn);
                zzy.zzc(this.zzpgd, 0);
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zza(boolean bl, boolean bl2, int n, int n2, List list, int n3) {
            boolean bl3 = false;
            Object object = this.zzpgd.lock;
            synchronized (object) {
                zzu zzu2 = (zzu)this.zzpgd.streams.get(n);
                if (zzu2 == null) {
                    if (this.zzpgd.zzlm(n)) {
                        this.zzpgd.zzpfe.zza(n, zzfab.zzpmn);
                    } else {
                        bl3 = true;
                    }
                } else {
                    zzu2.zzczb().zza(list, bl2);
                }
            }
            if (bl3) {
                this.zzpgd.zza(zzfab.zzpmm, new StringBuilder(47).append("Received header for unknown stream: ").append(n).toString());
            }
        }

        @Override
        public final void zza(int n, zzfab zzfab2) {
            this.zzpgd.zza(n, zzy.zza(zzfab2).zztx("Rst Stream"), null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zza(boolean bl, zzfaq zzfaq2) {
            Object object = this.zzpgd.lock;
            synchronized (object) {
                int n;
                if (zzfaq2.isSet(4)) {
                    n = zzfaq2.get(4);
                    this.zzpgd.zzpft = n;
                }
                if (zzfaq2.isSet(7)) {
                    n = zzfaq2.get(7);
                    this.zzpgd.zzpff.zzlo(n);
                }
                if (this.zzpgf) {
                    this.zzpgd.zzpfl.transportReady();
                    this.zzpgf = false;
                }
                this.zzpgd.zzczh();
            }
            this.zzpgd.zzpfe.zza(zzfaq2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void ping(boolean bl, int n, int n2) {
            if (!bl) {
                this.zzpgd.zzpfe.ping(true, n, n2);
                return;
            }
            Http2Ping http2Ping = null;
            long l = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
            Object object = this.zzpgd.lock;
            synchronized (object) {
                if (this.zzpgd.zzpfr != null) {
                    if (this.zzpgd.zzpfr.payload() == l) {
                        http2Ping = this.zzpgd.zzpfr;
                        zzy.zza(this.zzpgd, null);
                    } else {
                        log.logp(Level.WARNING, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "ping", String.format("Received unexpected ping ack. Expecting %d, got %d", this.zzpgd.zzpfr.payload(), l));
                    }
                } else {
                    log.logp(Level.WARNING, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "ping", "Received unexpected ping ack. No ping outstanding");
                }
            }
            if (http2Ping != null) {
                http2Ping.complete();
            }
        }

        @Override
        public final void zza(int n, zzfab zzfab2, zzfbd zzfbd2) {
            Object object;
            if (zzfab2 == zzfab.zzpmz) {
                object = zzfbd2.zzdbb();
                log.logp(Level.WARNING, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "goAway", String.format("%s: Received GOAWAY with ENHANCE_YOUR_CALM. Debug data: %s", this, object));
                if ("too_many_pings".equals(object)) {
                    this.zzpgd.zzpga.run();
                }
            }
            object = GrpcUtil.Http2Error.statusForCode(zzfab2.httpCode).zztx("Received Goaway");
            if (zzfbd2.size() > 0) {
                object = ((zzcq)object).zztx(zzfbd2.zzdbb());
            }
            this.zzpgd.zza(n, null, (zzcq)object);
        }

        @Override
        public final void pushPromise(int n, int n2, List<zzfaf> list) throws IOException {
            this.zzpgd.zzpfe.zza(n, zzfab.zzpmm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void windowUpdate(int n, long l) {
            if (l == 0L) {
                String string = "Received 0 flow control window increment.";
                if (n == 0) {
                    this.zzpgd.zza(zzfab.zzpmm, string);
                    return;
                }
                this.zzpgd.zza(n, zzcq.zzpci.zztw(string), zzfab.zzpmm, null);
                return;
            }
            boolean bl = false;
            Object object = this.zzpgd.lock;
            synchronized (object) {
                if (n == 0) {
                    this.zzpgd.zzpff.zzc(null, (int)l);
                    return;
                }
                zzu zzu2 = (zzu)this.zzpgd.streams.get(n);
                if (zzu2 != null) {
                    this.zzpgd.zzpff.zzc(zzu2, (int)l);
                } else if (!this.zzpgd.zzlm(n)) {
                    bl = true;
                }
            }
            if (bl) {
                this.zzpgd.zza(zzfab.zzpmm, new StringBuilder(54).append("Received window_update for unknown stream: ").append(n).toString());
            }
        }
    }
}

