/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdne;
import com.google.android.gms.internal.zzdnt;
import com.google.android.gms.internal.zzdnx;
import java.math.RoundingMode;
import java.util.Arrays;

final class zzdnq {
    private final String name;
    private final char[] zzlna;
    final int mask;
    final int zzlnb;
    final int zzlnc;
    final int zzlnd;
    private final byte[] zzlne;
    private final boolean[] zzlnf;

    zzdnq(String string, char[] cArray) {
        int n;
        this.name = zzdne.checkNotNull(string);
        this.zzlna = zzdne.checkNotNull(cArray);
        try {
            this.zzlnb = zzdnx.zza(cArray.length, RoundingMode.UNNECESSARY);
        }
        catch (ArithmeticException arithmeticException) {
            int n2 = cArray.length;
            throw new IllegalArgumentException(new StringBuilder(35).append("Illegal alphabet length ").append(n2).toString(), arithmeticException);
        }
        int n3 = Math.min(8, Integer.lowestOneBit(this.zzlnb));
        try {
            this.zzlnc = 8 / n3;
            this.zzlnd = this.zzlnb / n3;
        }
        catch (ArithmeticException arithmeticException) {
            String string2 = String.valueOf(new String(cArray));
            throw new IllegalArgumentException(string2.length() != 0 ? "Illegal alphabet ".concat(string2) : new String("Illegal alphabet "), arithmeticException);
        }
        this.mask = cArray.length - 1;
        byte[] byArray = new byte[128];
        Arrays.fill(byArray, (byte)-1);
        for (int i = 0; i < cArray.length; ++i) {
            n = cArray[i];
            zzdne.zza(n < 128, "Non-ASCII character: %s", (char)n);
            zzdne.zza(byArray[n] == -1, "Duplicate character: %s", (char)n);
            byArray[n] = (byte)i;
        }
        this.zzlne = byArray;
        boolean[] blArray = new boolean[this.zzlnc];
        for (n = 0; n < this.zzlnd; ++n) {
            blArray[zzdnx.zza((int)(n << 3), (int)this.zzlnb, (RoundingMode)RoundingMode.CEILING)] = true;
        }
        this.zzlnf = blArray;
    }

    final char zzfg(int n) {
        return this.zzlna[n];
    }

    final boolean zzfh(int n) {
        return this.zzlnf[n % this.zzlnc];
    }

    final int zzf(char c) throws zzdnt {
        if (c > '\u007f') {
            String string = String.valueOf(Integer.toHexString(c));
            throw new zzdnt(string.length() != 0 ? "Unrecognized character: 0x".concat(string) : new String("Unrecognized character: 0x"));
        }
        byte by = this.zzlne[c];
        if (by == -1) {
            if (c <= ' ' || c == '\u007f') {
                String string = String.valueOf(Integer.toHexString(c));
                throw new zzdnt(string.length() != 0 ? "Unrecognized character: 0x".concat(string) : new String("Unrecognized character: 0x"));
            }
            throw new zzdnt(new StringBuilder(25).append("Unrecognized character: ").append(c).toString());
        }
        return by;
    }

    public final boolean zzg(char c) {
        return c < this.zzlne.length && this.zzlne[c] != -1;
    }

    public final String toString() {
        return this.name;
    }

    public final boolean equals(Object object) {
        if (object instanceof zzdnq) {
            zzdnq zzdnq2 = (zzdnq)object;
            return Arrays.equals(this.zzlna, zzdnq2.zzlna);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.zzlna);
    }

    static /* synthetic */ char[] zza(zzdnq zzdnq2) {
        return zzdnq2.zzlna;
    }
}

