/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdna;
import com.google.android.gms.internal.zzdne;
import com.google.android.gms.internal.zzdnp;
import com.google.android.gms.internal.zzdnq;
import com.google.android.gms.internal.zzdnt;
import com.google.android.gms.internal.zzdnx;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.Arrays;

class zzdnu
extends zzdnp {
    final zzdnq zzlnh;
    private Character zzlni;

    zzdnu(String string, String string2, Character c) {
        this(new zzdnq(string, string2.toCharArray()), c);
    }

    zzdnu(zzdnq zzdnq2, Character c) {
        this.zzlnh = zzdne.checkNotNull(zzdnq2);
        zzdne.zza(c == null || !zzdnq2.zzg(c.charValue()), "Padding character %s was already in alphabet", (Object)c);
        this.zzlni = c;
    }

    @Override
    final int zzfe(int n) {
        return this.zzlnh.zzlnc * zzdnx.zza(n, this.zzlnh.zzlnd, RoundingMode.CEILING);
    }

    @Override
    void zza(Appendable appendable, byte[] byArray, int n, int n2) throws IOException {
        zzdne.checkNotNull(appendable);
        zzdne.zze(0, n2 + 0, byArray.length);
        for (int i = 0; i < n2; i += this.zzlnh.zzlnd) {
            this.zzb(appendable, byArray, i + 0, Math.min(this.zzlnh.zzlnd, n2 - i));
        }
    }

    final void zzb(Appendable appendable, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        zzdne.checkNotNull(appendable);
        zzdne.zze(n, n + n2, byArray.length);
        zzdne.checkArgument(n2 <= this.zzlnh.zzlnd);
        long l = 0L;
        for (n4 = 0; n4 < n2; ++n4) {
            l = (l | (long)(byArray[n + n4] & 0xFF)) << 8;
        }
        n4 = (n2 + 1 << 3) - this.zzlnh.zzlnb;
        for (n3 = 0; n3 < n2 << 3; n3 += this.zzlnh.zzlnb) {
            int n5 = (int)(l >>> n4 - n3) & this.zzlnh.mask;
            appendable.append(this.zzlnh.zzfg(n5));
        }
        if (this.zzlni != null) {
            while (n3 < this.zzlnh.zzlnd << 3) {
                appendable.append(this.zzlni.charValue());
                n3 += this.zzlnh.zzlnb;
            }
        }
    }

    @Override
    final int zzff(int n) {
        return (int)(((long)this.zzlnh.zzlnb * (long)n + 7L) / 8L);
    }

    @Override
    final CharSequence zzb(CharSequence charSequence) {
        int n;
        zzdne.checkNotNull(charSequence);
        if (this.zzlni == null) {
            return charSequence;
        }
        char c = this.zzlni.charValue();
        for (n = charSequence.length() - 1; n >= 0 && charSequence.charAt(n) == c; --n) {
        }
        return charSequence.subSequence(0, n + 1);
    }

    @Override
    int zza(byte[] byArray, CharSequence charSequence) throws zzdnt {
        zzdne.checkNotNull(byArray);
        charSequence = ((zzdnp)this).zzb(charSequence);
        if (!this.zzlnh.zzfh(charSequence.length())) {
            int n = charSequence.length();
            throw new zzdnt(new StringBuilder(32).append("Invalid input length ").append(n).toString());
        }
        int n = 0;
        for (int i = 0; i < charSequence.length(); i += this.zzlnh.zzlnc) {
            int n2;
            long l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < this.zzlnh.zzlnc; ++n2) {
                l <<= this.zzlnh.zzlnb;
                if (i + n2 >= charSequence.length()) continue;
                l |= (long)this.zzlnh.zzf(charSequence.charAt(i + n3++));
            }
            n2 = (this.zzlnh.zzlnd << 3) - n3 * this.zzlnh.zzlnb;
            for (int j = this.zzlnh.zzlnd - 1 << 3; j >= n2; j -= 8) {
                byArray[n++] = (byte)(l >>> j & 0xFFL);
            }
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("BaseEncoding.");
        stringBuilder.append(this.zzlnh.toString());
        if (8 % this.zzlnh.zzlnb != 0) {
            if (this.zzlni == null) {
                stringBuilder.append(".omitPadding()");
            } else {
                stringBuilder.append(".withPadChar('").append(this.zzlni).append("')");
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof zzdnu) {
            zzdnu zzdnu2 = (zzdnu)object;
            return this.zzlnh.equals(zzdnu2.zzlnh) && zzdna.equal(this.zzlni, zzdnu2.zzlni);
        }
        return false;
    }

    public int hashCode() {
        return this.zzlnh.hashCode() ^ Arrays.hashCode(new Object[]{this.zzlni});
    }
}

