/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdne;
import com.google.android.gms.internal.zzdnz;
import java.math.RoundingMode;

public final class zzdnx {
    private static byte[] zzlnk = new byte[]{9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0};
    private static int[] zzlnl = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static int[] zzlnm = new int[]{3, 31, 316, 3162, 31622, 316227, 3162277, 31622776, 316227766, Integer.MAX_VALUE};
    private static final int[] zzlnn = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};
    private static int[] zzlno = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 65536, 2345, 477, 193, 110, 75, 58, 49, 43, 39, 37, 35, 34, 34, 33};

    public static int zza(int n, RoundingMode roundingMode) {
        int n2 = n;
        String string = "x";
        if (n2 <= 0) {
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append(string).append(" (").append(n2).append(") must be > 0").toString());
        }
        switch (roundingMode) {
            case UNNECESSARY: {
                int n3 = n;
                zzdnz.zzby(n3 > 0 & (n3 & n3 - 1) == 0);
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(n);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(n - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n4 = Integer.numberOfLeadingZeros(n);
                int n5 = -1257966797 >>> n4;
                n2 = n;
                return 31 - n4 + (~(~(n5 - n2)) >>> 31);
            }
        }
        throw new AssertionError();
    }

    public static int zza(int n, int n2, RoundingMode roundingMode) {
        boolean bl;
        zzdne.checkNotNull(roundingMode);
        if (n2 == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int n3 = n / n2;
        int n4 = n - n2 * n3;
        if (n4 == 0) {
            return n3;
        }
        int n5 = 1 | (n ^ n2) >> 31;
        switch (roundingMode) {
            case UNNECESSARY: {
                zzdnz.zzby(n4 == 0);
            }
            case DOWN: {
                bl = false;
                break;
            }
            case UP: {
                bl = true;
                break;
            }
            case CEILING: {
                bl = n5 > 0;
                break;
            }
            case FLOOR: {
                bl = n5 < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n6 = Math.abs(n4);
                int n7 = n6 - (Math.abs(n2) - n6);
                if (n7 == 0) {
                    bl = roundingMode == RoundingMode.HALF_UP || roundingMode == RoundingMode.HALF_EVEN & (n3 & 1) != 0;
                    break;
                }
                bl = n7 > 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (bl) {
            return n3 + n5;
        }
        return n3;
    }
}

