/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdlz;
import com.google.android.gms.internal.zzdne;
import com.google.android.gms.internal.zzdnk;
import com.google.android.gms.internal.zzdnm;
import com.google.android.gms.internal.zzdoc;
import com.google.android.gms.internal.zzdod;
import com.google.android.gms.internal.zzdoh;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class zzdoa<V>
extends zzdoc<V> {
    private static final boolean zzlnq;
    private static final Logger zzlnr;
    private static final zza zzlns;
    private static final Object NULL;
    private volatile Object value;
    private volatile zzd listeners;
    private volatile zzj waiters;

    /*
     * Unable to fully structure code
     */
    private final void zza(zzj var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            var2_2 = null;
            var3_3 = this.waiters;
            if (var3_3 == zzj.zzloo) {
                return;
            }
            while (var3_3 != null) {
                var4_4 = var3_3.next;
                if (var3_3.thread != null) {
                    var2_2 = var3_3;
                } else if (var2_2 != null) {
                    var2_2.next = var4_4;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    if (zzdoa.zzlns.zza(this, var3_3, var4_4)) ** break;
                    continue block0;
                }
                var3_3 = var4_4;
            }
            break;
        }
    }

    protected zzdoa() {
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        Object object;
        Object object2;
        long l2;
        Object object3;
        long l3;
        block11: {
            l3 = timeUnit.toNanos(l);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            object3 = this.value;
            if (object3 != null & !(object3 instanceof zzf)) {
                return zzdoa.zzax(object3);
            }
            long l4 = l2 = l3 > 0L ? System.nanoTime() + l3 : 0L;
            if (l3 >= 1000L) {
                object2 = this.waiters;
                if (object2 != zzj.zzloo) {
                    object = new zzj();
                    do {
                        ((zzj)object).zzb((zzj)object2);
                        if (!zzlns.zza(this, (zzj)object2, (zzj)object)) continue;
                        do {
                            LockSupport.parkNanos(this, l3);
                            if (Thread.interrupted()) {
                                this.zza((zzj)object);
                                throw new InterruptedException();
                            }
                            object3 = this.value;
                            if (!(object3 != null & !(object3 instanceof zzf))) continue;
                            return zzdoa.zzax(object3);
                        } while ((l3 = l2 - System.nanoTime()) >= 1000L);
                        this.zza((zzj)object);
                        break block11;
                    } while ((object2 = this.waiters) != zzj.zzloo);
                }
                return zzdoa.zzax(this.value);
            }
        }
        while (l3 > 0L) {
            object3 = this.value;
            if (object3 != null & !(object3 instanceof zzf)) {
                return zzdoa.zzax(object3);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            l3 = l2 - System.nanoTime();
        }
        object2 = this.toString();
        if (this.isDone()) {
            object = zzdlz.toLowerCase(timeUnit.toString());
            throw new TimeoutException(new StringBuilder(68 + String.valueOf(object).length()).append("Waited ").append(l).append(" ").append((String)object).append(" but future completed as timeout expired").toString());
        }
        object = zzdlz.toLowerCase(timeUnit.toString());
        throw new TimeoutException(new StringBuilder(33 + String.valueOf(object).length() + String.valueOf(object2).length()).append("Waited ").append(l).append(" ").append((String)object).append(" for ").append((String)object2).toString());
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.value;
        if (object != null & !(object instanceof zzf)) {
            return zzdoa.zzax(object);
        }
        zzj zzj2 = this.waiters;
        if (zzj2 != zzj.zzloo) {
            zzj zzj3 = new zzj();
            do {
                zzj3.zzb(zzj2);
                if (!zzlns.zza(this, zzj2, zzj3)) continue;
                do {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    this.zza(zzj3);
                    throw new InterruptedException();
                } while (!((object = this.value) != null & !(object instanceof zzf)));
                return zzdoa.zzax(object);
            } while ((zzj2 = this.waiters) != zzj.zzloo);
        }
        return zzdoa.zzax(this.value);
    }

    private static V zzax(Object object) throws ExecutionException {
        if (object instanceof zzb) {
            Throwable throwable = ((zzb)object).cause;
            String string = "Task was cancelled.";
            CancellationException cancellationException = new CancellationException(string);
            cancellationException.initCause(throwable);
            throw cancellationException;
        }
        if (object instanceof zzc) {
            throw new ExecutionException(((zzc)object).zzlnx);
        }
        if (object == NULL) {
            return null;
        }
        return object;
    }

    @Override
    public boolean isDone() {
        Object object = this.value;
        return object != null & !(object instanceof zzf);
    }

    @Override
    public boolean isCancelled() {
        return this.value instanceof zzb;
    }

    @Override
    public boolean cancel(boolean bl) {
        Object object = this.value;
        boolean bl2 = false;
        if (object == null | object instanceof zzf) {
            zzb zzb2 = zzlnq ? new zzb(bl, new CancellationException("Future.cancel() was called.")) : (bl ? zzb.zzlnt : zzb.zzlnu);
            zzdoa zzdoa2 = this;
            while (true) {
                if (zzlns.zza(zzdoa2, object, zzb2)) {
                    bl2 = true;
                    zzdoa.zza(zzdoa2);
                    if (!(object instanceof zzf)) break;
                    zzdoh zzdoh2 = ((zzf)object).zzloh;
                    if (zzdoh2 instanceof zzh) {
                        zzdoa zzdoa3 = (zzdoa)zzdoh2;
                        object = zzdoa3.value;
                        if (!(object == null | object instanceof zzf)) break;
                        zzdoa2 = zzdoa3;
                        continue;
                    }
                    zzdoh2.cancel(bl);
                    break;
                }
                object = zzdoa2.value;
                if (!(object instanceof zzf)) break;
            }
        }
        return bl2;
    }

    protected boolean zzay(V v) {
        Object object = NULL;
        if (zzlns.zza(this, null, object)) {
            zzdoa.zza(this);
            return true;
        }
        return false;
    }

    private static Object zza(zzdoh<?> zzdoh2) {
        Object object;
        if (zzdoh2 instanceof zzh) {
            Object object2 = ((zzdoa)zzdoh2).value;
            if (object2 instanceof zzb) {
                zzb zzb2 = (zzb)object2;
                if (zzb2.zzlnv) {
                    object2 = zzb2.cause != null ? new zzb(false, zzb2.cause) : zzb.zzlnu;
                }
            }
            return object2;
        }
        try {
            Object obj = zzdod.zza(zzdoh2);
            object = obj == null ? NULL : obj;
        }
        catch (ExecutionException executionException) {
            object = new zzc(executionException.getCause());
        }
        catch (CancellationException cancellationException) {
            object = new zzb(false, cancellationException);
        }
        catch (Throwable throwable) {
            object = new zzc(throwable);
        }
        return object;
    }

    private static void zza(zzdoa<?> zzdoa2) {
        Object object = null;
        block2: while (true) {
            Object object2;
            Object object3;
            Object object4;
            Object object5 = zzdoa2;
            while (!zzlns.zza((zzdoa<?>)object5, (zzj)(object4 = ((zzdoa)object5).waiters), zzj.zzloo)) {
            }
            Object object6 = object4;
            while (object6 != null) {
                object3 = object6;
                object2 = ((zzj)object3).thread;
                if (object2 != null) {
                    ((zzj)object3).thread = null;
                    LockSupport.unpark((Thread)object2);
                }
                object6 = ((zzj)object6).next;
            }
            object4 = object;
            object5 = zzdoa2;
            while (!zzlns.zza((zzdoa<?>)object5, (zzd)(object6 = ((zzdoa)object5).listeners), zzd.zzlny)) {
            }
            object3 = object4;
            while (object6 != null) {
                object2 = object6;
                object6 = ((zzd)object6).next;
                ((zzd)object2).next = object3;
                object3 = object2;
            }
            object = object3;
            while (object != null) {
                zzj zzj2 = object;
                object = ((zzd)object).next;
                Runnable runnable = ((zzd)((Object)zzj2)).zzlnz;
                if (runnable instanceof zzf) {
                    Object object7;
                    zzf zzf2 = (zzf)runnable;
                    zzdoa2 = zzf2.zzlog;
                    if (zzdoa2.value == zzf2 && zzlns.zza(zzdoa2, zzf2, object7 = zzdoa.zza(zzf2.zzloh))) continue block2;
                    continue;
                }
                object4 = ((zzd)((Object)zzj2)).zzloa;
                object5 = runnable;
                try {
                    object4.execute((Runnable)object5);
                }
                catch (RuntimeException runtimeException) {
                    object3 = String.valueOf(object5);
                    object2 = String.valueOf(object4);
                    zzlnr.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "executeListener", new StringBuilder(57 + String.valueOf(object3).length() + String.valueOf(object2).length()).append("RuntimeException while executing runnable ").append((String)object3).append(" with executor ").append((String)object2).toString(), runtimeException);
                }
            }
            break;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(super.toString()).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
        } else if (this.isDone()) {
            this.zza(stringBuilder);
        } else {
            String string;
            try {
                String string2;
                zzdoa zzdoa2 = this;
                Object object = zzdoa2.value;
                if (object instanceof zzf) {
                    String string3 = String.valueOf(((zzf)object).zzloh);
                    string2 = new StringBuilder(12 + String.valueOf(string3).length()).append("setFuture=[").append(string3).append("]").toString();
                } else if (zzdoa2 instanceof ScheduledFuture) {
                    long l = ((ScheduledFuture)((Object)zzdoa2)).getDelay(TimeUnit.MILLISECONDS);
                    string2 = new StringBuilder(41).append("remaining delay=[").append(l).append(" ms]").toString();
                } else {
                    string2 = null;
                }
                string = string2;
            }
            catch (RuntimeException runtimeException) {
                String string4 = String.valueOf(runtimeException.getClass());
                string = new StringBuilder(38 + String.valueOf(string4).length()).append("Exception thrown from implementation: ").append(string4).toString();
            }
            if (!zzdnk.zzn(string)) {
                stringBuilder.append("PENDING, info=[").append(string).append("]");
            } else if (this.isDone()) {
                this.zza(stringBuilder);
            } else {
                stringBuilder.append("PENDING");
            }
        }
        return stringBuilder.append("]").toString();
    }

    private final void zza(StringBuilder stringBuilder) {
        try {
            Object v = zzdod.zza(this);
            stringBuilder.append("SUCCESS, result=[").append(v).append("]");
            return;
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
            return;
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
            return;
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("UNKNOWN, cause=[").append(runtimeException.getClass()).append(" thrown from get()]");
            return;
        }
    }

    static {
        zza zza2;
        zzlnq = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        zzlnr = Logger.getLogger(zzdoa.class.getName());
        try {
            zza2 = new zzi();
        }
        catch (Throwable throwable) {
            try {
                zza2 = new zze(AtomicReferenceFieldUpdater.newUpdater(zzj.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(zzj.class, zzj.class, "next"), AtomicReferenceFieldUpdater.newUpdater(zzdoa.class, zzj.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(zzdoa.class, zzd.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(zzdoa.class, Object.class, "value"));
            }
            catch (Throwable throwable2) {
                zzlnr.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "<clinit>", "UnsafeAtomicHelper is broken!", throwable);
                zzlnr.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "<clinit>", "SafeAtomicHelper is broken!", throwable2);
                zza2 = new zzg();
            }
        }
        zzlns = zza2;
        NULL = new Object();
    }

    static final class zzg
    extends zza {
        private zzg() {
        }

        @Override
        final void zza(zzj zzj2, Thread thread) {
            zzj2.thread = thread;
        }

        @Override
        final void zza(zzj zzj2, zzj zzj3) {
            zzj2.next = zzj3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean zza(zzdoa<?> zzdoa2, zzj zzj2, zzj zzj3) {
            zzdoa<?> zzdoa3 = zzdoa2;
            synchronized (zzdoa3) {
                if (((zzdoa)zzdoa2).waiters == zzj2) {
                    ((zzdoa)zzdoa2).waiters = zzj3;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean zza(zzdoa<?> zzdoa2, zzd zzd2, zzd zzd3) {
            zzdoa<?> zzdoa3 = zzdoa2;
            synchronized (zzdoa3) {
                if (((zzdoa)zzdoa2).listeners == zzd2) {
                    ((zzdoa)zzdoa2).listeners = zzd3;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean zza(zzdoa<?> zzdoa2, Object object, Object object2) {
            zzdoa<?> zzdoa3 = zzdoa2;
            synchronized (zzdoa3) {
                if (((zzdoa)zzdoa2).value == object) {
                    ((zzdoa)zzdoa2).value = object2;
                    return true;
                }
                return false;
            }
        }
    }

    static final class zze
    extends zza {
        final AtomicReferenceFieldUpdater<zzj, Thread> zzlob;
        final AtomicReferenceFieldUpdater<zzj, zzj> zzloc;
        final AtomicReferenceFieldUpdater<zzdoa, zzj> zzlod;
        final AtomicReferenceFieldUpdater<zzdoa, zzd> zzloe;
        final AtomicReferenceFieldUpdater<zzdoa, Object> zzlof;

        zze(AtomicReferenceFieldUpdater<zzj, Thread> atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater<zzj, zzj> atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater<zzdoa, zzj> atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater<zzdoa, zzd> atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater<zzdoa, Object> atomicReferenceFieldUpdater5) {
            this.zzlob = atomicReferenceFieldUpdater;
            this.zzloc = atomicReferenceFieldUpdater2;
            this.zzlod = atomicReferenceFieldUpdater3;
            this.zzloe = atomicReferenceFieldUpdater4;
            this.zzlof = atomicReferenceFieldUpdater5;
        }

        @Override
        final void zza(zzj zzj2, Thread thread) {
            this.zzlob.lazySet(zzj2, thread);
        }

        @Override
        final void zza(zzj zzj2, zzj zzj3) {
            this.zzloc.lazySet(zzj2, zzj3);
        }

        @Override
        final boolean zza(zzdoa<?> zzdoa2, zzj zzj2, zzj zzj3) {
            return this.zzlod.compareAndSet(zzdoa2, zzj2, zzj3);
        }

        @Override
        final boolean zza(zzdoa<?> zzdoa2, zzd zzd2, zzd zzd3) {
            return this.zzloe.compareAndSet(zzdoa2, zzd2, zzd3);
        }

        @Override
        final boolean zza(zzdoa<?> zzdoa2, Object object, Object object2) {
            return this.zzlof.compareAndSet(zzdoa2, object, object2);
        }
    }

    static final class zzi
    extends zza {
        static final Unsafe zzloi;
        static final long zzloj;
        static final long zzlok;
        static final long zzlol;
        static final long zzlom;
        static final long zzlon;

        private zzi() {
        }

        @Override
        final void zza(zzj zzj2, Thread thread) {
            zzloi.putObject(zzj2, zzlom, thread);
        }

        @Override
        final void zza(zzj zzj2, zzj zzj3) {
            zzloi.putObject(zzj2, zzlon, zzj3);
        }

        @Override
        final boolean zza(zzdoa<?> zzdoa2, zzj zzj2, zzj zzj3) {
            return zzloi.compareAndSwapObject(zzdoa2, zzlok, zzj2, zzj3);
        }

        @Override
        final boolean zza(zzdoa<?> zzdoa2, zzd zzd2, zzd zzd3) {
            return zzloi.compareAndSwapObject(zzdoa2, zzloj, zzd2, zzd3);
        }

        @Override
        final boolean zza(zzdoa<?> zzdoa2, Object object, Object object2) {
            return zzloi.compareAndSwapObject(zzdoa2, zzlol, object, object2);
        }

        static {
            Unsafe unsafe;
            try {
                unsafe = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public /* synthetic */ Object run() throws Exception {
                            Class<Unsafe> clazz = Unsafe.class;
                            for (Field field : Unsafe.class.getDeclaredFields()) {
                                field.setAccessible(true);
                                Object object = field.get(null);
                                if (!clazz.isInstance(object)) continue;
                                return (Unsafe)clazz.cast(object);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                }
            }
            try {
                Class<zzdoa> clazz = zzdoa.class;
                zzlok = unsafe.objectFieldOffset(clazz.getDeclaredField("waiters"));
                zzloj = unsafe.objectFieldOffset(clazz.getDeclaredField("listeners"));
                zzlol = unsafe.objectFieldOffset(clazz.getDeclaredField("value"));
                zzlom = unsafe.objectFieldOffset(zzj.class.getDeclaredField("thread"));
                zzlon = unsafe.objectFieldOffset(zzj.class.getDeclaredField("next"));
                zzloi = unsafe;
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzdnm.zzf(exception);
                throw new RuntimeException(exception2);
            }
        }
    }

    static abstract class zza {
        private zza() {
        }

        abstract void zza(zzj var1, Thread var2);

        abstract void zza(zzj var1, zzj var2);

        abstract boolean zza(zzdoa<?> var1, zzj var2, zzj var3);

        abstract boolean zza(zzdoa<?> var1, zzd var2, zzd var3);

        abstract boolean zza(zzdoa<?> var1, Object var2, Object var3);
    }

    static final class zzf<V>
    implements Runnable {
        final zzdoa<V> zzlog;
        final zzdoh<? extends V> zzloh;

        @Override
        public final void run() {
            throw new NoSuchMethodError();
        }
    }

    static final class zzb {
        static final zzb zzlnt;
        static final zzb zzlnu;
        final boolean zzlnv;
        final Throwable cause;

        zzb(boolean bl, Throwable throwable) {
            this.zzlnv = bl;
            this.cause = throwable;
        }

        static {
            if (zzlnq) {
                zzlnu = null;
                zzlnt = null;
            } else {
                zzlnu = new zzb(false, null);
                zzlnt = new zzb(true, null);
            }
        }
    }

    static final class zzc {
        static final zzc zzlnw = new zzc(new Throwable("Failure occurred while trying to finish a future."){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        });
        final Throwable zzlnx;

        zzc(Throwable throwable) {
            this.zzlnx = zzdne.checkNotNull(throwable);
        }
    }

    static final class zzd {
        static final zzd zzlny = new zzd(null, null);
        final Runnable zzlnz = null;
        final Executor zzloa = null;
        zzd next;

        private zzd(Runnable runnable, Executor executor) {
        }
    }

    static final class zzj {
        static final zzj zzloo = new zzj(false);
        volatile Thread thread;
        volatile zzj next;

        private zzj(boolean bl) {
        }

        zzj() {
            zzlns.zza(this, Thread.currentThread());
        }

        final void zzb(zzj zzj2) {
            zzlns.zza(this, zzj2);
        }
    }

    static abstract class zzh<V>
    extends zzdoa<V> {
        zzh() {
        }

        @Override
        public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l, timeUnit);
        }
    }
}

