/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzelg;
import com.google.android.gms.internal.zzeme;
import com.google.android.gms.internal.zzene;
import com.google.android.gms.internal.zzenf;
import com.google.android.gms.internal.zzeni;
import com.google.android.gms.internal.zzeod;
import com.google.android.gms.internal.zzeoo;
import com.google.android.gms.internal.zzeop;
import com.google.android.gms.internal.zzeoq;
import com.google.android.gms.internal.zzeor;
import com.google.android.gms.internal.zzeos;
import com.google.android.gms.internal.zzeot;
import com.google.android.gms.internal.zzeou;
import com.google.android.gms.internal.zzeov;
import com.google.android.gms.internal.zzeow;
import com.google.android.gms.internal.zzeox;
import com.google.android.gms.internal.zzeoy;
import com.google.android.gms.internal.zzepv;
import com.google.android.gms.internal.zzeqc;
import com.google.android.gms.internal.zzeqe;
import com.google.android.gms.internal.zzeqk;
import com.google.android.gms.internal.zzeql;
import com.google.android.gms.internal.zzerm;
import com.google.android.gms.internal.zzetc;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzfdh;
import com.google.android.gms.internal.zzfew;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzeon
implements zzeod {
    private final zzeoy zznkq;
    private final zzeni zznkr;
    private final String zzgzb;
    private int zznjv;
    private int zznks;
    private zzfdh zznjx;
    private zzenf zznja;

    zzeon(zzeoy zzeoy2, zzeni zzeni2, zzelg zzelg2) {
        this.zznkq = zzeoy2;
        this.zznkr = zzeni2;
        this.zzgzb = zzelg2.zzcad() ? "" : zzelg2.getUid();
        this.zznjx = zzetc.zznrs;
    }

    @Override
    public final void start() {
        zzeon zzeon2 = this;
        ArrayList arrayList = new ArrayList();
        zzeon2.zznkq.zzqd("SELECT uid FROM mutation_queues").zza(new zzeop(arrayList));
        zzeon2.zznjv = 0;
        ArrayList arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList2.get(i);
            String string = (String)e;
            zzeon2.zznkq.zzqd("SELECT MAX(batch_id) FROM mutations WHERE uid = ?").zzd(string).zza(new zzeoq(zzeon2));
        }
        ++zzeon2.zznjv;
        this.zznks = -1;
        if (this.zznkq.zzqd("SELECT last_acknowledged_batch_id, last_stream_token FROM mutation_queues WHERE uid = ?").zzd(this.zzgzb).zzb(new zzeoo(this)) == 0) {
            this.zzcci();
            return;
        }
        if (this.zznks >= this.zznjv) {
            zzete.zzc(this.isEmpty(), "Reset nextBatchId is only possible when the queue is empty", new Object[0]);
            this.zznks = -1;
            this.zzcci();
        }
    }

    private final boolean isEmpty() {
        return this.zznkq.zzqd("SELECT batch_id FROM mutations WHERE uid = ? LIMIT 1").zzd(this.zzgzb).isEmpty();
    }

    @Override
    public final int zzcby() {
        return this.zznks;
    }

    @Override
    public final void zza(zzeql zzeql2, zzfdh zzfdh2) {
        int n = zzeql2.zzcbw();
        zzete.zzc(n > this.zznks, "Mutation batchIds must be acknowledged in order", new Object[0]);
        this.zznks = n;
        this.zznjx = (zzfdh)zzbq.checkNotNull((Object)zzfdh2);
        this.zzcci();
    }

    @Override
    public final zzfdh zzcbq() {
        return this.zznjx;
    }

    @Override
    public final void zzac(zzfdh zzfdh2) {
        this.zznjx = (zzfdh)zzbq.checkNotNull((Object)zzfdh2);
        this.zzcci();
    }

    private final void zzcci() {
        this.zznkq.zzk("INSERT OR REPLACE INTO mutation_queues (uid, last_acknowledged_batch_id, last_stream_token) VALUES (?, ?, ?)", this.zzgzb, this.zznks, this.zznjx.toByteArray());
    }

    @Override
    public final zzeql zzb(zzeqe zzeqe2, List<zzeqk> list) {
        int n = this.zznjv++;
        zzeql zzeql2 = new zzeql(n, zzeqe2, list);
        zzerm zzerm2 = this.zznkr.zza(zzeql2);
        this.zznkq.zzk("INSERT INTO mutations (uid, batch_id, mutations) VALUES (?, ?, ?)", this.zzgzb, n, zzerm2.toByteArray());
        HashSet<zzepv> hashSet = new HashSet<zzepv>();
        SQLiteStatement sQLiteStatement = this.zznkq.zzqc("INSERT INTO document_mutations (uid, path, batch_id) VALUES (?, ?, ?)");
        Iterator<zzeqk> iterator = list.iterator();
        while (iterator.hasNext()) {
            zzepv zzepv2 = iterator.next().zzbzr();
            if (!hashSet.add(zzepv2)) continue;
            String string = zzene.zza(zzepv2.zzcan());
            zzeoy.zza(sQLiteStatement, this.zzgzb, string, n);
        }
        return zzeql2;
    }

    @Override
    public final zzeql zzgs(int n) {
        return (zzeql)this.zznkq.zzqd("SELECT mutations FROM mutations WHERE uid = ? AND batch_id = ?").zzd(this.zzgzb, n).zza(new zzeor(this));
    }

    @Override
    public final zzeql zzgt(int n) {
        return (zzeql)this.zznkq.zzqd("SELECT mutations FROM mutations WHERE uid = ? AND batch_id > ? ORDER BY batch_id ASC LIMIT 1").zzd(this.zzgzb, n).zza(new zzeos(this));
    }

    @Override
    public final List<zzeql> zzcbz() {
        ArrayList<zzeql> arrayList = new ArrayList<zzeql>();
        this.zznkq.zzqd("SELECT mutations FROM mutations WHERE uid = ? ORDER BY batch_id ASC").zzd(this.zzgzb).zza(new zzeot(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzeql> zzgu(int n) {
        ArrayList<zzeql> arrayList = new ArrayList<zzeql>();
        this.zznkq.zzqd("SELECT mutations FROM mutations WHERE uid = ? AND batch_id <= ? ORDER BY batch_id ASC").zzd(this.zzgzb, n).zza(new zzeou(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzeql> zzf(zzepv zzepv2) {
        String string = zzene.zza(zzepv2.zzcan());
        ArrayList<zzeql> arrayList = new ArrayList<zzeql>();
        this.zznkq.zzqd("SELECT m.mutations FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path = ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id").zzd(this.zzgzb, string).zza(new zzeov(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzeql> zzh(zzeme zzeme2) {
        zzeqc zzeqc2 = zzeme2.zzcan();
        int n = zzeqc2.length() + 1;
        String string = zzene.zza(zzeqc2);
        String string2 = zzene.zzqb(string);
        ArrayList<zzeql> arrayList = new ArrayList<zzeql>();
        this.zznkq.zzqd("SELECT dm.batch_id, dm.path, m.mutations FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path >= ? AND dm.path < ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id ORDER BY dm.batch_id").zzd(this.zzgzb, string, string2).zza(new zzeow(this, arrayList, n));
        return arrayList;
    }

    @Override
    public final void zzbe(List<zzeql> list) {
        SQLiteStatement sQLiteStatement = this.zznkq.zzqc("DELETE FROM mutations WHERE uid = ? AND batch_id = ?");
        SQLiteStatement sQLiteStatement2 = this.zznkq.zzqc("DELETE FROM document_mutations WHERE uid = ? AND path = ? AND batch_id = ?");
        for (zzeql zzeql2 : list) {
            int n = zzeql2.zzcbw();
            zzete.zzc(zzeoy.zza(sQLiteStatement, this.zzgzb, n) != 0, "Mutation batch (%s, %d) did not exist", this.zzgzb, zzeql2.zzcbw());
            Iterator<zzeqk> iterator = zzeql2.zzcdn().iterator();
            while (iterator.hasNext()) {
                zzepv zzepv2 = iterator.next().zzbzr();
                String string = zzene.zza(zzepv2.zzcan());
                zzeoy.zza(sQLiteStatement2, this.zzgzb, string, n);
                if (this.zznja == null) continue;
                this.zznja.zzc(zzepv2);
            }
        }
    }

    @Override
    public final void zzcca() {
        if (!this.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.zznkq.zzqd("SELECT path FROM document_mutations WHERE uid = ?").zzd(this.zzgzb).zza(new zzeox(arrayList));
        zzete.zzc(arrayList.isEmpty(), "Document leak -- detected dangling mutation references when queue is empty. Dangling keys: %s", arrayList);
    }

    private final zzeql zzaq(byte[] byArray) {
        try {
            return this.zznkr.zza(zzerm.zzav(byArray));
        }
        catch (zzfew zzfew2) {
            throw zzete.zzl("MutationBatch failed to parse: %s", new Object[]{zzfew2});
        }
    }

    @Override
    public final void zza(zzenf zzenf2) {
        this.zznja = zzenf2;
    }

    @Override
    public final boolean zzd(zzepv zzepv2) {
        String string = zzene.zza(zzepv2.zzcan());
        return !this.zznkq.zzqd("SELECT batch_id FROM document_mutations WHERE uid = ? AND path = ? LIMIT 1").zzd(this.zzgzb, string).isEmpty();
    }

    final /* synthetic */ void zza(List list, int n, Cursor cursor) {
        int n2 = cursor.getInt(0);
        int n3 = list.size();
        if (n3 > 0 && n2 == ((zzeql)list.get(n3 - 1)).zzcbw()) {
            return;
        }
        if (zzene.zzqa(cursor.getString(1)).length() != n) {
            return;
        }
        list.add(this.zzaq(cursor.getBlob(2)));
    }

    final /* synthetic */ void zza(List list, Cursor cursor) {
        list.add(this.zzaq(cursor.getBlob(0)));
    }

    final /* synthetic */ void zzb(List list, Cursor cursor) {
        list.add(this.zzaq(cursor.getBlob(0)));
    }

    final /* synthetic */ void zzc(List list, Cursor cursor) {
        list.add(this.zzaq(cursor.getBlob(0)));
    }

    final /* synthetic */ zzeql zza(Cursor cursor) {
        return this.zzaq(cursor.getBlob(0));
    }

    final /* synthetic */ zzeql zzb(Cursor cursor) {
        return this.zzaq(cursor.getBlob(0));
    }

    final /* synthetic */ void zzc(Cursor cursor) {
        this.zznjv = Math.max(this.zznjv, cursor.getInt(0));
    }

    final /* synthetic */ void zzd(Cursor cursor) {
        this.zznks = cursor.getInt(0);
        this.zznjx = zzfdh.zzay((byte[])cursor.getBlob(1));
    }
}

