/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfiy;
import com.google.android.gms.internal.zzfjb;
import com.google.android.gms.internal.zzfjc;
import com.google.android.gms.internal.zzfjg;
import com.google.android.gms.internal.zzfjh;
import com.google.android.gms.internal.zzfjn;
import com.google.android.gms.internal.zzfjx;
import com.google.android.gms.internal.zzfjy;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

final class zzfjk
implements zzfjb {
    private final zzfjy sink;
    private final boolean client;
    private final zzfjx zzqoe;
    private final zzfjg zzqof;
    private int zzqog;
    private boolean closed;

    zzfjk(zzfjy zzfjy2, boolean bl) {
        this.sink = zzfjy2;
        this.client = true;
        this.zzqoe = new zzfjx();
        this.zzqof = new zzfjg(this.zzqoe);
        this.zzqog = 16384;
    }

    @Override
    public final synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.sink.flush();
    }

    @Override
    public final synchronized void zza(zzfjn zzfjn2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.zzqog = zzfjn2.getMaxFrameSize(this.zzqog);
        this.frameHeader(0, 0, (byte)4, (byte)1);
        this.sink.flush();
    }

    @Override
    public final synchronized void connectionPreface() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!this.client) {
            return;
        }
        if (zzfjh.zzdan().isLoggable(Level.FINE)) {
            zzfjh.zzdan().logp(Level.FINE, "io.grpc.okhttp.internal.framed.Http2$Writer", "connectionPreface", String.format(">> CONNECTION %s", zzfjh.zzdeq().zzdfe()));
        }
        this.sink.zzbo(zzfjh.zzdeq().toByteArray());
        this.sink.flush();
    }

    @Override
    public final synchronized void zza(boolean bl, boolean bl2, int n, int n2, List<zzfjc> list) throws IOException {
        byte by;
        if (bl2) {
            throw new UnsupportedOperationException();
        }
        if (this.closed) {
            throw new IOException("closed");
        }
        List<zzfjc> list2 = list;
        int n3 = n;
        boolean bl3 = bl;
        zzfjk zzfjk2 = this;
        if (zzfjk2.closed) {
            throw new IOException("closed");
        }
        zzfjk2.zzqof.writeHeaders(list2);
        long l = zzfjk2.zzqoe.size();
        int n4 = (int)Math.min((long)zzfjk2.zzqog, l);
        byte by2 = by = l == (long)n4 ? (byte)4 : 0;
        if (bl3) {
            by = (byte)(by | 1);
        }
        zzfjk2.frameHeader(n3, n4, (byte)1, by);
        zzfjk2.sink.write(zzfjk2.zzqoe, n4);
        if (l > (long)n4) {
            zzfjk2.zzi(n3, l - (long)n4);
        }
    }

    private final void zzi(int n, long l) throws IOException {
        while (l > 0L) {
            int n2;
            this.frameHeader(n, n2, (byte)9, (l -= (long)(n2 = (int)Math.min((long)this.zzqog, l))) == 0L ? (byte)4 : 0);
            this.sink.write(this.zzqoe, n2);
        }
    }

    @Override
    public final synchronized void zza(int n, zzfiy zzfiy2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (zzfiy2.httpCode == -1) {
            throw new IllegalArgumentException();
        }
        this.frameHeader(n, 4, (byte)3, (byte)0);
        this.sink.zzne(zzfiy2.httpCode);
        this.sink.flush();
    }

    @Override
    public final int maxDataLength() {
        return this.zzqog;
    }

    @Override
    public final synchronized void data(boolean bl, int n, zzfjx zzfjx2, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        byte by = 0;
        if (bl) {
            by = 1;
        }
        int n3 = n2;
        zzfjx zzfjx3 = zzfjx2;
        byte by2 = by;
        int n4 = n;
        zzfjk zzfjk2 = this;
        zzfjk2.frameHeader(n4, n3, (byte)0, by2);
        if (n3 > 0) {
            zzfjk2.sink.write(zzfjx3, n3);
        }
    }

    @Override
    public final synchronized void zzb(zzfjn zzfjn2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n = zzfjn2.size() * 6;
        this.frameHeader(0, n, (byte)4, (byte)0);
        for (int i = 0; i < 10; ++i) {
            if (!zzfjn2.isSet(i)) continue;
            int n2 = i;
            if (n2 == 4) {
                n2 = 3;
            } else if (n2 == 7) {
                n2 = 4;
            }
            this.sink.zznf(n2);
            this.sink.zzne(zzfjn2.get(i));
        }
        this.sink.flush();
    }

    @Override
    public final synchronized void ping(boolean bl, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        byte by = bl ? (byte)1 : 0;
        this.frameHeader(0, 8, (byte)6, by);
        this.sink.zzne(n);
        this.sink.zzne(n2);
        this.sink.flush();
    }

    @Override
    public final synchronized void zza(int n, zzfiy zzfiy2, byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (zzfiy2.httpCode == -1) {
            throw zzfjh.zzn("errorCode.httpCode == -1", new Object[0]);
        }
        int n2 = 8 + byArray.length;
        this.frameHeader(0, n2, (byte)7, (byte)0);
        this.sink.zzne(n);
        this.sink.zzne(zzfiy2.httpCode);
        if (byArray.length > 0) {
            this.sink.zzbo(byArray);
        }
        this.sink.flush();
    }

    @Override
    public final synchronized void windowUpdate(int n, long l) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (l == 0L || l > Integer.MAX_VALUE) {
            throw zzfjh.zzn("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", new Object[]{l});
        }
        this.frameHeader(n, 4, (byte)8, (byte)0);
        this.sink.zzne((int)l);
        this.sink.flush();
    }

    @Override
    public final synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    private final void frameHeader(int n, int n2, byte by, byte by2) throws IOException {
        if (zzfjh.zzdan().isLoggable(Level.FINE)) {
            zzfjh.zzdan().logp(Level.FINE, "io.grpc.okhttp.internal.framed.Http2$Writer", "frameHeader", zzfjh.zza.zza(false, n, n2, by, by2));
        }
        if (n2 > this.zzqog) {
            throw zzfjh.zzn("FRAME_SIZE_ERROR length > %d: %d", new Object[]{this.zzqog, n2});
        }
        if ((n & Integer.MIN_VALUE) != 0) {
            throw zzfjh.zzn("reserved bit set: %s", new Object[]{n});
        }
        zzfjh.zzb(this.sink, n2);
        this.sink.zzng(by & 0xFF);
        this.sink.zzng(by2 & 0xFF);
        this.sink.zzne(n & Integer.MAX_VALUE);
    }
}

