/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzeln;
import com.google.android.gms.internal.zzeme;
import com.google.android.gms.internal.zzemg;
import com.google.android.gms.internal.zzemy;
import com.google.android.gms.internal.zzepq;
import com.google.android.gms.internal.zzeps;
import com.google.android.gms.internal.zzepv;
import com.google.android.gms.internal.zzeqc;
import com.google.android.gms.internal.zzeqf;
import com.google.android.gms.internal.zzeqp;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzetn;
import com.google.android.gms.internal.zzetp;
import com.google.android.gms.internal.zzety;
import com.google.android.gms.internal.zzeud;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentListenOptions;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.zzc;
import com.google.firebase.firestore.zzd;
import com.google.firebase.firestore.zzk;
import com.google.firebase.firestore.zzn;
import com.google.firebase.firestore.zzo;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;

public class DocumentReference {
    private final zzepv zznbt;
    private final FirebaseFirestore zznbu;

    DocumentReference(zzepv zzepv2, FirebaseFirestore firebaseFirestore) {
        this.zznbt = (zzepv)zzbq.checkNotNull((Object)zzepv2);
        this.zznbu = firebaseFirestore;
    }

    public static DocumentReference zza(zzeqc zzeqc2, FirebaseFirestore firebaseFirestore) {
        if (zzeqc2.length() % 2 != 0) {
            String string = ((zzepq)zzeqc2).zzcag();
            int n = zzeqc2.length();
            throw new IllegalArgumentException(new StringBuilder(106 + String.valueOf(string).length()).append("Invalid document reference. Document references must have an even number of segments, but ").append(string).append(" has ").append(n).toString());
        }
        return new DocumentReference(zzepv.zzb(zzeqc2), firebaseFirestore);
    }

    final zzepv zzbzr() {
        return this.zznbt;
    }

    @NonNull
    public FirebaseFirestore getFirestore() {
        return this.zznbu;
    }

    @NonNull
    public String getId() {
        return this.zznbt.zzcan().zzccn();
    }

    @NonNull
    public CollectionReference getParent() {
        return new CollectionReference((zzeqc)this.zznbt.zzcan().zzccm(), this.zznbu);
    }

    @NonNull
    public String getPath() {
        return ((zzepq)this.zznbt.zzcan()).zzcag();
    }

    @NonNull
    public CollectionReference collection(@NonNull String string) {
        zzbq.checkNotNull((Object)string, (Object)"Provided collection path must not be null.");
        return new CollectionReference(this.zznbt.zzcan().zzb(zzeqc.zzqi(string)), this.zznbu);
    }

    @NonNull
    public Task<Void> set(@NonNull Map<String, Object> map) {
        return this.set(map, SetOptions.zzndf);
    }

    @NonNull
    public Task<Void> set(@NonNull Map<String, Object> map, @NonNull SetOptions setOptions) {
        zzbq.checkNotNull(map, (Object)"Provided data must not be null.");
        zzbq.checkNotNull((Object)setOptions, (Object)"Provided options must not be null.");
        zzn zzn2 = setOptions.zzbzz() ? this.zznbu.zzbzy().zza(map, setOptions.zzcaa()) : this.zznbu.zzbzy().zzan(map);
        return this.zznbu.zzbzw().zzay(zzn2.zza(this.zznbt, zzeqp.zznmu)).continueWith(zzetp.zzdcu, zzeud.zzcgv());
    }

    @NonNull
    public Task<Void> set(@NonNull Object object) {
        this.zznbu.zzbzy();
        return this.set(zzk.zzcc(object), SetOptions.zzndf);
    }

    @NonNull
    public Task<Void> set(@NonNull Object object, @NonNull SetOptions setOptions) {
        this.zznbu.zzbzy();
        return this.set(zzk.zzcc(object), setOptions);
    }

    @NonNull
    public Task<Void> update(@NonNull Map<String, Object> map) {
        zzo zzo2 = this.zznbu.zzbzy().zzao(map);
        return this.zza(zzo2);
    }

    @NonNull
    public Task<Void> update(@NonNull String string, Object object, Object ... objectArray) {
        zzo zzo2 = this.zznbu.zzbzy().zzaw(zzeud.zza(1, string, object, objectArray));
        return this.zza(zzo2);
    }

    @NonNull
    public Task<Void> update(@NonNull FieldPath fieldPath, Object object, Object ... objectArray) {
        zzo zzo2 = this.zznbu.zzbzy().zzaw(zzeud.zza(1, fieldPath, object, objectArray));
        return this.zza(zzo2);
    }

    private final Task<Void> zza(@NonNull zzo zzo2) {
        return this.zznbu.zzbzw().zzay(zzo2.zza(this.zznbt, zzeqp.zzcn(true))).continueWith(zzetp.zzdcu, zzeud.zzcgv());
    }

    @NonNull
    public Task<Void> delete() {
        return this.zznbu.zzbzw().zzay(Collections.singletonList(new zzeqf(this.zznbt, zzeqp.zznmu))).continueWith(zzetp.zzdcu, zzeud.zzcgv());
    }

    @NonNull
    public Task<DocumentSnapshot> get() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzeln zzeln2 = new zzeln();
        new zzeln().zzncz = true;
        zzeln2.zzncy = true;
        zzeln2.zzney = true;
        ListenerRegistration listenerRegistration = this.zza(zzetp.zzdcu, zzeln2, null, new zzc(taskCompletionSource, taskCompletionSource2));
        taskCompletionSource2.setResult((Object)listenerRegistration);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(new DocumentListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(executor, new DocumentListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(activity, new DocumentListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull DocumentListenOptions documentListenOptions, @NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(zzetp.zznsk, documentListenOptions, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull DocumentListenOptions documentListenOptions, @NonNull EventListener<DocumentSnapshot> eventListener) {
        zzbq.checkNotNull((Object)executor, (Object)"Provided executor must not be null.");
        zzbq.checkNotNull((Object)documentListenOptions, (Object)"Provided listen options must not be null.");
        zzbq.checkNotNull(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(executor, DocumentReference.zza(documentListenOptions), null, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull DocumentListenOptions documentListenOptions, @NonNull EventListener<DocumentSnapshot> eventListener) {
        zzbq.checkNotNull((Object)activity, (Object)"Provided activity must not be null.");
        zzbq.checkNotNull((Object)documentListenOptions, (Object)"Provided listen options must not be null.");
        zzbq.checkNotNull(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzetp.zznsk, DocumentReference.zza(documentListenOptions), activity, eventListener);
    }

    private final ListenerRegistration zza(Executor executor, zzeln zzeln2, Activity activity, EventListener<DocumentSnapshot> eventListener) {
        zzetn<zzemy> zzetn2 = new zzetn<zzemy>(executor, new zzd(this, eventListener));
        zzeme zzeme2 = zzeme.zza(this.zznbt.zzcan());
        zzemg zzemg2 = this.zznbu.zzbzw().zza(zzeme2, zzeln2, zzetn2);
        return new zzety(this.zznbu.zzbzw(), zzemg2, activity, zzetn2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DocumentReference documentReference = (DocumentReference)object;
        return this.zznbt.equals(documentReference.zznbt) && this.zznbu.equals(documentReference.zznbu);
    }

    public int hashCode() {
        int n = this.zznbt.hashCode();
        return n * 31 + this.zznbu.hashCode();
    }

    private static zzeln zza(DocumentListenOptions documentListenOptions) {
        zzeln zzeln2 = new zzeln();
        new zzeln().zzncz = documentListenOptions.zznbs;
        zzeln2.zzncy = documentListenOptions.zznbs;
        zzeln2.zzney = false;
        return zzeln2;
    }

    final /* synthetic */ void zza(EventListener eventListener, zzemy zzemy2, FirebaseFirestoreException firebaseFirestoreException) {
        if (zzemy2 != null) {
            zzete.zzc(zzemy2.zzcbk().size() <= 1, "Too many documents returned on a document query", new Object[0]);
            zzeps zzeps2 = zzemy2.zzcbk().zzk(this.zznbt);
            DocumentSnapshot documentSnapshot = zzeps2 != null ? DocumentSnapshot.zza(this.zznbu, zzeps2, zzemy2.isFromCache()) : DocumentSnapshot.zza(this.zznbu, this.zznbt, zzemy2.isFromCache());
            eventListener.onEvent(documentSnapshot, null);
            return;
        }
        zzete.zzc(firebaseFirestoreException != null, "Got event without value or error set", new Object[0]);
        eventListener.onEvent(null, firebaseFirestoreException);
    }
}

