/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.firebase.firestore.zzg;

public final class FirebaseFirestoreSettings {
    private final String host;
    private final boolean zzncu;
    private final boolean zzmiu;

    private FirebaseFirestoreSettings(Builder builder) {
        this.host = builder.host;
        this.zzncu = builder.zzncu;
        this.zzmiu = builder.zzmiu;
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FirebaseFirestoreSettings firebaseFirestoreSettings = (FirebaseFirestoreSettings)object;
        return this.host.equals(firebaseFirestoreSettings.host) && this.zzncu == firebaseFirestoreSettings.zzncu && this.zzmiu == firebaseFirestoreSettings.zzmiu;
    }

    public final int hashCode() {
        int n = this.host.hashCode();
        n = n * 31 + (this.zzncu ? 1 : 0);
        return n * 31 + (this.zzmiu ? 1 : 0);
    }

    @NonNull
    public final String toString() {
        return zzbg.zzw((Object)this).zzg("host", (Object)this.host).zzg("sslEnabled", (Object)this.zzncu).zzg("persistenceEnabled", (Object)this.zzmiu).toString();
    }

    @NonNull
    public final String getHost() {
        return this.host;
    }

    public final boolean isSslEnabled() {
        return this.zzncu;
    }

    public final boolean isPersistenceEnabled() {
        return this.zzmiu;
    }

    /* synthetic */ FirebaseFirestoreSettings(Builder builder, zzg zzg2) {
        this(builder);
    }

    public static final class Builder {
        private String host;
        private boolean zzncu;
        private boolean zzmiu;

        public Builder() {
            this.host = "firestore.googleapis.com";
            this.zzncu = true;
            this.zzmiu = true;
        }

        public Builder(@NonNull FirebaseFirestoreSettings firebaseFirestoreSettings) {
            zzbq.checkNotNull((Object)firebaseFirestoreSettings, (Object)"Provided settings must not be null.");
            this.host = firebaseFirestoreSettings.host;
            this.zzncu = firebaseFirestoreSettings.zzncu;
            this.zzmiu = firebaseFirestoreSettings.zzmiu;
        }

        @NonNull
        public final Builder setHost(@NonNull String string) {
            this.host = (String)zzbq.checkNotNull((Object)string, (Object)"Provided host must not be null.");
            return this;
        }

        @NonNull
        public final Builder setSslEnabled(boolean bl) {
            this.zzncu = bl;
            return this;
        }

        @NonNull
        public final Builder setPersistenceEnabled(boolean bl) {
            this.zzmiu = bl;
            return this;
        }

        @NonNull
        public final FirebaseFirestoreSettings build() {
            if (!this.zzncu && this.host.equals("firestore.googleapis.com")) {
                throw new IllegalStateException("You can't set the 'sslEnabled' setting unless you also set a non-default 'host'.");
            }
            return new FirebaseFirestoreSettings(this, null);
        }
    }
}

