/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzelh;
import com.google.android.gms.internal.zzeln;
import com.google.android.gms.internal.zzelp;
import com.google.android.gms.internal.zzemc;
import com.google.android.gms.internal.zzemd;
import com.google.android.gms.internal.zzeme;
import com.google.android.gms.internal.zzemg;
import com.google.android.gms.internal.zzemi;
import com.google.android.gms.internal.zzemk;
import com.google.android.gms.internal.zzemy;
import com.google.android.gms.internal.zzepq;
import com.google.android.gms.internal.zzeps;
import com.google.android.gms.internal.zzepv;
import com.google.android.gms.internal.zzepz;
import com.google.android.gms.internal.zzeqc;
import com.google.android.gms.internal.zzeqw;
import com.google.android.gms.internal.zzerc;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzetn;
import com.google.android.gms.internal.zzetp;
import com.google.android.gms.internal.zzety;
import com.google.android.gms.internal.zzeud;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.QueryListenOptions;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.zzh;
import com.google.firebase.firestore.zzi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class Query {
    final zzeme zzncv;
    final FirebaseFirestore zznbu;

    Query(zzeme zzeme2, FirebaseFirestore firebaseFirestore) {
        this.zzncv = (zzeme)zzbq.checkNotNull((Object)zzeme2);
        this.zznbu = (FirebaseFirestore)zzbq.checkNotNull((Object)firebaseFirestore);
    }

    @NonNull
    public FirebaseFirestore getFirestore() {
        return this.zznbu;
    }

    private static void zza(zzepz zzepz2, zzepz zzepz3) {
        if (!zzepz2.equals(zzepz3)) {
            String string = ((zzepq)zzepz3).zzcag();
            throw new IllegalArgumentException(String.format("Invalid query. You have an inequality where filter (whereLessThan(), whereGreaterThan(), etc.) on field '%s' and so you must also have '%s' as your first orderBy() field, but your first orderBy() is currently on field '%s' instead.", string, string, ((zzepq)zzepz2).zzcag()));
        }
    }

    @NonNull
    public Query whereEqualTo(@NonNull String string, Object object) {
        return this.zza(FieldPath.zzpv(string), zzemk.zzngv, object);
    }

    @NonNull
    public Query whereEqualTo(@NonNull FieldPath fieldPath, Object object) {
        return this.zza(fieldPath, zzemk.zzngv, object);
    }

    @NonNull
    public Query whereLessThan(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zzpv(string), zzemk.zzngt, object);
    }

    @NonNull
    public Query whereLessThan(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzemk.zzngt, object);
    }

    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zzpv(string), zzemk.zzngu, object);
    }

    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzemk.zzngu, object);
    }

    @NonNull
    public Query whereGreaterThan(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zzpv(string), zzemk.zzngw, object);
    }

    @NonNull
    public Query whereGreaterThan(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzemk.zzngw, object);
    }

    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zzpv(string), zzemk.zzngx, object);
    }

    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzemk.zzngx, object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Query zza(@NonNull FieldPath fieldPath, zzemk zzemk2, Object object) {
        zzeqw zzeqw2;
        Object object2;
        block8: {
            block9: {
                zzbq.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
                zzbq.checkNotNull((Object)((Object)zzemk2), (Object)"Provided op must not be null.");
                if (!fieldPath.zzbzu().equals(zzepz.zznly)) break block9;
                if (object instanceof String) {
                    object2 = (String)object;
                    if (((String)object2).contains("/")) {
                        throw new IllegalArgumentException(new StringBuilder(127 + String.valueOf(object2).length()).append("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but '").append((String)object2).append("' contains a '/' character.").toString());
                    }
                    if (((String)object2).isEmpty()) {
                        throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but it was an empty string.");
                    }
                    zzeqc zzeqc2 = (zzeqc)this.zzncv.zzcan().zzqe((String)object2);
                    zzete.zzc(zzeqc2.length() % 2 == 0, "Path should be a document key", new Object[0]);
                    zzeqw2 = zzerc.zza(this.getFirestore().zzbzx(), zzepv.zzb(zzeqc2));
                    break block8;
                } else if (object instanceof DocumentReference) {
                    object2 = (DocumentReference)object;
                    zzeqw2 = zzerc.zza(this.getFirestore().zzbzx(), ((DocumentReference)object2).zzbzr());
                    break block8;
                } else {
                    String string;
                    String string2 = String.valueOf(zzeud.zzch(object));
                    if (string2.length() != 0) {
                        string = "Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: ".concat(string2);
                        throw new IllegalArgumentException(string);
                    }
                    string = new String("Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: ");
                    throw new IllegalArgumentException(string);
                }
            }
            zzeqw2 = this.zznbu.zzbzy().zzcb(object);
        }
        Object object3 = object2 = zzemi.zza(fieldPath.zzbzu(), zzemk2, zzeqw2);
        Query query = this;
        if (!(object3 instanceof zzemi)) return new Query(this.zzncv.zza((zzelp)object2), this.zznbu);
        if (!((zzemi)object3).zzcbc()) return new Query(this.zzncv.zza((zzelp)object2), this.zznbu);
        zzepz zzepz2 = query.zzncv.zzcau();
        zzepz zzepz3 = object3.zzcai();
        if (zzepz2 != null && !zzepz2.equals(zzepz3)) {
            throw new IllegalArgumentException(String.format("All where filters other than whereEqualTo() must be on the same field. But you have filters on '%s' and '%s'", ((zzepq)zzepz2).zzcag(), ((zzepq)zzepz3).zzcag()));
        }
        zzepz zzepz4 = query.zzncv.zzcat();
        if (zzepz4 == null) return new Query(this.zzncv.zza((zzelp)object2), this.zznbu);
        Query.zza(zzepz4, zzepz3);
        return new Query(this.zzncv.zza((zzelp)object2), this.zznbu);
    }

    @NonNull
    public Query orderBy(@NonNull String string) {
        return this.orderBy(FieldPath.zzpv(string), Direction.ASCENDING);
    }

    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath) {
        zzbq.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(fieldPath.zzbzu(), Direction.ASCENDING);
    }

    @NonNull
    public Query orderBy(@NonNull String string, @NonNull Direction direction) {
        return this.orderBy(FieldPath.zzpv(string), direction);
    }

    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath, @NonNull Direction direction) {
        zzbq.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(fieldPath.zzbzu(), direction);
    }

    private final Query zza(@NonNull zzepz zzepz2, @NonNull Direction direction) {
        zzbq.checkNotNull((Object)((Object)direction), (Object)"Provided direction must not be null.");
        if (this.zzncv.zzcar() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.startAt() or Query.startAfter() before calling Query.orderBy().");
        }
        if (this.zzncv.zzcas() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.endAt() or Query.endAfter() before calling Query.orderBy().");
        }
        zzepz zzepz3 = zzepz2;
        Query query = this;
        zzepz zzepz4 = query.zzncv.zzcau();
        if (query.zzncv.zzcat() == null && zzepz4 != null) {
            Query.zza(zzepz3, zzepz4);
        }
        zzemd zzemd2 = direction == Direction.ASCENDING ? zzemd.zznfx : zzemd.zznfy;
        return new Query(this.zzncv.zza(zzemc.zza(zzemd2, zzepz2)), this.zznbu);
    }

    @NonNull
    public Query limit(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(85).append("Invalid Query. Query limit (").append(l).append(") is invalid. Limit must be positive.").toString());
        }
        return new Query(this.zzncv.zzca(l), this.zznbu);
    }

    @NonNull
    public Query startAt(@NonNull DocumentSnapshot documentSnapshot) {
        zzelh zzelh2 = this.zza("startAt", documentSnapshot, true);
        return new Query(this.zzncv.zza(zzelh2), this.zznbu);
    }

    @NonNull
    public Query startAt(Object ... objectArray) {
        zzelh zzelh2 = this.zza("startAt", objectArray, true);
        return new Query(this.zzncv.zza(zzelh2), this.zznbu);
    }

    @NonNull
    public Query startAfter(@NonNull DocumentSnapshot documentSnapshot) {
        zzelh zzelh2 = this.zza("startAfter", documentSnapshot, false);
        return new Query(this.zzncv.zza(zzelh2), this.zznbu);
    }

    @NonNull
    public Query startAfter(Object ... objectArray) {
        zzelh zzelh2 = this.zza("startAfter", objectArray, false);
        return new Query(this.zzncv.zza(zzelh2), this.zznbu);
    }

    @NonNull
    public Query endBefore(@NonNull DocumentSnapshot documentSnapshot) {
        zzelh zzelh2 = this.zza("endBefore", documentSnapshot, true);
        return new Query(this.zzncv.zzb(zzelh2), this.zznbu);
    }

    @NonNull
    public Query endBefore(Object ... objectArray) {
        zzelh zzelh2 = this.zza("endBefore", objectArray, true);
        return new Query(this.zzncv.zzb(zzelh2), this.zznbu);
    }

    @NonNull
    public Query endAt(@NonNull DocumentSnapshot documentSnapshot) {
        zzelh zzelh2 = this.zza("endAt", documentSnapshot, false);
        return new Query(this.zzncv.zzb(zzelh2), this.zznbu);
    }

    @NonNull
    public Query endAt(Object ... objectArray) {
        zzelh zzelh2 = this.zza("endAt", objectArray, false);
        return new Query(this.zzncv.zzb(zzelh2), this.zznbu);
    }

    private final zzelh zza(String string, DocumentSnapshot documentSnapshot, boolean bl) {
        zzbq.checkNotNull((Object)documentSnapshot, (Object)"Provided snapshot must not be null.");
        if (!documentSnapshot.exists()) {
            throw new IllegalArgumentException(new StringBuilder(70 + String.valueOf(string).length()).append("Can't use a DocumentSnapshot for a document that doesn't exist for ").append(string).append("().").toString());
        }
        zzeps zzeps2 = documentSnapshot.zzbzs();
        ArrayList<zzeqw> arrayList = new ArrayList<zzeqw>();
        for (zzemc zzemc2 : this.zzncv.zzcaw()) {
            if (zzemc2.zzcai().equals(zzepz.zznly)) {
                arrayList.add(zzerc.zza(this.zznbu.zzbzx(), zzeps2.zzbzr()));
                continue;
            }
            zzeqw zzeqw2 = zzeps2.zzb(zzemc2.zzcai());
            if (zzeqw2 != null) {
                arrayList.add(zzeqw2);
                continue;
            }
            String string2 = String.valueOf(zzemc2.zzcai());
            throw new IllegalArgumentException(new StringBuilder(131 + String.valueOf(string2).length()).append("Invalid query. You are trying to start or end a query using a document for which the field '").append(string2).append("' (used as the orderBy) does not exist.").toString());
        }
        return new zzelh(arrayList, bl);
    }

    private final zzelh zza(String string, Object[] objectArray, boolean bl) {
        List<zzemc> list = this.zzncv.zzcav();
        if (objectArray.length > list.size()) {
            throw new IllegalArgumentException(new StringBuilder(121 + String.valueOf(string).length()).append("Too many arguments provided to ").append(string).append("(). The number of arguments must be less than or equal to the number of orderBy() clauses.").toString());
        }
        ArrayList<zzeqw> arrayList = new ArrayList<zzeqw>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2 = objectArray[i];
            if (list.get(i).zzcai().equals(zzepz.zznly)) {
                if (!(object2 instanceof String)) {
                    object = String.valueOf(object2);
                    throw new IllegalArgumentException(new StringBuilder(65 + String.valueOf(string).length() + String.valueOf(object).length()).append("Invalid query. Expected a string for document ID in ").append(string).append("(), but got ").append((String)object).append(".").toString());
                }
                object = (String)object2;
                if (((String)object).contains("/")) {
                    throw new IllegalArgumentException(new StringBuilder(53 + String.valueOf(object).length() + String.valueOf(string).length()).append("Invalid query. Document ID '").append((String)object).append("' contains a slash in ").append(string).append("().").toString());
                }
                zzepv zzepv2 = zzepv.zzb((zzeqc)this.zzncv.zzcan().zzqe((String)object));
                arrayList.add(zzerc.zza(this.zznbu.zzbzx(), zzepv2));
                continue;
            }
            object = this.zznbu.zzbzy().zzcb(object2);
            arrayList.add((zzeqw)object);
        }
        return new zzelh(arrayList, bl);
    }

    @NonNull
    public Task<QuerySnapshot> get() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzeln zzeln2 = new zzeln();
        new zzeln().zzncz = true;
        zzeln2.zzncy = true;
        zzeln2.zzney = true;
        ListenerRegistration listenerRegistration = this.zza(zzetp.zzdcu, zzeln2, null, new zzh(taskCompletionSource, taskCompletionSource2));
        taskCompletionSource2.setResult((Object)listenerRegistration);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(new QueryListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(executor, new QueryListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(activity, new QueryListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull QueryListenOptions queryListenOptions, @NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(zzetp.zznsk, queryListenOptions, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull QueryListenOptions queryListenOptions, @NonNull EventListener<QuerySnapshot> eventListener) {
        zzbq.checkNotNull((Object)executor, (Object)"Provided executor must not be null.");
        zzbq.checkNotNull((Object)queryListenOptions, (Object)"Provided listen options must not be null.");
        zzbq.checkNotNull(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(executor, Query.zza(queryListenOptions), null, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull QueryListenOptions queryListenOptions, @NonNull EventListener<QuerySnapshot> eventListener) {
        zzbq.checkNotNull((Object)activity, (Object)"Provided activity must not be null.");
        zzbq.checkNotNull((Object)queryListenOptions, (Object)"Provided listen options must not be null.");
        zzbq.checkNotNull(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzetp.zznsk, Query.zza(queryListenOptions), activity, eventListener);
    }

    private final ListenerRegistration zza(Executor executor, zzeln zzeln2, Activity activity, EventListener<QuerySnapshot> eventListener) {
        zzetn<zzemy> zzetn2 = new zzetn<zzemy>(executor, new zzi(this, eventListener));
        zzemg zzemg2 = this.zznbu.zzbzw().zza(this.zzncv, zzeln2, zzetn2);
        return new zzety(this.zznbu.zzbzw(), zzemg2, activity, zzetn2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Query query = (Query)object;
        return this.zzncv.equals(query.zzncv) && this.zznbu.equals(query.zznbu);
    }

    public int hashCode() {
        int n = this.zzncv.hashCode();
        return n * 31 + this.zznbu.hashCode();
    }

    private static zzeln zza(QueryListenOptions queryListenOptions) {
        zzeln zzeln2 = new zzeln();
        new zzeln().zzncz = queryListenOptions.zzncz;
        zzeln2.zzncy = queryListenOptions.zzncy;
        zzeln2.zzney = false;
        return zzeln2;
    }

    @Keep
    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

