/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzeps;
import com.google.android.gms.internal.zzeqa;
import com.google.android.gms.internal.zzeqb;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzetp;
import com.google.android.gms.internal.zzeud;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.zzj;
import com.google.firebase.firestore.zzk;
import com.google.firebase.firestore.zzn;
import com.google.firebase.firestore.zzo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class Transaction {
    private final zzemq zzndl;
    private final FirebaseFirestore zznbu;

    Transaction(zzemq zzemq2, FirebaseFirestore firebaseFirestore) {
        this.zzndl = (zzemq)zzbq.checkNotNull((Object)zzemq2);
        this.zznbu = (FirebaseFirestore)zzbq.checkNotNull((Object)firebaseFirestore);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Map<String, Object> map) {
        return this.set(documentReference, map, SetOptions.zzndf);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Map<String, Object> map, @NonNull SetOptions setOptions) {
        this.zznbu.zza(documentReference);
        zzbq.checkNotNull(map, (Object)"Provided data must not be null.");
        zzbq.checkNotNull((Object)setOptions, (Object)"Provided options must not be null.");
        zzn zzn2 = setOptions.zzbzz() ? this.zznbu.zzbzy().zza(map, setOptions.zzcaa()) : this.zznbu.zzbzy().zzan(map);
        this.zzndl.zza(documentReference.zzbzr(), zzn2);
        return this;
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Object object) {
        this.zznbu.zzbzy();
        return this.set(documentReference, zzk.zzcc(object), SetOptions.zzndf);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Object object, @NonNull SetOptions setOptions) {
        this.zznbu.zzbzy();
        return this.set(documentReference, zzk.zzcc(object), setOptions);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentReference, @NonNull Map<String, Object> map) {
        zzo zzo2 = this.zznbu.zzbzy().zzao(map);
        return this.zza(documentReference, zzo2);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentReference, @NonNull String string, @Nullable Object object, Object ... objectArray) {
        zzo zzo2 = this.zznbu.zzbzy().zzaw(zzeud.zza(1, string, object, objectArray));
        return this.zza(documentReference, zzo2);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentReference, @NonNull FieldPath fieldPath, @Nullable Object object, Object ... objectArray) {
        zzo zzo2 = this.zznbu.zzbzy().zzaw(zzeud.zza(1, fieldPath, object, objectArray));
        return this.zza(documentReference, zzo2);
    }

    private final Transaction zza(@NonNull DocumentReference documentReference, @NonNull zzo zzo2) {
        this.zznbu.zza(documentReference);
        this.zzndl.zza(documentReference.zzbzr(), zzo2);
        return this;
    }

    @NonNull
    public Transaction delete(@NonNull DocumentReference documentReference) {
        this.zznbu.zza(documentReference);
        this.zzndl.zzb(documentReference.zzbzr());
        return this;
    }

    @NonNull
    public DocumentSnapshot get(@NonNull DocumentReference documentReference) throws FirebaseFirestoreException {
        this.zznbu.zza(documentReference);
        try {
            DocumentReference documentReference2 = documentReference;
            Transaction transaction = this;
            return (DocumentSnapshot)Tasks.await((Task)transaction.zzndl.zzaz(Collections.singletonList(documentReference2.zzbzr())).continueWith(zzetp.zzdcu, (Continuation)new zzj(transaction)));
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            if (executionException.getCause() instanceof FirebaseFirestoreException) {
                throw (FirebaseFirestoreException)((Object)executionException2.getCause());
            }
            throw new RuntimeException(executionException2.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    final /* synthetic */ DocumentSnapshot zzh(Task task) throws Exception {
        if (!task.isSuccessful()) {
            throw task.getException();
        }
        List list = (List)task.getResult();
        if (list.size() != 1) {
            throw zzete.zzl("Mismatch in docs returned from document lookup.", new Object[0]);
        }
        zzeqa zzeqa2 = (zzeqa)list.get(0);
        if (zzeqa2 instanceof zzeqb) {
            return DocumentSnapshot.zza(this.zznbu, zzeqa2.zzbzr(), false);
        }
        return DocumentSnapshot.zza(this.zznbu, (zzeps)zzeqa2, false);
    }

    public static interface Function<TResult> {
        @Nullable
        public TResult apply(@NonNull Transaction var1) throws FirebaseFirestoreException;
    }
}

