/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdne;
import io.grpc.internal.zzbk;
import io.grpc.internal.zzbl;
import io.grpc.internal.zzee;
import io.grpc.internal.zzei;
import io.grpc.zzbp;
import io.grpc.zzbq;
import io.grpc.zzbr;
import java.net.InetAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

final class zzbj
extends zzbp {
    private static final Logger logger = Logger.getLogger(zzbj.class.getName());
    private static final boolean zzpvt = zzbj.zzdbt();
    private static boolean zzpvu = false;
    private zza zzpvv = new zzb();
    private final String authority;
    private final String host;
    private final int port;
    private final zzei<ScheduledExecutorService> zzpvw;
    private final zzei<ExecutorService> zzpvx;
    private boolean shutdown;
    private ScheduledExecutorService zzpvy;
    private ExecutorService executor;
    private ScheduledFuture<?> zzpvz;
    private boolean zzpwa;
    private zzbr zzpwb;
    private final Runnable zzpwc = new zzbk(this);
    private final Runnable zzpwd = new zzbl(this);

    zzbj(String string, String string2, io.grpc.zza zza2, zzei<ScheduledExecutorService> zzei2, zzei<ExecutorService> zzei3) {
        this.zzpvw = zzei2;
        this.zzpvx = zzei3;
        String string3 = String.valueOf(string2);
        URI uRI = URI.create(string3.length() != 0 ? "//".concat(string3) : new String("//"));
        this.authority = zzdne.zza(uRI.getAuthority(), "nameUri (%s) doesn't have an authority", (Object)uRI);
        this.host = zzdne.checkNotNull(uRI.getHost(), "host");
        if (uRI.getPort() == -1) {
            Integer n = zza2.zza(zzbq.zzpos);
            if (n != null) {
                this.port = n;
                return;
            }
            throw new IllegalArgumentException(new StringBuilder(69 + String.valueOf(string2).length()).append("name '").append(string2).append("' doesn't contain a port, and default port is not set in params").toString());
        }
        this.port = uRI.getPort();
    }

    @Override
    public final String zzczv() {
        return this.authority;
    }

    @Override
    public final synchronized void zza(zzbr zzbr2) {
        zzdne.zza(this.zzpwb == null, "already started");
        this.zzpvy = zzee.zza(this.zzpvw);
        this.executor = zzee.zza(this.zzpvx);
        this.zzpwb = zzdne.checkNotNull(zzbr2, "listener");
        this.zzdbs();
    }

    @Override
    public final synchronized void refresh() {
        zzdne.zza(this.zzpwb != null, "not started");
        this.zzdbs();
    }

    private final void zzdbs() {
        if (this.zzpwa || this.shutdown) {
            return;
        }
        this.executor.execute(this.zzpwc);
    }

    @Override
    public final synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.zzpvz != null) {
            this.zzpvz.cancel(false);
        }
        if (this.zzpvy != null) {
            this.zzpvy = zzee.zza(this.zzpvw, this.zzpvy);
        }
        if (this.executor != null) {
            this.executor = zzee.zza(this.zzpvx, this.executor);
        }
    }

    private static boolean zzdbt() {
        try {
            Class.forName("javax.naming.directory.InitialDirContext");
            Class.forName("com.sun.jndi.dns.DnsContextFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "jndiAvailable", "Unable to find JNDI DNS resolver, skipping", classNotFoundException);
            return false;
        }
        return true;
    }

    static /* synthetic */ ScheduledFuture zza(zzbj zzbj2) {
        return zzbj2.zzpvz;
    }

    static /* synthetic */ ScheduledFuture zza(zzbj zzbj2, ScheduledFuture scheduledFuture) {
        zzbj2.zzpvz = scheduledFuture;
        return zzbj2.zzpvz;
    }

    static /* synthetic */ boolean zzb(zzbj zzbj2) {
        return zzbj2.shutdown;
    }

    static /* synthetic */ zzbr zzc(zzbj zzbj2) {
        return zzbj2.zzpwb;
    }

    static /* synthetic */ boolean zza(zzbj zzbj2, boolean bl) {
        zzbj2.zzpwa = bl;
        return zzbj2.zzpwa;
    }

    static /* synthetic */ String zzd(zzbj zzbj2) {
        return zzbj2.host;
    }

    static /* synthetic */ int zze(zzbj zzbj2) {
        return zzbj2.port;
    }

    static /* synthetic */ zza zzf(zzbj zzbj2) {
        return zzbj2.zzpvv;
    }

    static /* synthetic */ Runnable zzg(zzbj zzbj2) {
        return zzbj2.zzpwd;
    }

    static /* synthetic */ ScheduledExecutorService zzh(zzbj zzbj2) {
        return zzbj2.zzpvy;
    }

    static /* synthetic */ Runnable zzi(zzbj zzbj2) {
        return zzbj2.zzpwc;
    }

    static /* synthetic */ ExecutorService zzj(zzbj zzbj2) {
        return zzbj2.executor;
    }

    static final class zzb
    extends zza {
        zzb() {
        }

        @Override
        final zzc zztt(String string) throws Exception {
            return new zzc(Arrays.asList(InetAddress.getAllByName(string)), Collections.emptyList());
        }
    }

    static final class zzc {
        final List<InetAddress> zzpwf;
        private List<String> zzpwg;

        zzc(List<InetAddress> list, List<String> list2) {
            this.zzpwf = Collections.unmodifiableList(zzdne.checkNotNull(list, "addresses"));
            this.zzpwg = Collections.unmodifiableList(zzdne.checkNotNull(list2, "txtRecords"));
        }
    }

    static abstract class zza {
        zza() {
        }

        abstract zzc zztt(String var1) throws Exception;
    }
}

