/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdne;
import com.google.android.gms.internal.zzdnf;
import com.google.android.gms.internal.zzdni;
import com.google.android.gms.internal.zzdnl;
import com.google.android.gms.internal.zzdoi;
import com.google.android.gms.internal.zzdol;
import io.grpc.InternalMetadata;
import io.grpc.internal.zzab;
import io.grpc.internal.zzbp;
import io.grpc.internal.zzbv;
import io.grpc.internal.zzbw;
import io.grpc.internal.zzbx;
import io.grpc.internal.zzby;
import io.grpc.internal.zzei;
import io.grpc.internal.zzg;
import io.grpc.zzas;
import io.grpc.zzau;
import io.grpc.zzaz;
import io.grpc.zzbe;
import io.grpc.zzbh;
import io.grpc.zzcd;
import io.grpc.zzcf;
import io.grpc.zzp;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class zzbu {
    private static Charset US_ASCII;
    public static final boolean zzpwo;
    public static final zzbh<Long> zzpwp;
    public static final zzbh<String> zzpwq;
    public static final zzbh<byte[]> zzpwr;
    public static final zzbh<String> zzpws;
    public static final zzbh<String> zzpwt;
    private static zzdnf zzpwu;
    private static final String zzpwv;
    private static long zzpww;
    public static final long zzpwx;
    private static long zzpwy;
    private static long zzpwz;
    public static final zzei<ExecutorService> zzpxa;
    public static final zzei<ScheduledExecutorService> zzpxb;
    public static final zzdnl<zzdni> zzpxc;

    public static zzcd zzmn(int n) {
        zzcf zzcf2;
        int n2 = n;
        if (n2 >= 100 && n2 < 200) {
            zzcf2 = zzcf.zzpqo;
        } else {
            switch (n2) {
                case 400: 
                case 431: {
                    zzcf2 = zzcf.zzpqo;
                    break;
                }
                case 401: {
                    zzcf2 = zzcf.zzpqr;
                    break;
                }
                case 403: {
                    zzcf2 = zzcf.zzpqi;
                    break;
                }
                case 404: {
                    zzcf2 = zzcf.zzpqn;
                    break;
                }
                case 429: 
                case 502: 
                case 503: 
                case 504: {
                    zzcf2 = zzcf.zzpqp;
                    break;
                }
                default: {
                    zzcf2 = zzcf.zzpqd;
                }
            }
        }
        return zzcf2.zzdaf().zztq(new StringBuilder(28).append("HTTP status code ").append(n).toString());
    }

    public static boolean zztu(String string) {
        if (string == null) {
            return false;
        }
        if (16 > string.length()) {
            return false;
        }
        if (!(string = string.toLowerCase()).startsWith("application/grpc")) {
            return false;
        }
        if (string.length() == 16) {
            return true;
        }
        char c = string.charAt(16);
        return c == '+' || c == ';';
    }

    public static String zzbs(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(' ');
        }
        stringBuilder.append("grpc-java-");
        stringBuilder.append(string);
        stringBuilder.append(zzpwv);
        return stringBuilder.toString();
    }

    public static URI zztv(String string) {
        URI uRI;
        zzdne.checkNotNull(string, "authority");
        try {
            uRI = new URI(null, string, null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "Invalid authority: ".concat(string2) : new String("Invalid authority: "), uRISyntaxException);
        }
        return uRI;
    }

    public static ThreadFactory zzi(String string, boolean bl) {
        ThreadFactory threadFactory = zzdoi.zzblb();
        if (zzpwo) {
            return threadFactory;
        }
        return new zzdol().zza(threadFactory).zzbz(true).zznx(string).zzbld();
    }

    static zzab zza(zzas zzas2, boolean bl) {
        zzau zzau2 = zzas2.zzcze();
        zzab zzab2 = zzau2 != null ? ((zzg)zzau2).zzdba() : null;
        if (zzab2 != null) {
            zzp zzp2 = zzas2.zzczf();
            if (zzp2 == null) {
                return zzab2;
            }
            return new zzby(zzab2, zzp2);
        }
        if (!zzas2.zzcyr().zzdac() && !bl) {
            return new zzbp(zzas2.zzcyr());
        }
        return null;
    }

    private zzbu() {
    }

    static {
        String string;
        US_ASCII = Charset.forName("US-ASCII");
        zzpwo = System.getProperty("com.google.appengine.runtime.environment") != null && "1.7".equals(System.getProperty("java.specification.version"));
        zzpwp = zzbh.zza("grpc-timeout", new zzc());
        zzpwq = zzbh.zza("grpc-encoding", zzaz.zzpnw);
        zzpwr = InternalMetadata.zza("grpc-accept-encoding", new zza(null));
        zzpws = zzbh.zza("content-type", zzaz.zzpnw);
        zzpwt = zzbh.zza("user-agent", zzaz.zzpnw);
        zzpwu = zzdnf.zze(',').zzbko();
        String string2 = zzbu.class.getPackage().getImplementationVersion();
        if (string2 != null) {
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "/".concat(string3) : new String("/");
        } else {
            string = "";
        }
        zzpwv = string;
        zzpww = TimeUnit.MINUTES.toNanos(1L);
        zzpwx = TimeUnit.SECONDS.toNanos(20L);
        zzpwy = TimeUnit.HOURS.toNanos(2L);
        zzpwz = TimeUnit.SECONDS.toNanos(20L);
        zzpxa = new zzbv();
        zzpxb = new zzbw();
        zzpxc = new zzbx();
    }

    static final class zzc
    implements zzbe<Long> {
        zzc() {
        }

        @Override
        public final /* synthetic */ Object zzto(String string) {
            String string2 = string;
            zzdne.checkArgument(string2.length() > 0, "empty timeout");
            zzdne.checkArgument(string2.length() <= 9, "bad timeout format");
            long l = Long.parseLong(string2.substring(0, string2.length() - 1));
            char c = string2.charAt(string2.length() - 1);
            switch (c) {
                case 'n': {
                    return l;
                }
                case 'u': {
                    return TimeUnit.MICROSECONDS.toNanos(l);
                }
                case 'm': {
                    return TimeUnit.MILLISECONDS.toNanos(l);
                }
                case 'S': {
                    return TimeUnit.SECONDS.toNanos(l);
                }
                case 'M': {
                    return TimeUnit.MINUTES.toNanos(l);
                }
                case 'H': {
                    return TimeUnit.HOURS.toNanos(l);
                }
            }
            throw new IllegalArgumentException(String.format("Invalid timeout unit: %s", Character.valueOf(c)));
        }

        @Override
        public final /* synthetic */ String zzcq(Object object) {
            Long l = (Long)object;
            TimeUnit timeUnit = TimeUnit.NANOSECONDS;
            if (l < 0L) {
                throw new IllegalArgumentException("Timeout too small");
            }
            if (l < 100000000L) {
                String string = String.valueOf(l);
                return new StringBuilder(1 + String.valueOf(string).length()).append(string).append("n").toString();
            }
            if (l < 100000000000L) {
                long l2 = timeUnit.toMicros(l);
                return new StringBuilder(21).append(l2).append("u").toString();
            }
            if (l < 100000000000000L) {
                long l3 = timeUnit.toMillis(l);
                return new StringBuilder(21).append(l3).append("m").toString();
            }
            if (l < 100000000000000000L) {
                long l4 = timeUnit.toSeconds(l);
                return new StringBuilder(21).append(l4).append("S").toString();
            }
            if (l < 6000000000000000000L) {
                long l5 = timeUnit.toMinutes(l);
                return new StringBuilder(21).append(l5).append("M").toString();
            }
            long l6 = timeUnit.toHours(l);
            return new StringBuilder(21).append(l6).append("H").toString();
        }
    }

    public static final class zzb
    extends Enum<zzb> {
        private static /* enum */ zzb zzpxe = new zzb(0, zzcd.zzppx);
        private static /* enum */ zzb zzpxf = new zzb(1, zzcd.zzppw);
        private static /* enum */ zzb zzpxg = new zzb(2, zzcd.zzppw);
        private static /* enum */ zzb zzpxh = new zzb(3, zzcd.zzppw);
        private static /* enum */ zzb zzpxi = new zzb(4, zzcd.zzppw);
        private static /* enum */ zzb zzpxj = new zzb(5, zzcd.zzppw);
        private static /* enum */ zzb zzpxk = new zzb(6, zzcd.zzppw);
        private static /* enum */ zzb zzpxl = new zzb(7, zzcd.zzppx);
        private static /* enum */ zzb zzpxm = new zzb(8, zzcd.zzppj);
        private static /* enum */ zzb zzpxn = new zzb(9, zzcd.zzppw);
        private static /* enum */ zzb zzpxo = new zzb(10, zzcd.zzppw);
        private static /* enum */ zzb zzpxp = new zzb(11, zzcd.zzppr.zztq("Bandwidth exhausted"));
        private static /* enum */ zzb zzpxq = new zzb(12, zzcd.zzppp.zztq("Permission denied as protocol is not secure enough to call"));
        private static /* enum */ zzb zzpxr = new zzb(13, zzcd.zzppk);
        private static final zzb[] zzpxs;
        private final int code;
        private final zzcd zzpmp;
        private static final /* synthetic */ zzb[] zzpxt;

        public static zzb[] values() {
            return (zzb[])zzpxt.clone();
        }

        private zzb(int n2, zzcd zzcd2) {
            this.code = n2;
            String string2 = String.valueOf(this.name());
            this.zzpmp = zzcd2.zztr(string2.length() != 0 ? "HTTP/2 error code: ".concat(string2) : new String("HTTP/2 error code: "));
        }

        public static zzcd zzdn(long l) {
            long l2 = l;
            zzb zzb2 = l2 >= (long)zzpxs.length || l2 < 0L ? null : zzpxs[(int)l2];
            if (zzb2 == null) {
                return zzcd.zzmf(zzb.zzpxg.zzpmp.zzdab().value()).zztq(new StringBuilder(52).append("Unrecognized HTTP/2 error code: ").append(l).toString());
            }
            return zzb2.zzpmp;
        }

        static {
            zzpxt = new zzb[]{zzpxe, zzpxf, zzpxg, zzpxh, zzpxi, zzpxj, zzpxk, zzpxl, zzpxm, zzpxn, zzpxo, zzpxp, zzpxq, zzpxr};
            zzb[] zzbArray = zzb.values();
            zzb[] zzbArray2 = new zzb[zzbArray[zzbArray.length - 1].code + 1];
            zzb[] zzbArray3 = zzbArray;
            int n = zzbArray.length;
            for (int i = 0; i < n; ++i) {
                zzb zzb2 = zzbArray3[i];
                int n2 = zzb2.code;
                zzbArray2[n2] = zzb2;
            }
            zzpxs = zzbArray2;
        }
    }

    static final class zza
    implements InternalMetadata.TrustedAsciiMarshaller<byte[]> {
        private zza() {
        }

        @Override
        public final /* synthetic */ Object zzbj(byte[] byArray) {
            return byArray;
        }

        @Override
        public final /* synthetic */ byte[] zzcr(Object object) {
            return (byte[])object;
        }

        /* synthetic */ zza(zzbv zzbv2) {
            this();
        }
    }
}

