/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdne;
import io.grpc.internal.zzae;
import io.grpc.internal.zzd;
import io.grpc.internal.zzdm;
import io.grpc.internal.zzdn;
import io.grpc.internal.zzdo;
import io.grpc.internal.zzdy;
import io.grpc.internal.zzdz;
import io.grpc.internal.zzel;
import io.grpc.zzad;
import io.grpc.zzcd;
import io.grpc.zzs;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public final class zzdk
implements Closeable {
    private final zzdm zzqbn;
    private int zzpsb;
    private final zzel zzprc;
    private final String zzqbo;
    private zzad zzpnh;
    private zzdo zzqbp = zzdo.zzqcd;
    private int zzqbq = 5;
    private boolean zzqbr;
    private boolean zzqbs;
    private zzae zzqbt;
    private zzae zzqbu = new zzae();
    private long zzqbv;
    private boolean zzqbw = true;
    private boolean zzqbx = false;

    public zzdk(zzdm zzdm2, zzad zzad2, int n, zzel zzel2, String string) {
        this.zzqbn = zzdne.checkNotNull(zzdm2, "sink");
        this.zzpnh = zzdne.checkNotNull(zzad2, "decompressor");
        this.zzpsb = n;
        this.zzprc = zzdne.checkNotNull(zzel2, "statsTraceCtx");
        this.zzqbo = string;
    }

    final void zzmh(int n) {
        this.zzpsb = n;
    }

    public final void zza(zzad zzad2) {
        this.zzpnh = zzdne.checkNotNull(zzad2, "Can't pass an empty decompressor");
    }

    public final void zzmc(int n) {
        zzdne.checkArgument(n > 0, "numMessages must be > 0");
        if (this.isClosed()) {
            return;
        }
        this.zzqbv += (long)n;
        this.zzdcs();
    }

    public final void zza(zzdy zzdy2, boolean bl) {
        zzdne.checkNotNull(zzdy2, "data");
        boolean bl2 = true;
        try {
            zzdne.zza(!this.isClosed(), "MessageDeframer is already closed");
            zzdne.zza(!this.zzqbs, "Past end of stream");
            this.zzqbu.zzb(zzdy2);
            bl2 = false;
            this.zzqbs = false;
            this.zzdcs();
            return;
        }
        catch (Throwable throwable) {
            if (bl2) {
                zzdy2.close();
            }
            throw throwable;
        }
    }

    public final boolean zzdcr() {
        return this.zzqbw;
    }

    @Override
    public final void close() {
        try {
            if (this.zzqbu != null) {
                ((zzd)this.zzqbu).close();
            }
            if (this.zzqbt != null) {
                ((zzd)this.zzqbt).close();
            }
            return;
        }
        finally {
            this.zzqbu = null;
            this.zzqbt = null;
        }
    }

    public final boolean isClosed() {
        return this.zzqbu == null;
    }

    private final void zzdcs() {
        if (this.zzqbx) {
            return;
        }
        this.zzqbx = true;
        try {
            boolean bl;
            block8: while (this.zzqbv > 0L && this.zzdct()) {
                switch (this.zzqbp) {
                    case zzqcd: {
                        zzdk zzdk2 = this;
                        int n = zzdk2.zzqbt.readUnsignedByte();
                        if ((n & 0xFE) != 0) {
                            throw zzcd.zzppw.zztq(String.valueOf(zzdk2.zzqbo).concat(": Frame header malformed: reserved bits not zero")).zzdad();
                        }
                        zzdk2.zzqbr = (n & 1) != 0;
                        Closeable closeable = zzdk2.zzqbt;
                        ((zzd)closeable).zzmi(4);
                        int n2 = closeable.readUnsignedByte();
                        int n3 = closeable.readUnsignedByte();
                        int n4 = closeable.readUnsignedByte();
                        int n5 = closeable.readUnsignedByte();
                        zzdk2.zzqbq = n2 << 24 | n3 << 16 | n4 << 8 | n5;
                        if (zzdk2.zzqbq < 0 || zzdk2.zzqbq > zzdk2.zzpsb) {
                            throw zzcd.zzppr.zztq(String.format("%s: Frame size %d exceeds maximum: %d. ", zzdk2.zzqbo, zzdk2.zzqbq, zzdk2.zzpsb)).zzdad();
                        }
                        zzdk2.zzprc.zzdai();
                        zzdk2.zzqbp = zzdo.zzqce;
                        continue block8;
                    }
                    case zzqce: {
                        InputStream inputStream;
                        Closeable closeable;
                        zzdk zzdk2 = this;
                        if (zzdk2.zzqbr) {
                            inputStream = zzdk2.zzdcu();
                        } else {
                            closeable = zzdk2;
                            ((zzdk)closeable).zzprc.zzdm(((zzdk)closeable).zzqbt.zzdbo());
                            inputStream = zzdz.zzc(((zzdk)closeable).zzqbt, true);
                        }
                        InputStream inputStream2 = inputStream;
                        zzdk2.zzqbt = null;
                        zzdk2.zzqbn.zzo(inputStream2);
                        zzdk2.zzqbp = zzdo.zzqcd;
                        zzdk2.zzqbq = 5;
                        --this.zzqbv;
                        continue block8;
                    }
                }
                String string = String.valueOf((Object)this.zzqbp);
                throw new AssertionError((Object)new StringBuilder(15 + String.valueOf(string).length()).append("Invalid state: ").append(string).toString());
            }
            boolean bl2 = bl = this.zzqbu.zzdbo() == 0;
            if (this.zzqbs && bl) {
                if (!(this.zzqbt != null && this.zzqbt.zzdbo() > 0)) {
                    this.zzqbn.zzdap();
                    this.zzqbw = false;
                    return;
                }
                throw zzcd.zzppw.zztq(String.valueOf(this.zzqbo).concat(": Encountered end-of-stream mid-frame")).zzdad();
            }
            boolean bl3 = this.zzqbw;
            this.zzqbw = bl;
            if (bl && !bl3) {
                this.zzqbn.zzdao();
            }
            return;
        }
        finally {
            this.zzqbx = false;
        }
    }

    private final boolean zzdct() {
        int n = 0;
        try {
            int n2;
            if (this.zzqbt == null) {
                this.zzqbt = new zzae();
            }
            while ((n2 = this.zzqbq - this.zzqbt.zzdbo()) > 0) {
                if (this.zzqbu.zzdbo() == 0) {
                    return false;
                }
                int n3 = Math.min(n2, this.zzqbu.zzdbo());
                n += n3;
                this.zzqbt.zzb((zzae)this.zzqbu.zzmm(n3));
            }
            return true;
        }
        finally {
            if (n > 0) {
                this.zzqbn.zzmo(n);
                if (this.zzqbp == zzdo.zzqce) {
                    this.zzprc.zzdl(n);
                }
            }
        }
    }

    private final InputStream zzdcu() {
        if (this.zzpnh == zzs.zzpmf) {
            throw zzcd.zzppw.zztq(String.valueOf(this.zzqbo).concat(": Can't decode compressed frame as compression not configured.")).zzdad();
        }
        try {
            InputStream inputStream = this.zzpnh.zzj(zzdz.zzc(this.zzqbt, true));
            return new zzdn(inputStream, this.zzpsb, this.zzprc, this.zzqbo);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

