/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.android.gms.internal.zzdne;
import com.google.android.gms.internal.zzdni;
import com.google.android.gms.internal.zzdnn;
import com.google.android.gms.internal.zzdok;
import com.google.android.gms.internal.zzfio;
import com.google.android.gms.internal.zzfiy;
import com.google.android.gms.internal.zzfiz;
import com.google.android.gms.internal.zzfja;
import com.google.android.gms.internal.zzfjc;
import com.google.android.gms.internal.zzfjn;
import com.google.android.gms.internal.zzfjx;
import com.google.android.gms.internal.zzfjy;
import com.google.android.gms.internal.zzfjz;
import com.google.android.gms.internal.zzfka;
import com.google.android.gms.internal.zzfkd;
import com.google.android.gms.internal.zzfkn;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.internal.http.StatusLine;
import io.grpc.internal.zzac;
import io.grpc.internal.zzai;
import io.grpc.internal.zzbu;
import io.grpc.internal.zzcb;
import io.grpc.internal.zzcl;
import io.grpc.internal.zzco;
import io.grpc.internal.zzcv;
import io.grpc.internal.zzdj;
import io.grpc.internal.zzed;
import io.grpc.internal.zzee;
import io.grpc.internal.zzel;
import io.grpc.okhttp.zzag;
import io.grpc.okhttp.zzu;
import io.grpc.okhttp.zzz;
import io.grpc.zzaz;
import io.grpc.zzbk;
import io.grpc.zzbo;
import io.grpc.zzcd;
import io.grpc.zzcf;
import io.grpc.zzci;
import io.grpc.zzg;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

class zzy
implements zzai {
    private static final Map<zzfiy, zzcd> zzqfs;
    private static final Logger zzlnr;
    private static final zzu[] zzqft;
    private final InetSocketAddress zzqfu;
    private final String zzqfv;
    private final String zzmiw;
    private final Random random = new Random();
    private final zzdnn zzlmm;
    private zzdj zzqfw;
    private io.grpc.okhttp.zza zzqfq;
    private zzag zzqfr;
    private final Object lock = new Object();
    private final zzcv zzpyi = zzcv.zztw(this.getClass().getName());
    private int nextStreamId;
    private final Map<Integer, zzu> streams = new HashMap<Integer, zzu>();
    private final Executor zzloa;
    private final zzed zzqfx;
    private final int zzqbz;
    private int zzqfy;
    private zza zzqfz;
    private zzcd zzqga;
    private boolean zzqgb;
    private zzcb zzqgc;
    private boolean zzmnk;
    private boolean zzqgd;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private Socket socket;
    private int zzqge = 0;
    private LinkedList<zzu> zzqgf = new LinkedList();
    private final zzfio zzqgg;
    private ScheduledExecutorService zzpzf;
    private zzcl zzqgh;
    private boolean zzqfa;
    private long zzqev;
    private long zzqew;
    private boolean zzqfc;
    private final InetSocketAddress zzqgi;
    private final String zzqgj;
    private final String zzqgk;
    private final Runnable zzqgl;
    Runnable zzqgm;
    zzdok<Void> zzqgn;

    zzy(InetSocketAddress inetSocketAddress, String string, String string2, Executor executor, SSLSocketFactory sSLSocketFactory, HostnameVerifier hostnameVerifier, zzfio zzfio2, int n, InetSocketAddress inetSocketAddress2, String string3, String string4, Runnable runnable) {
        this.zzqfu = zzdne.checkNotNull(inetSocketAddress, "address");
        this.zzqfv = string;
        this.zzqbz = n;
        this.zzloa = zzdne.checkNotNull(executor, "executor");
        this.zzqfx = new zzed(executor);
        this.nextStreamId = 3;
        this.sslSocketFactory = sSLSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.zzqgg = zzdne.checkNotNull(zzfio2, "connectionSpec");
        this.zzlmm = zzdnn.zzbkw();
        this.zzmiw = zzbu.zzbs("okhttp", string2);
        this.zzqgi = inetSocketAddress2;
        this.zzqgj = null;
        this.zzqgk = null;
        this.zzqgl = zzdne.checkNotNull(runnable, "tooManyPingsRunnable");
    }

    final void zza(boolean bl, long l, long l2, boolean bl2) {
        this.zzqfa = true;
        this.zzqev = l;
        this.zzqew = l2;
        this.zzqfc = bl2;
    }

    private final boolean zzddj() {
        return this.zzqfu == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzac zzac2, Executor executor) {
        boolean bl;
        zzcb zzcb2;
        zzdne.checkState(this.zzqfq != null);
        long l = 0L;
        Object object = this.lock;
        synchronized (object) {
            if (this.zzmnk) {
                zzcb.zza(zzac2, executor, this.zzddr());
                return;
            }
            if (this.zzqgc != null) {
                zzcb2 = this.zzqgc;
                bl = false;
            } else {
                l = this.random.nextLong();
                zzcb2 = this.zzqgc = new zzcb(l, zzdni.zza(this.zzlmm));
                bl = true;
            }
        }
        if (bl) {
            this.zzqfq.ping(false, (int)(l >>> 32), (int)l);
        }
        zzcb2.zzb(zzac2, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzh(zzu zzu2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzqga != null) {
                zzu2.zzdde().zza(this.zzqga, true, new zzaz());
            } else if (this.streams.size() >= this.zzqge) {
                this.zzqgf.add(zzu2);
                this.zzddq();
            } else {
                this.zzi(zzu2);
            }
            return;
        }
    }

    private final void zzi(zzu zzu2) {
        zzdne.zza(zzu2.zzddf() == -1, "StreamId already assigned");
        this.streams.put(this.nextStreamId, zzu2);
        this.zzddq();
        zzu2.zzdde().zzmq(this.nextStreamId);
        if (zzu2.zzczr() != zzbo.zzpom && zzu2.zzczr() != zzbo.zzpoo) {
            this.zzqfq.flush();
        }
        if (this.nextStreamId >= 0x7FFFFFFD) {
            this.nextStreamId = Integer.MAX_VALUE;
            this.zza(Integer.MAX_VALUE, zzfiy.zzqmw, zzcd.zzppx.zztq("Stream ids exhausted"));
            return;
        }
        this.nextStreamId += 2;
    }

    private final boolean zzddk() {
        boolean bl = false;
        while (!this.zzqgf.isEmpty() && this.streams.size() < this.zzqge) {
            zzu zzu2 = this.zzqgf.poll();
            this.zzi(zzu2);
            bl = true;
        }
        return bl;
    }

    final void zzj(zzu zzu2) {
        this.zzqgf.remove(zzu2);
        this.zzddp();
    }

    @Override
    public final Runnable zza(zzdj zzdj2) {
        this.zzqfw = zzdne.checkNotNull(zzdj2, "listener");
        if (this.zzqfa) {
            this.zzpzf = zzee.zza(zzbu.zzpxb);
            this.zzqgh = new zzcl(new zzco(this), this.zzpzf, this.zzqev, this.zzqew, this.zzqfc);
            this.zzqgh.zzdcf();
        }
        this.zzqfq = new io.grpc.okhttp.zza(this, this.zzqfx);
        this.zzqfr = new zzag(this, this.zzqfq);
        this.zzqfx.execute(new zzz(this));
        return null;
    }

    private final Socket zza(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, String string2) throws IOException, zzci {
        try {
            Socket socket = new Socket(inetSocketAddress2.getAddress(), inetSocketAddress2.getPort());
            socket.setTcpNoDelay(true);
            zzfkn zzfkn2 = zzfkd.zzb(socket);
            zzfjy zzfjy2 = zzfkd.zza(zzfkd.zza(socket));
            String string3 = string2;
            String string4 = string;
            InetSocketAddress inetSocketAddress3 = inetSocketAddress;
            zzy zzy2 = this;
            HttpUrl httpUrl = new HttpUrl.Builder().scheme("https").host(inetSocketAddress3.getHostName()).port(inetSocketAddress3.getPort()).build();
            String string5 = httpUrl.host();
            int n = httpUrl.port();
            Request.Builder builder = new Request.Builder().url(httpUrl).header("Host", new StringBuilder(12 + String.valueOf(string5).length()).append(string5).append(":").append(n).toString()).header("User-Agent", zzy2.zzmiw);
            if (string4 != null && string3 != null) {
                builder.header("Proxy-Authorization", Credentials.basic((String)string4, (String)string3));
            }
            Request request = builder.build();
            HttpUrl httpUrl2 = request.httpUrl();
            String string6 = String.format("CONNECT %s:%d HTTP/1.1", httpUrl2.host(), httpUrl2.port());
            zzfjy2.zzuc(string6).zzuc("\r\n");
            int n2 = request.headers().size();
            for (int i = 0; i < n2; ++i) {
                zzfjy2.zzuc(request.headers().name(i)).zzuc(": ").zzuc(request.headers().value(i)).zzuc("\r\n");
            }
            zzfjy2.zzuc("\r\n");
            zzfjy2.flush();
            StatusLine statusLine = StatusLine.parse((String)zzy.zza(zzfkn2));
            while (!zzy.zza(zzfkn2).equals("")) {
            }
            if (statusLine.code < 200 || statusLine.code >= 300) {
                zzfjx zzfjx2 = new zzfjx();
                try {
                    socket.shutdownOutput();
                    zzfkn2.read(zzfjx2, 1024L);
                }
                catch (IOException iOException) {
                    String string7 = String.valueOf(iOException.toString());
                    zzfjx2.zzuc(string7.length() != 0 ? "Unable to read body: ".concat(string7) : new String("Unable to read body: "));
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                String string8 = String.format("Response returned from proxy was not successful (expected 2xx, got %d %s). Response body:\n%s", statusLine.code, statusLine.message, zzfjx2.zzdfb());
                throw zzcd.zzppx.zztq(string8).zzdae();
            }
            return socket;
        }
        catch (IOException iOException) {
            throw zzcd.zzppx.zztq("Failed trying to connect with proxy").zzm(iOException).zzdae();
        }
    }

    private static String zza(zzfkn zzfkn2) throws IOException {
        zzfjx zzfjx2 = new zzfjx();
        do {
            if (zzfkn2.read(zzfjx2, 1L) != -1L) continue;
            String string = String.valueOf(zzfjx2.readByteString().zzdfe());
            throw new EOFException(string.length() != 0 ? "\\n not found: ".concat(string) : new String("\\n not found: "));
        } while (zzfjx2.zzdp(zzfjx2.size() - 1L) != 10);
        return zzfjx2.zzds(Long.MAX_VALUE);
    }

    public String toString() {
        String string = String.valueOf(this.zzpyi);
        String string2 = String.valueOf(this.zzqfu);
        return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("(").append(string2).append(")").toString();
    }

    @Override
    public final zzcv zzdbp() {
        return this.zzpyi;
    }

    final String zzddl() {
        URI uRI = zzbu.zztv(this.zzqfv);
        if (uRI.getHost() != null) {
            return uRI.getHost();
        }
        return this.zzqfv;
    }

    final int zzddm() {
        URI uRI = zzbu.zztv(this.zzqfv);
        if (uRI.getPort() != -1) {
            return uRI.getPort();
        }
        return this.zzqfu.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzqga != null) {
                return;
            }
            this.zzqga = zzcd.zzppx.zztq("Transport stopped");
            this.zzqfw.zzq(this.zzqga);
            this.zzddo();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzo(zzcd zzcd2) {
        this.shutdown();
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            Iterator<Map.Entry<Integer, zzu>> iterator = this.streams.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                iterator.remove();
                ((zzu)object2.getValue()).zzdde().zza(zzcd2, false, new zzaz());
            }
            object2 = this.zzqgf.iterator();
            while (object2.hasNext()) {
                ((zzu)object2.next()).zzdde().zza(zzcd2, true, new zzaz());
            }
            this.zzqgf.clear();
            this.zzddp();
            this.zzddo();
            return;
        }
    }

    @Override
    public final io.grpc.zza zzcza() {
        return io.grpc.zza.zzplq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final zzu[] zzddn() {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.values().toArray(zzqft);
        }
    }

    final void zzp(Throwable throwable) {
        zzdne.checkNotNull(throwable, "failureCause");
        zzcd zzcd2 = zzcd.zzppx.zzm(throwable);
        this.zza(0, zzfiy.zzqnc, zzcd2);
    }

    private final void zza(zzfiy zzfiy2, String string) {
        this.zza(0, zzfiy2, zzy.zza(zzfiy2).zztr(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, zzfiy zzfiy2, zzcd zzcd2) {
        Object object = this.lock;
        synchronized (object) {
            Map.Entry<Integer, zzu> entry;
            if (this.zzqga == null) {
                this.zzqga = zzcd2;
                this.zzqfw.zzq(zzcd2);
            }
            if (zzfiy2 != null && !this.zzqgb) {
                this.zzqgb = true;
                this.zzqfq.zza(0, zzfiy2, new byte[0]);
            }
            Iterator<Map.Entry<Integer, zzu>> iterator = this.streams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (entry.getKey() <= n) continue;
                iterator.remove();
                ((zzu)entry.getValue()).zzdde().zza(zzcd2, false, new zzaz());
            }
            entry = this.zzqgf.iterator();
            while (entry.hasNext()) {
                ((zzu)entry.next()).zzdde().zza(zzcd2, true, new zzaz());
            }
            this.zzqgf.clear();
            this.zzddp();
            this.zzddo();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zza(int n, zzcd zzcd2, zzfiy zzfiy2, zzaz zzaz2) {
        Object object = this.lock;
        synchronized (object) {
            zzu zzu2 = this.streams.remove(n);
            if (zzu2 != null) {
                if (zzfiy2 != null) {
                    this.zzqfq.zza(n, zzfiy.zzqnh);
                }
                if (zzcd2 != null) {
                    boolean bl = zzcd2.zzdab() == zzcf.zzpqc || zzcd2.zzdab() == zzcf.zzpqf;
                    zzu2.zzdde().zza(zzcd2, bl, zzaz2 != null ? zzaz2 : new zzaz());
                }
                if (!this.zzddk()) {
                    this.zzddo();
                    this.zzddp();
                }
            }
            return;
        }
    }

    private final void zzddo() {
        if (this.zzqga == null || !this.streams.isEmpty() || !this.zzqgf.isEmpty()) {
            return;
        }
        if (this.zzmnk) {
            return;
        }
        this.zzmnk = true;
        if (this.zzqgh != null) {
            this.zzqgh.zzdcj();
            this.zzpzf = zzee.zza(zzbu.zzpxb, this.zzpzf);
        }
        if (this.zzqgc != null) {
            this.zzqgc.zzo(this.zzddr());
            this.zzqgc = null;
        }
        if (!this.zzqgb) {
            this.zzqgb = true;
            this.zzqfq.zza(0, zzfiy.zzqmw, new byte[0]);
        }
        this.zzqfq.close();
    }

    private final void zzddp() {
        if (this.zzqgd && this.zzqgf.isEmpty() && this.streams.isEmpty()) {
            this.zzqgd = false;
            this.zzqfw.zzde(false);
            if (this.zzqgh != null) {
                this.zzqgh.zzdci();
            }
        }
    }

    private final void zzddq() {
        if (!this.zzqgd) {
            this.zzqgd = true;
            this.zzqfw.zzde(true);
            if (this.zzqgh != null) {
                this.zzqgh.zzdch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Throwable zzddr() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzqga != null) {
                return this.zzqga.zzdae();
            }
            return zzcd.zzppx.zztq("Connection closed").zzdae();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zzmr(int n) {
        Object object = this.lock;
        synchronized (object) {
            return n < this.nextStreamId && (n & 1) == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final zzu zzms(int n) {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.get(n);
        }
    }

    static zzcd zza(zzfiy zzfiy2) {
        zzcd zzcd2 = zzqfs.get((Object)zzfiy2);
        if (zzcd2 != null) {
            return zzcd2;
        }
        int n = zzfiy2.httpCode;
        return zzcd.zzppk.zztq(new StringBuilder(37).append("Unknown http2 error code: ").append(n).toString());
    }

    public final /* synthetic */ io.grpc.internal.zzz zza(zzbk zzbk2, zzaz zzaz2, zzg zzg2) {
        zzg zzg3 = zzg2;
        zzaz zzaz3 = zzaz2;
        zzbk zzbk3 = zzbk2;
        zzy zzy2 = this;
        zzdne.checkNotNull(zzbk3, "method");
        zzdne.checkNotNull(zzaz3, "headers");
        zzel zzel2 = zzel.zzb(zzg3, zzaz3);
        return new zzu(zzbk3, zzaz3, zzy2.zzqfq, zzy2, zzy2.zzqfr, zzy2.lock, zzy2.zzqbz, zzy2.zzqfv, zzy2.zzmiw, zzel2);
    }

    static /* synthetic */ boolean zza(zzy zzy2) {
        return zzy2.zzddj();
    }

    static /* synthetic */ zza zza(zzy zzy2, zza zza2) {
        zzy2.zzqfz = zza2;
        return zzy2.zzqfz;
    }

    static /* synthetic */ zza zzb(zzy zzy2) {
        return zzy2.zzqfz;
    }

    static /* synthetic */ Executor zzc(zzy zzy2) {
        return zzy2.zzloa;
    }

    static /* synthetic */ Socket zzf(zzy zzy2) {
        return zzy2.socket;
    }

    static /* synthetic */ InetSocketAddress zzh(zzy zzy2) {
        return zzy2.zzqgi;
    }

    static /* synthetic */ InetSocketAddress zzi(zzy zzy2) {
        return zzy2.zzqfu;
    }

    static /* synthetic */ Socket zza(zzy zzy2, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, String string2) throws IOException, zzci {
        return zzy2.zza(inetSocketAddress, inetSocketAddress2, string, string2);
    }

    static /* synthetic */ SSLSocketFactory zzj(zzy zzy2) {
        return zzy2.sslSocketFactory;
    }

    static /* synthetic */ HostnameVerifier zzk(zzy zzy2) {
        return zzy2.hostnameVerifier;
    }

    static /* synthetic */ zzfio zzl(zzy zzy2) {
        return zzy2.zzqgg;
    }

    static /* synthetic */ Socket zza(zzy zzy2, Socket socket) {
        zzy2.socket = socket;
        return zzy2.socket;
    }

    static /* synthetic */ int zzc(zzy zzy2, int n) {
        zzy2.zzqfy = 0;
        return 0;
    }

    static /* synthetic */ zzcb zza(zzy zzy2, zzcb zzcb2) {
        zzy2.zzqgc = null;
        return null;
    }

    static {
        EnumMap<zzfiy, zzcd> enumMap = new EnumMap<zzfiy, zzcd>(zzfiy.class);
        enumMap.put(zzfiy.zzqmw, zzcd.zzppw.zztq("No error: A GRPC status of OK should have been sent"));
        enumMap.put(zzfiy.zzqmx, zzcd.zzppw.zztq("Protocol error"));
        enumMap.put(zzfiy.zzqnc, zzcd.zzppw.zztq("Internal error"));
        enumMap.put(zzfiy.zzqnd, zzcd.zzppw.zztq("Flow control error"));
        enumMap.put(zzfiy.zzqne, zzcd.zzppw.zztq("Stream closed"));
        enumMap.put(zzfiy.zzqnf, zzcd.zzppw.zztq("Frame too large"));
        enumMap.put(zzfiy.zzqng, zzcd.zzppx.zztq("Refused stream"));
        enumMap.put(zzfiy.zzqnh, zzcd.zzppj.zztq("Cancelled"));
        enumMap.put(zzfiy.zzqni, zzcd.zzppw.zztq("Compression error"));
        enumMap.put(zzfiy.zzqnj, zzcd.zzppw.zztq("Connect error"));
        enumMap.put(zzfiy.zzqnk, zzcd.zzppr.zztq("Enhance your calm"));
        enumMap.put(zzfiy.zzqnl, zzcd.zzppp.zztq("Inadequate security"));
        zzqfs = Collections.unmodifiableMap(enumMap);
        zzlnr = Logger.getLogger(zzy.class.getName());
        zzqft = new zzu[0];
    }

    final class zza
    implements zzfja,
    Runnable {
        private zzfiz zzqgp;
        private boolean zzqgq = true;
        private /* synthetic */ zzy zzqgo;

        zza(zzy zzy2, zzfiz zzfiz2) {
            this.zzqgo = zzy2;
            this.zzqgp = zzfiz2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            String string = Thread.currentThread().getName();
            if (!zzbu.zzpwo) {
                Thread.currentThread().setName("OkHttpClientTransport");
            }
            try {
                while (this.zzqgp.zza(this)) {
                    if (this.zzqgo.zzqgh == null) continue;
                    this.zzqgo.zzqgh.zzdcg();
                }
                this.zzqgo.zza(0, zzfiy.zzqnc, zzcd.zzppx.zztq("End of stream or IOException"));
            }
            catch (Throwable throwable) {
                try {
                    this.zzqgo.zza(0, zzfiy.zzqmx, zzcd.zzppx.zzm(throwable));
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    try {
                        this.zzqgp.close();
                    }
                    catch (IOException iOException) {
                        zzlnr.logp(Level.INFO, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "run", "Exception closing frame reader", iOException);
                    }
                    this.zzqgo.zzqfw.zzdce();
                    if (zzbu.zzpwo) return;
                    Thread.currentThread().setName(string);
                }
            }
            try {
                this.zzqgp.close();
            }
            catch (IOException iOException) {
                zzlnr.logp(Level.INFO, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "run", "Exception closing frame reader", iOException);
            }
            this.zzqgo.zzqfw.zzdce();
            if (zzbu.zzpwo) return;
            Thread.currentThread().setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void data(boolean bl, int n, zzfjz zzfjz2, int n2) throws IOException {
            zzu zzu2 = this.zzqgo.zzms(n);
            if (zzu2 == null) {
                if (!this.zzqgo.zzmr(n)) {
                    this.zzqgo.zza(zzfiy.zzqmx, new StringBuilder(45).append("Received data for unknown stream: ").append(n).toString());
                    return;
                }
                this.zzqgo.zzqfq.zza(n, zzfiy.zzqmy);
                zzfjz2.zzdv(n2);
            } else {
                zzfjz2.zzdo(n2);
                zzfjx zzfjx2 = new zzfjx();
                zzfjx2.write(zzfjz2.zzddv(), n2);
                Object object = this.zzqgo.lock;
                synchronized (object) {
                    zzu2.zzdde().zza(zzfjx2, bl);
                }
            }
            this.zzqgo.zzqfy += n2;
            if (this.zzqgo.zzqfy >= Short.MAX_VALUE) {
                this.zzqgo.zzqfq.windowUpdate(0, this.zzqgo.zzqfy);
                zzy.zzc(this.zzqgo, 0);
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zza(boolean bl, boolean bl2, int n, int n2, List list, int n3) {
            boolean bl3 = false;
            Object object = this.zzqgo.lock;
            synchronized (object) {
                zzu zzu2 = (zzu)this.zzqgo.streams.get(n);
                if (zzu2 == null) {
                    if (this.zzqgo.zzmr(n)) {
                        this.zzqgo.zzqfq.zza(n, zzfiy.zzqmy);
                    } else {
                        bl3 = true;
                    }
                } else {
                    zzu2.zzdde().zza(list, bl2);
                }
            }
            if (bl3) {
                this.zzqgo.zza(zzfiy.zzqmx, new StringBuilder(47).append("Received header for unknown stream: ").append(n).toString());
            }
        }

        @Override
        public final void zza(int n, zzfiy zzfiy2) {
            this.zzqgo.zza(n, zzy.zza(zzfiy2).zztr("Rst Stream"), null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zza(boolean bl, zzfjn zzfjn2) {
            Object object = this.zzqgo.lock;
            synchronized (object) {
                int n;
                if (zzfjn2.isSet(4)) {
                    n = zzfjn2.get(4);
                    this.zzqgo.zzqge = n;
                }
                if (zzfjn2.isSet(7)) {
                    n = zzfjn2.get(7);
                    this.zzqgo.zzqfr.zzmt(n);
                }
                if (this.zzqgq) {
                    this.zzqgo.zzqfw.zzdcd();
                    this.zzqgq = false;
                }
                this.zzqgo.zzddk();
            }
            this.zzqgo.zzqfq.zza(zzfjn2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void ping(boolean bl, int n, int n2) {
            if (!bl) {
                this.zzqgo.zzqfq.ping(true, n, n2);
                return;
            }
            zzcb zzcb2 = null;
            long l = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
            Object object = this.zzqgo.lock;
            synchronized (object) {
                if (this.zzqgo.zzqgc != null) {
                    if (this.zzqgo.zzqgc.zzdbw() == l) {
                        zzcb2 = this.zzqgo.zzqgc;
                        zzy.zza(this.zzqgo, null);
                    } else {
                        zzlnr.logp(Level.WARNING, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "ping", String.format("Received unexpected ping ack. Expecting %d, got %d", this.zzqgo.zzqgc.zzdbw(), l));
                    }
                } else {
                    zzlnr.logp(Level.WARNING, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "ping", "Received unexpected ping ack. No ping outstanding");
                }
            }
            if (zzcb2 != null) {
                zzcb2.complete();
            }
        }

        @Override
        public final void zza(int n, zzfiy zzfiy2, zzfka zzfka2) {
            Object object;
            if (zzfiy2 == zzfiy.zzqnk) {
                object = zzfka2.zzdfd();
                zzlnr.logp(Level.WARNING, "io.grpc.okhttp.OkHttpClientTransport$ClientFrameHandler", "goAway", String.format("%s: Received GOAWAY with ENHANCE_YOUR_CALM. Debug data: %s", this, object));
                if ("too_many_pings".equals(object)) {
                    this.zzqgo.zzqgl.run();
                }
            }
            object = zzbu.zzb.zzdn(zzfiy2.httpCode).zztr("Received Goaway");
            if (zzfka2.size() > 0) {
                object = ((zzcd)object).zztr(zzfka2.zzdfd());
            }
            this.zzqgo.zza(n, null, (zzcd)object);
        }

        @Override
        public final void pushPromise(int n, int n2, List<zzfjc> list) throws IOException {
            this.zzqgo.zzqfq.zza(n, zzfiy.zzqmx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void windowUpdate(int n, long l) {
            if (l == 0L) {
                String string = "Received 0 flow control window increment.";
                if (n == 0) {
                    this.zzqgo.zza(zzfiy.zzqmx, string);
                    return;
                }
                this.zzqgo.zza(n, zzcd.zzppw.zztq(string), zzfiy.zzqmx, null);
                return;
            }
            boolean bl = false;
            Object object = this.zzqgo.lock;
            synchronized (object) {
                if (n == 0) {
                    this.zzqgo.zzqfr.zzc(null, (int)l);
                    return;
                }
                zzu zzu2 = (zzu)this.zzqgo.streams.get(n);
                if (zzu2 != null) {
                    this.zzqgo.zzqfr.zzc(zzu2, (int)l);
                } else if (!this.zzqgo.zzmr(n)) {
                    bl = true;
                }
            }
            if (bl) {
                this.zzqgo.zza(zzfiy.zzqmx, new StringBuilder(54).append("Received window_update for unknown stream: ").append(n).toString());
            }
        }
    }
}

