/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.firebase.Timestamp;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.SnapshotMetadata;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.ArrayValue;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.FieldValueOptions;
import com.google.firebase.firestore.model.value.ObjectValue;
import com.google.firebase.firestore.model.value.ReferenceValue;
import com.google.firebase.firestore.util.CustomClassMapper;
import com.google.firebase.firestore.util.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@PublicApi
public class DocumentSnapshot {
    private final FirebaseFirestore firestore;
    private final DocumentKey key;
    @Nullable
    private final Document doc;
    private final SnapshotMetadata metadata;

    DocumentSnapshot(FirebaseFirestore firestore, DocumentKey key, @Nullable Document doc, boolean isFromCache, boolean hasPendingWrites) {
        this.firestore = (FirebaseFirestore)Preconditions.checkNotNull((Object)firestore);
        this.key = (DocumentKey)Preconditions.checkNotNull((Object)key);
        this.doc = doc;
        this.metadata = new SnapshotMetadata(hasPendingWrites, isFromCache);
    }

    static DocumentSnapshot fromDocument(FirebaseFirestore firestore, Document doc, boolean fromCache, boolean hasPendingWrites) {
        return new DocumentSnapshot(firestore, doc.getKey(), doc, fromCache, hasPendingWrites);
    }

    static DocumentSnapshot fromNoDocument(FirebaseFirestore firestore, DocumentKey key, boolean fromCache, boolean hasPendingWrites) {
        return new DocumentSnapshot(firestore, key, null, fromCache, hasPendingWrites);
    }

    @NonNull
    @PublicApi
    public String getId() {
        return this.key.getPath().getLastSegment();
    }

    @NonNull
    @PublicApi
    public SnapshotMetadata getMetadata() {
        return this.metadata;
    }

    @PublicApi
    public boolean exists() {
        return this.doc != null;
    }

    @Nullable
    Document getDocument() {
        return this.doc;
    }

    @Nullable
    @PublicApi
    public Map<String, Object> getData() {
        return this.getData(ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    @PublicApi
    public Map<String, Object> getData(@NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        return this.doc == null ? null : this.convertObject(this.doc.getData(), FieldValueOptions.create(serverTimestampBehavior, this.firestore.getFirestoreSettings().areTimestampsInSnapshotsEnabled()));
    }

    @Nullable
    @PublicApi
    public <T> T toObject(@NonNull Class<T> valueType) {
        return this.toObject(valueType, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    @PublicApi
    public <T> T toObject(@NonNull Class<T> valueType, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull(valueType, (Object)"Provided POJO type must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        Map<String, Object> data = this.getData(serverTimestampBehavior);
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(data, valueType);
    }

    @PublicApi
    public boolean contains(@NonNull String field) {
        return this.contains(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field));
    }

    @PublicApi
    public boolean contains(@NonNull com.google.firebase.firestore.FieldPath fieldPath) {
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.doc != null && this.doc.getField(fieldPath.getInternalPath()) != null;
    }

    @Nullable
    @PublicApi
    public Object get(@NonNull String field) {
        return this.get(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field), ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    @PublicApi
    public Object get(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        return this.get(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field), serverTimestampBehavior);
    }

    @Nullable
    @PublicApi
    public Object get(@NonNull com.google.firebase.firestore.FieldPath fieldPath) {
        return this.get(fieldPath, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    @PublicApi
    public Object get(@NonNull com.google.firebase.firestore.FieldPath fieldPath, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        return this.getInternal(fieldPath.getInternalPath(), FieldValueOptions.create(serverTimestampBehavior, this.firestore.getFirestoreSettings().areTimestampsInSnapshotsEnabled()));
    }

    @Nullable
    @PublicApi
    public Boolean getBoolean(@NonNull String field) {
        return this.getTypedValue(field, Boolean.class);
    }

    @Nullable
    @PublicApi
    public Double getDouble(@NonNull String field) {
        Number val = this.getTypedValue(field, Number.class);
        return val != null ? Double.valueOf(val.doubleValue()) : null;
    }

    @Nullable
    @PublicApi
    public String getString(@NonNull String field) {
        return this.getTypedValue(field, String.class);
    }

    @Nullable
    @PublicApi
    public Long getLong(@NonNull String field) {
        Number val = this.getTypedValue(field, Number.class);
        return val != null ? Long.valueOf(val.longValue()) : null;
    }

    @Nullable
    @PublicApi
    public Date getDate(@NonNull String field) {
        return this.getDate(field, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    @PublicApi
    public Date getDate(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull((Object)field, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        Object maybeDate = this.getInternal(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field).getInternalPath(), FieldValueOptions.create(serverTimestampBehavior, false));
        return this.castTypedValue(maybeDate, field, Date.class);
    }

    @Nullable
    @PublicApi
    public Timestamp getTimestamp(@NonNull String field) {
        return this.getTimestamp(field, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    @PublicApi
    public Timestamp getTimestamp(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull((Object)field, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        Object maybeTimestamp = this.getInternal(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field).getInternalPath(), FieldValueOptions.create(serverTimestampBehavior, true));
        return this.castTypedValue(maybeTimestamp, field, Timestamp.class);
    }

    @Nullable
    @PublicApi
    public Blob getBlob(@NonNull String field) {
        return this.getTypedValue(field, Blob.class);
    }

    @Nullable
    @PublicApi
    public GeoPoint getGeoPoint(@NonNull String field) {
        return this.getTypedValue(field, GeoPoint.class);
    }

    @Nullable
    @PublicApi
    public DocumentReference getDocumentReference(@NonNull String field) {
        return this.getTypedValue(field, DocumentReference.class);
    }

    @NonNull
    @PublicApi
    public DocumentReference getReference() {
        return new DocumentReference(this.key, this.firestore);
    }

    @Nullable
    private <T> T getTypedValue(String field, Class<T> clazz) {
        Preconditions.checkNotNull((Object)field, (Object)"Provided field must not be null.");
        Object value = this.get(field, ServerTimestampBehavior.DEFAULT);
        return this.castTypedValue(value, field, clazz);
    }

    @Nullable
    private <T> T castTypedValue(Object value, String field, Class<T> clazz) {
        if (value == null) {
            return null;
        }
        if (!clazz.isInstance(value)) {
            throw new RuntimeException("Field '" + field + "' is not a " + clazz.getName());
        }
        return clazz.cast(value);
    }

    @Nullable
    private Object convertValue(FieldValue value, FieldValueOptions options) {
        if (value instanceof ObjectValue) {
            return this.convertObject((ObjectValue)value, options);
        }
        if (value instanceof ArrayValue) {
            return this.convertArray((ArrayValue)value, options);
        }
        if (value instanceof ReferenceValue) {
            DatabaseId database;
            ReferenceValue referenceValue = (ReferenceValue)value;
            DocumentKey key = (DocumentKey)referenceValue.value(options);
            DatabaseId refDatabase = ((ReferenceValue)value).getDatabaseId();
            if (!refDatabase.equals(database = this.firestore.getDatabaseId())) {
                Logger.warn("DocumentSnapshot", "Document %s contains a document reference within a different database (%s/%s) which is not supported. It will be treated as a reference in the current database (%s/%s) instead.", key.getPath(), refDatabase.getProjectId(), refDatabase.getDatabaseId(), database.getProjectId(), database.getDatabaseId());
            }
            return new DocumentReference(key, this.firestore);
        }
        return value.value(options);
    }

    private Map<String, Object> convertObject(ObjectValue objectValue, FieldValueOptions options) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : objectValue.getInternalValue()) {
            result.put((String)entry.getKey(), this.convertValue((FieldValue)entry.getValue(), options));
        }
        return result;
    }

    private List<Object> convertArray(ArrayValue arrayValue, FieldValueOptions options) {
        ArrayList<Object> result = new ArrayList<Object>(arrayValue.getInternalValue().size());
        for (FieldValue v : arrayValue.getInternalValue()) {
            result.add(this.convertValue(v, options));
        }
        return result;
    }

    @Nullable
    private Object getInternal(@NonNull FieldPath fieldPath, @NonNull FieldValueOptions options) {
        FieldValue val;
        if (this.doc != null && (val = this.doc.getField(fieldPath)) != null) {
            return this.convertValue(val, options);
        }
        return null;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DocumentSnapshot)) {
            return false;
        }
        DocumentSnapshot other = (DocumentSnapshot)obj;
        return this.firestore.equals(other.firestore) && this.key.equals(other.key) && (this.doc == null ? other.doc == null : this.doc.equals(other.doc)) && this.metadata.equals(other.metadata);
    }

    public int hashCode() {
        int hash = this.firestore.hashCode();
        hash = hash * 31 + this.key.hashCode();
        hash = hash * 31 + (this.doc != null ? this.doc.hashCode() : 0);
        hash = hash * 31 + this.metadata.hashCode();
        return hash;
    }

    public String toString() {
        return "DocumentSnapshot{key=" + this.key + ", metadata=" + this.metadata + ", doc=" + this.doc + '}';
    }

    @PublicApi
    public static enum ServerTimestampBehavior {
        NONE,
        ESTIMATE,
        PREVIOUS;

        static final ServerTimestampBehavior DEFAULT;

        static {
            DEFAULT = NONE;
        }
    }
}

