/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.model.mutation.FieldMask;
import java.util.ArrayList;
import java.util.List;

@PublicApi
public final class SetOptions {
    static final SetOptions OVERWRITE = new SetOptions(false, null);
    private static final SetOptions MERGE_ALL_FIELDS = new SetOptions(true, null);
    private final boolean merge;
    @Nullable
    private final FieldMask fieldMask;

    private SetOptions(boolean merge, @Nullable FieldMask fieldMask) {
        Preconditions.checkArgument((fieldMask == null || merge ? 1 : 0) != 0, (Object)"Cannot specify a fieldMask for non-merge sets()");
        this.merge = merge;
        this.fieldMask = fieldMask;
    }

    public boolean isMerge() {
        return this.merge;
    }

    @Nullable
    public FieldMask getFieldMask() {
        return this.fieldMask;
    }

    @NonNull
    @PublicApi
    public static SetOptions merge() {
        return MERGE_ALL_FIELDS;
    }

    @NonNull
    @PublicApi
    public static SetOptions mergeFields(List<String> fields) {
        ArrayList<com.google.firebase.firestore.model.FieldPath> fieldPaths = new ArrayList<com.google.firebase.firestore.model.FieldPath>();
        for (String field : fields) {
            fieldPaths.add(FieldPath.fromDotSeparatedPath(field).getInternalPath());
        }
        return new SetOptions(true, FieldMask.fromCollection(fieldPaths));
    }

    @NonNull
    @PublicApi
    public static SetOptions mergeFields(String ... fields) {
        ArrayList<com.google.firebase.firestore.model.FieldPath> fieldPaths = new ArrayList<com.google.firebase.firestore.model.FieldPath>();
        for (String field : fields) {
            fieldPaths.add(FieldPath.fromDotSeparatedPath(field).getInternalPath());
        }
        return new SetOptions(true, FieldMask.fromCollection(fieldPaths));
    }

    @NonNull
    @PublicApi
    public static SetOptions mergeFieldPaths(List<FieldPath> fields) {
        ArrayList<com.google.firebase.firestore.model.FieldPath> fieldPaths = new ArrayList<com.google.firebase.firestore.model.FieldPath>();
        for (FieldPath field : fields) {
            fieldPaths.add(field.getInternalPath());
        }
        return new SetOptions(true, FieldMask.fromCollection(fieldPaths));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetOptions that = (SetOptions)o;
        if (this.merge != that.merge) {
            return false;
        }
        return this.fieldMask != null ? this.fieldMask.equals(that.fieldMask) : that.fieldMask == null;
    }

    public int hashCode() {
        int result = this.merge ? 1 : 0;
        result = 31 * result + (this.fieldMask != null ? this.fieldMask.hashCode() : 0);
        return result;
    }
}

