/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.Transaction$$Lambda$1;
import com.google.firebase.firestore.core.UserData;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

@PublicApi
public class Transaction {
    private final com.google.firebase.firestore.core.Transaction transaction;
    private final FirebaseFirestore firestore;

    Transaction(com.google.firebase.firestore.core.Transaction transaction, FirebaseFirestore firestore) {
        this.transaction = (com.google.firebase.firestore.core.Transaction)Preconditions.checkNotNull((Object)transaction);
        this.firestore = (FirebaseFirestore)Preconditions.checkNotNull((Object)firestore);
    }

    @NonNull
    @PublicApi
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        return this.set(documentRef, data, SetOptions.OVERWRITE);
    }

    @NonNull
    @PublicApi
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data, @NonNull SetOptions options) {
        this.firestore.validateReference(documentRef);
        Preconditions.checkNotNull(data, (Object)"Provided data must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"Provided options must not be null.");
        UserData.ParsedSetData parsed = options.isMerge() ? this.firestore.getDataConverter().parseMergeData(data, options.getFieldMask()) : this.firestore.getDataConverter().parseSetData(data);
        this.transaction.set(documentRef.getKey(), parsed);
        return this;
    }

    @NonNull
    @PublicApi
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Object pojo) {
        return this.set(documentRef, this.firestore.getDataConverter().convertPOJO(pojo), SetOptions.OVERWRITE);
    }

    @NonNull
    @PublicApi
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Object pojo, @NonNull SetOptions options) {
        return this.set(documentRef, this.firestore.getDataConverter().convertPOJO(pojo), options);
    }

    @NonNull
    @PublicApi
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        UserData.ParsedUpdateData parsedData = this.firestore.getDataConverter().parseUpdateData(data);
        return this.update(documentRef, parsedData);
    }

    @NonNull
    @PublicApi
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        UserData.ParsedUpdateData parsedData = this.firestore.getDataConverter().parseUpdateData(Util.collectUpdateArguments(1, field, value, moreFieldsAndValues));
        return this.update(documentRef, parsedData);
    }

    @NonNull
    @PublicApi
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        UserData.ParsedUpdateData parsedData = this.firestore.getDataConverter().parseUpdateData(Util.collectUpdateArguments(1, fieldPath, value, moreFieldsAndValues));
        return this.update(documentRef, parsedData);
    }

    private Transaction update(@NonNull DocumentReference documentRef, @NonNull UserData.ParsedUpdateData updateData) {
        this.firestore.validateReference(documentRef);
        this.transaction.update(documentRef.getKey(), updateData);
        return this;
    }

    @NonNull
    @PublicApi
    public Transaction delete(@NonNull DocumentReference documentRef) {
        this.firestore.validateReference(documentRef);
        this.transaction.delete(documentRef.getKey());
        return this;
    }

    private Task<DocumentSnapshot> getAsync(DocumentReference documentRef) {
        return this.transaction.lookup(Collections.singletonList(documentRef.getKey())).continueWith(Executors.DIRECT_EXECUTOR, Transaction$$Lambda$1.lambdaFactory$(this));
    }

    @NonNull
    @PublicApi
    public DocumentSnapshot get(@NonNull DocumentReference documentRef) throws FirebaseFirestoreException {
        this.firestore.validateReference(documentRef);
        try {
            return (DocumentSnapshot)Tasks.await(this.getAsync(documentRef));
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FirebaseFirestoreException) {
                throw (FirebaseFirestoreException)((Object)ee.getCause());
            }
            throw new RuntimeException(ee.getCause());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    static /* synthetic */ DocumentSnapshot lambda$getAsync$0(Transaction this_, Task task) throws Exception {
        if (!task.isSuccessful()) {
            throw task.getException();
        }
        List docs = (List)task.getResult();
        if (docs.size() != 1) {
            throw Assert.fail("Mismatch in docs returned from document lookup.", new Object[0]);
        }
        MaybeDocument doc = (MaybeDocument)docs.get(0);
        if (doc instanceof Document) {
            return DocumentSnapshot.fromDocument(this_.firestore, (Document)doc, false, false);
        }
        if (doc instanceof NoDocument) {
            return DocumentSnapshot.fromNoDocument(this_.firestore, doc.getKey(), false, false);
        }
        throw Assert.fail("BatchGetDocumentsRequest returned unexpected document type: " + doc.getClass().getCanonicalName(), new Object[0]);
    }

    @PublicApi
    public static interface Function<TResult> {
        @Nullable
        @PublicApi
        public TResult apply(@NonNull Transaction var1) throws FirebaseFirestoreException;
    }
}

