/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

public class TargetIdGenerator {
    private static final int LOCAL_STATE_ID = 0;
    private static final int SYNC_ENGINE_ID = 1;
    private static final int RESERVED_BITS = 1;
    private int previousId;

    public static TargetIdGenerator getLocalStoreIdGenerator(int after) {
        return new TargetIdGenerator(0, after);
    }

    public static TargetIdGenerator getSyncEngineGenerator(int after) {
        return new TargetIdGenerator(1, after);
    }

    TargetIdGenerator(int generatorId, int after) {
        int afterWithoutGenerator = after >>> 1 << 1;
        int afterGenerator = after - afterWithoutGenerator;
        this.previousId = afterGenerator >= generatorId ? afterWithoutGenerator | generatorId : (afterWithoutGenerator | generatorId) - 2;
    }

    public int nextId() {
        this.previousId += 2;
        return this.previousId;
    }
}

