/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.database.Cursor;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.local.SQLiteRemoteDocumentCache$$Lambda$1;
import com.google.firebase.firestore.local.SQLiteRemoteDocumentCache$$Lambda$2;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class SQLiteRemoteDocumentCache
implements RemoteDocumentCache {
    private final SQLitePersistence db;
    private final LocalSerializer serializer;

    SQLiteRemoteDocumentCache(SQLitePersistence persistence, LocalSerializer serializer) {
        this.db = persistence;
        this.serializer = serializer;
    }

    @Override
    public void add(MaybeDocument maybeDocument) {
        String path = this.pathForKey(maybeDocument.getKey());
        com.google.firebase.firestore.proto.MaybeDocument message = this.serializer.encodeMaybeDocument(maybeDocument);
        this.db.execute("INSERT OR REPLACE INTO remote_documents (path, contents) VALUES (?, ?)", path, message.toByteArray());
    }

    @Override
    public void remove(DocumentKey documentKey) {
        String path = this.pathForKey(documentKey);
        this.db.execute("DELETE FROM remote_documents WHERE path = ?", path);
    }

    @Override
    @Nullable
    public MaybeDocument get(DocumentKey documentKey) {
        String path = this.pathForKey(documentKey);
        return (MaybeDocument)this.db.query("SELECT contents FROM remote_documents WHERE path = ?").binding(path).firstValue(SQLiteRemoteDocumentCache$$Lambda$1.lambdaFactory$(this));
    }

    @Override
    public ImmutableSortedMap<DocumentKey, Document> getAllDocumentsMatchingQuery(Query query) {
        ResourcePath prefix = query.getPath();
        int immediateChildrenPathLength = prefix.length() + 1;
        String prefixPath = EncodedPath.encode(prefix);
        String prefixSuccessorPath = EncodedPath.prefixSuccessor(prefixPath);
        HashMap results = new HashMap();
        this.db.query("SELECT path, contents FROM remote_documents WHERE path >= ? AND path < ?").binding(prefixPath, prefixSuccessorPath).forEach(SQLiteRemoteDocumentCache$$Lambda$2.lambdaFactory$(this, immediateChildrenPathLength, query, results));
        return ImmutableSortedMap.Builder.fromMap(results, DocumentKey.comparator());
    }

    private String pathForKey(DocumentKey key) {
        return EncodedPath.encode(key.getPath());
    }

    private MaybeDocument decodeMaybeDocument(byte[] bytes) {
        try {
            return this.serializer.decodeMaybeDocument(com.google.firebase.firestore.proto.MaybeDocument.parseFrom(bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw Assert.fail("MaybeDocument failed to parse: %s", new Object[]{e});
        }
    }

    static /* synthetic */ void lambda$getAllDocumentsMatchingQuery$1(SQLiteRemoteDocumentCache this_, int immediateChildrenPathLength, Query query, Map results, Cursor row) {
        ResourcePath path = EncodedPath.decodeResourcePath(row.getString(0));
        if (path.length() != immediateChildrenPathLength) {
            return;
        }
        MaybeDocument maybeDoc = this_.decodeMaybeDocument(row.getBlob(1));
        if (!(maybeDoc instanceof Document)) {
            return;
        }
        Document doc = (Document)maybeDoc;
        if (!query.matches(doc)) {
            return;
        }
        results.put(doc.getKey(), doc);
    }

    static /* synthetic */ MaybeDocument lambda$get$0(SQLiteRemoteDocumentCache this_, Cursor row) {
        return this_.decodeMaybeDocument(row.getBlob(0));
    }
}

