/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.remote.ExistenceFilter;
import com.google.firebase.firestore.remote.WatchStream;
import com.google.firebase.firestore.util.Assert;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.util.List;
import javax.annotation.Nullable;

public abstract class WatchChange {
    private WatchChange() {
    }

    public static class WatchTargetChange
    extends WatchChange {
        private final WatchTargetChangeType changeType;
        private final List<Integer> targetIds;
        private final ByteString resumeToken;
        @Nullable
        private final Status cause;

        public WatchTargetChange(WatchTargetChangeType changeType, List<Integer> targetIds) {
            this(changeType, targetIds, WatchStream.EMPTY_RESUME_TOKEN, null);
        }

        public WatchTargetChange(WatchTargetChangeType changeType, List<Integer> targetIds, ByteString resumeToken) {
            this(changeType, targetIds, resumeToken, null);
        }

        public WatchTargetChange(WatchTargetChangeType changeType, List<Integer> targetIds, ByteString resumeToken, @Nullable Status cause) {
            Assert.hardAssert(cause == null || changeType == WatchTargetChangeType.Removed, "Got cause for a target change that was not a removal", new Object[0]);
            this.changeType = changeType;
            this.targetIds = targetIds;
            this.resumeToken = resumeToken;
            this.cause = cause != null && !cause.isOk() ? cause : null;
        }

        public WatchTargetChangeType getChangeType() {
            return this.changeType;
        }

        public List<Integer> getTargetIds() {
            return this.targetIds;
        }

        public ByteString getResumeToken() {
            return this.resumeToken;
        }

        @Nullable
        public Status getCause() {
            return this.cause;
        }

        public String toString() {
            return "WatchTargetChange{changeType=" + (Object)((Object)this.changeType) + ", targetIds=" + this.targetIds + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WatchTargetChange that = (WatchTargetChange)o;
            if (this.changeType != that.changeType) {
                return false;
            }
            if (!this.targetIds.equals(that.targetIds)) {
                return false;
            }
            if (!this.resumeToken.equals((Object)that.resumeToken)) {
                return false;
            }
            if (this.cause != null) {
                return that.cause != null && this.cause.getCode().equals((Object)that.cause.getCode());
            }
            return that.cause == null;
        }

        public int hashCode() {
            int result = this.changeType.hashCode();
            result = 31 * result + this.targetIds.hashCode();
            result = 31 * result + this.resumeToken.hashCode();
            result = 31 * result + (this.cause != null ? this.cause.getCode().hashCode() : 0);
            return result;
        }
    }

    public static enum WatchTargetChangeType {
        NoChange,
        Added,
        Removed,
        Current,
        Reset;

    }

    public static class ExistenceFilterWatchChange
    extends WatchChange {
        private final int targetId;
        private final ExistenceFilter existenceFilter;

        public ExistenceFilterWatchChange(int targetId, ExistenceFilter existenceFilter) {
            this.targetId = targetId;
            this.existenceFilter = existenceFilter;
        }

        public int getTargetId() {
            return this.targetId;
        }

        public ExistenceFilter getExistenceFilter() {
            return this.existenceFilter;
        }

        public String toString() {
            return "ExistenceFilterWatchChange{targetId=" + this.targetId + ", existenceFilter=" + this.existenceFilter + '}';
        }
    }

    public static class DocumentChange
    extends WatchChange {
        private final List<Integer> updatedTargetIds;
        private final List<Integer> removedTargetIds;
        private final DocumentKey documentKey;
        @Nullable
        private final MaybeDocument newDocument;

        public DocumentChange(List<Integer> updatedTargetIds, List<Integer> removedTargetIds, DocumentKey key, @Nullable MaybeDocument document) {
            this.updatedTargetIds = updatedTargetIds;
            this.removedTargetIds = removedTargetIds;
            this.documentKey = key;
            this.newDocument = document;
        }

        public List<Integer> getUpdatedTargetIds() {
            return this.updatedTargetIds;
        }

        public List<Integer> getRemovedTargetIds() {
            return this.removedTargetIds;
        }

        @Nullable
        public MaybeDocument getNewDocument() {
            return this.newDocument;
        }

        public DocumentKey getDocumentKey() {
            return this.documentKey;
        }

        public String toString() {
            return "DocumentChange{updatedTargetIds=" + this.updatedTargetIds + ", removedTargetIds=" + this.removedTargetIds + ", key=" + this.documentKey + ", newDocument=" + this.newDocument + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocumentChange that = (DocumentChange)o;
            if (!this.updatedTargetIds.equals(that.updatedTargetIds)) {
                return false;
            }
            if (!this.removedTargetIds.equals(that.removedTargetIds)) {
                return false;
            }
            if (!this.documentKey.equals(that.documentKey)) {
                return false;
            }
            return this.newDocument != null ? this.newDocument.equals(that.newDocument) : that.newDocument == null;
        }

        public int hashCode() {
            int result = this.updatedTargetIds.hashCode();
            result = 31 * result + this.removedTargetIds.hashCode();
            result = 31 * result + this.documentKey.hashCode();
            result = 31 * result + (this.newDocument != null ? this.newDocument.hashCode() : 0);
            return result;
        }
    }
}

