/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.remote.AbstractStream;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firebase.firestore.remote.Stream;
import com.google.firebase.firestore.remote.WatchChange;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.FirestoreChannel;
import com.google.firestore.v1beta1.FirestoreGrpc;
import com.google.firestore.v1beta1.ListenRequest;
import com.google.firestore.v1beta1.ListenResponse;
import com.google.protobuf.ByteString;
import java.util.Map;

public class WatchStream
extends AbstractStream<ListenRequest, ListenResponse, Callback> {
    public static final ByteString EMPTY_RESUME_TOKEN = ByteString.EMPTY;
    private final RemoteSerializer serializer;

    WatchStream(FirestoreChannel channel, AsyncQueue workerQueue, RemoteSerializer serializer, Callback listener) {
        super(channel, FirestoreGrpc.getListenMethod(), workerQueue, AsyncQueue.TimerId.LISTEN_STREAM_CONNECTION_BACKOFF, AsyncQueue.TimerId.LISTEN_STREAM_IDLE, listener);
        this.serializer = serializer;
    }

    public void watchQuery(QueryData queryData) {
        Assert.hardAssert(this.isOpen(), "Watching queries requires an open stream", new Object[0]);
        ListenRequest.Builder request = ListenRequest.newBuilder().setDatabase(this.serializer.databaseName()).setAddTarget(this.serializer.encodeTarget(queryData));
        Map<String, String> labels = this.serializer.encodeListenRequestLabels(queryData);
        if (labels != null) {
            request.putAllLabels(labels);
        }
        this.writeRequest((ListenRequest)request.build());
    }

    public void unwatchTarget(int targetId) {
        Assert.hardAssert(this.isOpen(), "Unwatching targets requires an open stream", new Object[0]);
        ListenRequest request = (ListenRequest)ListenRequest.newBuilder().setDatabase(this.serializer.databaseName()).setRemoveTarget(targetId).build();
        this.writeRequest(request);
    }

    @Override
    public void onNext(ListenResponse listenResponse) {
        this.backoff.reset();
        WatchChange watchChange = this.serializer.decodeWatchChange(listenResponse);
        SnapshotVersion snapshotVersion = this.serializer.decodeVersionFromListenResponse(listenResponse);
        ((Callback)this.listener).onWatchChange(snapshotVersion, watchChange);
    }

    static interface Callback
    extends Stream.StreamCallback {
        public void onWatchChange(SnapshotVersion var1, WatchChange var2);
    }
}

