/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore$$Lambda$1;
import com.google.firebase.firestore.FirebaseFirestore$$Lambda$2;
import com.google.firebase.firestore.FirebaseFirestore$$Lambda$3;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.FirestoreMultiDbComponent;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.UserDataConverter;
import com.google.firebase.firestore.WriteBatch;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.EmptyCredentialsProvider;
import com.google.firebase.firestore.auth.FirebaseAuthCredentialsProvider;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.core.FirestoreClient;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

@PublicApi
public class FirebaseFirestore {
    private static final String TAG = "FirebaseFirestore";
    private final Context context;
    private final DatabaseId databaseId;
    private final String persistenceKey;
    private final CredentialsProvider credentialsProvider;
    private final AsyncQueue asyncQueue;
    private final FirebaseApp firebaseApp;
    private FirebaseFirestoreSettings settings;
    private volatile FirestoreClient client;
    private final UserDataConverter dataConverter;

    @NonNull
    @PublicApi
    public static FirebaseFirestore getInstance() {
        FirebaseApp app = FirebaseApp.getInstance();
        if (app == null) {
            throw new IllegalStateException("You must call FirebaseApp.initializeApp first.");
        }
        return FirebaseFirestore.getInstance(app, "(default)");
    }

    @NonNull
    @PublicApi
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp app) {
        return FirebaseFirestore.getInstance(app, "(default)");
    }

    @NonNull
    private static FirebaseFirestore getInstance(@NonNull FirebaseApp app, @NonNull String database) {
        Preconditions.checkNotNull((Object)app, (Object)"Provided FirebaseApp must not be null.");
        FirestoreMultiDbComponent component = (FirestoreMultiDbComponent)app.get(FirestoreMultiDbComponent.class);
        Preconditions.checkNotNull((Object)component, (Object)"Firestore component is not present.");
        return component.get(database);
    }

    @NonNull
    static FirebaseFirestore newInstance(@NonNull Context context, @NonNull FirebaseApp app, @Nullable InternalAuthProvider authProvider, @NonNull String database) {
        CredentialsProvider provider;
        String projectId = app.getOptions().getProjectId();
        if (projectId == null) {
            throw new IllegalArgumentException("FirebaseOptions.getProjectId() cannot be null");
        }
        DatabaseId databaseId = DatabaseId.forDatabase(projectId, database);
        AsyncQueue queue = new AsyncQueue();
        if (authProvider == null) {
            Logger.debug(TAG, "Firebase Auth not available, falling back to unauthenticated usage.", new Object[0]);
            provider = new EmptyCredentialsProvider();
        } else {
            provider = new FirebaseAuthCredentialsProvider(authProvider);
        }
        queue.enqueueAndForget(FirebaseFirestore$$Lambda$1.lambdaFactory$(context));
        String persistenceKey = app.getName();
        return new FirebaseFirestore(context, databaseId, persistenceKey, provider, queue, app);
    }

    @VisibleForTesting
    FirebaseFirestore(Context context, DatabaseId databaseId, String persistenceKey, CredentialsProvider credentialsProvider, AsyncQueue asyncQueue, @Nullable FirebaseApp firebaseApp) {
        this.context = (Context)Preconditions.checkNotNull((Object)context);
        this.databaseId = (DatabaseId)Preconditions.checkNotNull((Object)((DatabaseId)Preconditions.checkNotNull((Object)databaseId)));
        this.dataConverter = new UserDataConverter(databaseId);
        this.persistenceKey = (String)Preconditions.checkNotNull((Object)persistenceKey);
        this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
        this.asyncQueue = (AsyncQueue)Preconditions.checkNotNull((Object)asyncQueue);
        this.firebaseApp = firebaseApp;
        this.settings = new FirebaseFirestoreSettings.Builder().build();
    }

    @NonNull
    @PublicApi
    public FirebaseFirestoreSettings getFirestoreSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApi
    public void setFirestoreSettings(@NonNull FirebaseFirestoreSettings settings) {
        DatabaseId databaseId = this.databaseId;
        synchronized (databaseId) {
            Preconditions.checkNotNull((Object)settings, (Object)"Provided settings must not be null.");
            if (this.client != null && !this.settings.equals(settings)) {
                throw new IllegalStateException("FirebaseFirestore has already been started and its settings can no longer be changed. You can only call setFirestoreSettings() before calling any other methods on a FirebaseFirestore object.");
            }
            this.settings = settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureClientConfigured() {
        if (this.client != null) {
            return;
        }
        DatabaseId databaseId = this.databaseId;
        synchronized (databaseId) {
            if (this.client != null) {
                return;
            }
            DatabaseInfo databaseInfo = new DatabaseInfo(this.databaseId, this.persistenceKey, this.settings.getHost(), this.settings.isSslEnabled());
            this.client = new FirestoreClient(this.context, databaseInfo, this.settings, this.credentialsProvider, this.asyncQueue);
        }
    }

    @NonNull
    @PublicApi
    public FirebaseApp getApp() {
        return this.firebaseApp;
    }

    @NonNull
    @PublicApi
    public CollectionReference collection(@NonNull String collectionPath) {
        Preconditions.checkNotNull((Object)collectionPath, (Object)"Provided collection path must not be null.");
        this.ensureClientConfigured();
        return new CollectionReference(ResourcePath.fromString(collectionPath), this);
    }

    @NonNull
    @PublicApi
    public DocumentReference document(@NonNull String documentPath) {
        Preconditions.checkNotNull((Object)documentPath, (Object)"Provided document path must not be null.");
        this.ensureClientConfigured();
        return DocumentReference.forPath(ResourcePath.fromString(documentPath), this);
    }

    private <TResult> Task<TResult> runTransaction(Transaction.Function<TResult> updateFunction, Executor executor) {
        this.ensureClientConfigured();
        Function wrappedUpdateFunction = FirebaseFirestore$$Lambda$2.lambdaFactory$(this, executor, updateFunction);
        return this.client.transaction(wrappedUpdateFunction, 5);
    }

    @NonNull
    @PublicApi
    public <TResult> Task<TResult> runTransaction(@NonNull Transaction.Function<TResult> updateFunction) {
        Preconditions.checkNotNull(updateFunction, (Object)"Provided transaction update function must not be null.");
        return this.runTransaction(updateFunction, Transaction.getDefaultExecutor());
    }

    @NonNull
    @PublicApi
    public WriteBatch batch() {
        this.ensureClientConfigured();
        return new WriteBatch(this);
    }

    @VisibleForTesting
    Task<Void> shutdown() {
        if (this.client == null) {
            return Tasks.forResult(null);
        }
        return this.client.shutdown();
    }

    @VisibleForTesting
    AsyncQueue getAsyncQueue() {
        return this.asyncQueue;
    }

    @PublicApi
    public Task<Void> enableNetwork() {
        this.ensureClientConfigured();
        return this.client.enableNetwork();
    }

    @PublicApi
    public Task<Void> disableNetwork() {
        this.ensureClientConfigured();
        return this.client.disableNetwork();
    }

    @PublicApi
    public static void setLoggingEnabled(boolean loggingEnabled) {
        if (loggingEnabled) {
            Logger.setLogLevel(Logger.Level.DEBUG);
        } else {
            Logger.setLogLevel(Logger.Level.WARN);
        }
    }

    FirestoreClient getClient() {
        return this.client;
    }

    DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    UserDataConverter getDataConverter() {
        return this.dataConverter;
    }

    void validateReference(DocumentReference docRef) {
        Preconditions.checkNotNull((Object)docRef, (Object)"Provided DocumentReference must not be null.");
        if (docRef.getFirestore() != this) {
            throw new IllegalArgumentException("Provided document reference is from a different Firestore instance.");
        }
    }

    static /* synthetic */ Task lambda$runTransaction$2(FirebaseFirestore this_, Executor executor, Transaction.Function updateFunction, Transaction internalTransaction) {
        return Tasks.call((Executor)executor, (Callable)FirebaseFirestore$$Lambda$3.lambdaFactory$(this_, updateFunction, internalTransaction));
    }

    static /* synthetic */ Object lambda$runTransaction$1(FirebaseFirestore this_, Transaction.Function updateFunction, Transaction internalTransaction) throws Exception {
        return updateFunction.apply(new com.google.firebase.firestore.Transaction(internalTransaction, this_));
    }

    static /* synthetic */ void lambda$newInstance$0(Context context) {
        try {
            ProviderInstaller.installIfNeeded((Context)context);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException e) {
            Logger.warn("Firestore", "Failed to update ssl context", new Object[0]);
        }
    }
}

